/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.source.formatter.checks.BaseJavaTermCheck;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import com.liferay.source.formatter.checks.util.SourceUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaConstructor;
import com.liferay.source.formatter.parser.JavaTerm;
import com.liferay.source.formatter.util.ThreadSafeSortedClassLibraryBuilder;
import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.library.ClassLibraryBuilder;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.parser.ParseException;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaRedundantConstructorCheck
extends BaseJavaTermCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) {
        String constructorContent = javaTerm.getContent();
        String indent = SourceUtil.getIndent(constructorContent);
        if (!constructorContent.contains("{\n" + indent + "}\n")) {
            return constructorContent;
        }
        JavaClass javaClass = javaTerm.getParentJavaClass();
        if (this._getConstructorCount(javaClass) > 1) {
            return constructorContent;
        }
        String classAccessModifier = javaClass.getAccessModifier();
        String constructorAccessModifier = javaTerm.getAccessModifier();
        if (constructorAccessModifier.equals("private") && !classAccessModifier.equals("private") || constructorAccessModifier.equals("protected") && !classAccessModifier.equals("private") && !classAccessModifier.equals("protected")) {
            return constructorContent;
        }
        Pattern pattern = Pattern.compile("class " + javaClass.getName() + "[ \t\n]+extends");
        Matcher matcher = pattern.matcher(javaClass.getContent());
        if (!matcher.find()) {
            return constructorContent;
        }
        JavaProjectBuilder javaProjectBuilder = new JavaProjectBuilder((ClassLibraryBuilder)new ThreadSafeSortedClassLibraryBuilder());
        try {
            javaProjectBuilder.addSource((Reader)new UnsyncStringReader(fileContent));
        }
        catch (ParseException pe) {
            return constructorContent;
        }
        com.thoughtworks.qdox.model.JavaClass qdoxJavaClass = javaProjectBuilder.getClassByName(this._getClassName(fileContent, javaClass));
        com.thoughtworks.qdox.model.JavaClass superJavaClass = qdoxJavaClass.getSuperJavaClass();
        JavaMethod superJavaClassConstructor = superJavaClass.getMethodBySignature(superJavaClass.getName(), null);
        if (superJavaClassConstructor != null && ListUtil.isEmpty(superJavaClassConstructor.getExceptions())) {
            return "";
        }
        return constructorContent;
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CONSTRUCTOR};
    }

    private String _getClassName(String fileContent, JavaClass javaClass) {
        if (javaClass.getParentJavaClass() == null) {
            return JavaSourceUtil.getPackagePath(fileContent) + "." + javaClass.getName();
        }
        return this._getClassName(fileContent, javaClass.getParentJavaClass()) + "$" + javaClass.getName();
    }

    private int _getConstructorCount(JavaClass javaClass) {
        int count = 0;
        for (JavaTerm javaTerm : javaClass.getChildJavaTerms()) {
            if (!(javaTerm instanceof JavaConstructor)) continue;
            ++count;
        }
        return count;
    }
}

