/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ImportPackage;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.comparator.ElementComparator;
import com.liferay.source.formatter.checks.util.SourceUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.Element;

public class XMLSpringFileCheck
extends BaseFileCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (fileName.endsWith("-spring.xml")) {
            this._checkSpringXML(fileName, content);
        }
        return content;
    }

    private void _checkSpringXML(String fileName, String content) throws Exception {
        Document document = SourceUtil.readXML(content);
        this.checkElementOrder(fileName, document.getRootElement(), "bean", null, new SpringBeanElementComparator("id"));
    }

    private class SpringBeanElementComparator
    extends ElementComparator {
        public SpringBeanElementComparator(String nameAttribute) {
            super(nameAttribute);
        }

        @Override
        public int compare(Element element1, Element element2) {
            String startKey;
            String elementName1 = this.getElementName(element1);
            String elementName2 = this.getElementName(element2);
            if (elementName1 == null || elementName2 == null) {
                return 0;
            }
            int startsWithWeight = StringUtil.startsWithWeight(elementName1, elementName2);
            if (startsWithWeight != 0 && (startKey = elementName1.substring(0, startsWithWeight)).contains(".service.")) {
                return this._compareServiceElements(elementName1, elementName2);
            }
            if (StringUtil.count(elementName1, ".") > 1 && StringUtil.count(elementName2, ".") > 1) {
                ImportPackage importPackage1 = new ImportPackage(elementName1, false, elementName1);
                ImportPackage importPackage2 = new ImportPackage(elementName2, false, elementName2);
                return importPackage1.compareTo(importPackage2);
            }
            if (StringUtil.count(elementName1, ".") > 1) {
                return -1;
            }
            return super.compare(element1, element2);
        }

        @Override
        public String getElementName(Element element) {
            String elementName = super.getElementName(element);
            if (elementName != null && StringUtil.count(elementName, ".") > 1) {
                return elementName;
            }
            return element.attributeValue("class");
        }

        private int _compareServiceElements(String name1, String name2) {
            SpringBeanServiceElement springBeanServiceElemen1 = new SpringBeanServiceElement(name1);
            SpringBeanServiceElement springBeanServiceElemen2 = new SpringBeanServiceElement(name2);
            return springBeanServiceElemen1.compareTo(springBeanServiceElemen2);
        }

        private class SpringBeanServiceElement
        implements Comparable<SpringBeanServiceElement> {
            private static final int _FINDER = 4;
            private static final int _LOCAL_SERVICE = 1;
            private static final int _PERSISTENCE = 3;
            private static final int _SERVICE = 2;
            private String _beanObjectName = "";
            private final Pattern _finderPattern = Pattern.compile("\\.service\\.persistence\\.(\\w+)Finder");
            private final Pattern _localServicePattern = Pattern.compile("\\.service\\.(\\w+)LocalService");
            private final Pattern _persistencePattern = Pattern.compile("\\.service\\.persistence\\.(\\w+)Persistence");
            private final Pattern _servicePattern = Pattern.compile("\\.service\\.(\\w+)Service");
            private int _type = -1;

            public SpringBeanServiceElement(String name) {
                Matcher matcher = this._localServicePattern.matcher(name);
                if (matcher.find()) {
                    this._beanObjectName = matcher.group(1);
                    this._type = 1;
                    return;
                }
                matcher = this._servicePattern.matcher(name);
                if (matcher.find()) {
                    this._beanObjectName = matcher.group(1);
                    this._type = 2;
                    return;
                }
                matcher = this._persistencePattern.matcher(name);
                if (matcher.find()) {
                    this._beanObjectName = matcher.group(1);
                    this._type = 3;
                    return;
                }
                matcher = this._finderPattern.matcher(name);
                if (matcher.find()) {
                    this._beanObjectName = matcher.group(1);
                    this._type = 4;
                }
            }

            @Override
            public int compareTo(SpringBeanServiceElement springBeanServiceElement) {
                if (this._beanObjectName.equals(springBeanServiceElement.getBeanObjectName())) {
                    return this._type - springBeanServiceElement.getType();
                }
                NaturalOrderStringComparator comparator = new NaturalOrderStringComparator();
                return comparator.compare(this._beanObjectName, springBeanServiceElement.getBeanObjectName());
            }

            public String getBeanObjectName() {
                return this._beanObjectName;
            }

            public int getType() {
                return this._type;
            }
        }
    }
}

