/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.liferay.source.formatter.util.ThreadSafeSortedClassLibraryBuilder;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.library.ClassLibraryBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaSource;
import com.thoughtworks.qdox.parser.ParseException;
import java.io.File;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PersistenceCallCheck
extends AbstractCheck {
    private static final String _MSG_ILLEGAL_PERSISTENCE_CALL = "persistence.call.illegal";

    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    public void visitToken(DetailAST detailAST) {
        DetailAST parent = detailAST.getParent();
        if (parent != null) {
            return;
        }
        FileContents fileContents = this.getFileContents();
        String fileName = StringUtil.replace(fileContents.getFileName(), '\\', '/');
        if (!fileName.contains("/modules/")) {
            return;
        }
        FileText fileText = fileContents.getText();
        String content = (String)fileText.getFullText();
        JavaProjectBuilder javaProjectBuilder = new JavaProjectBuilder((ClassLibraryBuilder)new ThreadSafeSortedClassLibraryBuilder());
        try {
            javaProjectBuilder.addSource((Reader)new UnsyncStringReader(content));
        }
        catch (ParseException pe) {
            return;
        }
        JavaClass javaClass = this._getJavaClass(javaProjectBuilder, fileName);
        javaProjectBuilder = this._addExtendedClassSource(javaProjectBuilder, javaClass, content, fileName);
        List<String> importNames = this._getImportNames(detailAST);
        Map<String, String> variablesMap = this._getVariablesMap(javaProjectBuilder);
        List<DetailAST> methodCallASTList = DetailASTUtil.getAllChildTokens(detailAST, true, 27);
        for (DetailAST methodCallAST : methodCallASTList) {
            this._checkMethodCall(methodCallAST, importNames, variablesMap, javaClass.getPackageName());
        }
    }

    private JavaProjectBuilder _addExtendedClassSource(JavaProjectBuilder javaProjectBuilder, JavaClass javaClass, String content, String fileName) {
        Pattern pattern = Pattern.compile("\\s" + javaClass.getName() + "\\s+extends\\s+(\\S+)\\s");
        Matcher matcher = pattern.matcher(content);
        if (!matcher.find()) {
            return javaProjectBuilder;
        }
        String extendedClassName = matcher.group(1);
        String fullyQualifiedName = this._getFullyQualifiedName(extendedClassName, javaProjectBuilder);
        if (fullyQualifiedName == null || !fullyQualifiedName.startsWith("com.liferay")) {
            return javaProjectBuilder;
        }
        int pos = fileName.lastIndexOf("/com/liferay/");
        String extendedClassFileName = fileName.substring(0, pos + 1) + StringUtil.replace(fullyQualifiedName, '.', '/') + ".java";
        try {
            javaProjectBuilder.addSource(new File(extendedClassFileName));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return javaProjectBuilder;
    }

    private void _checkClass(String className, List<String> importNames, String packageName, int lineNo) {
        for (String importName : importNames) {
            if (!importName.endsWith("." + className)) continue;
            int pos = importName.indexOf(".service.persistence.");
            if (pos == -1) {
                return;
            }
            if (packageName.startsWith(importName.substring(0, pos))) continue;
            this.log(lineNo, _MSG_ILLEGAL_PERSISTENCE_CALL, new Object[]{importName});
        }
    }

    private void _checkMethodCall(DetailAST methodCallAST, List<String> importNames, Map<String, String> variablesMap, String packageName) {
        String methodName;
        DetailAST childAST = methodCallAST.getFirstChild();
        if (childAST.getType() != 59) {
            return;
        }
        if ((childAST = childAST.getFirstChild()).getType() != 58) {
            return;
        }
        DetailAST siblingAST = childAST.getNextSibling();
        if (siblingAST.getType() == 58 && ((methodName = siblingAST.getText()).equals("clearCache") || methodName.startsWith("create"))) {
            return;
        }
        String fieldName = childAST.getText();
        if (fieldName.matches("[A-Z].*")) {
            this._checkClass(fieldName, importNames, packageName, methodCallAST.getLineNo());
        } else {
            this._checkVariable(fieldName, variablesMap, packageName, methodCallAST.getLineNo());
        }
    }

    private void _checkVariable(String variableName, Map<String, String> variablesMap, String packageName, int lineNo) {
        String fullyQualifiedTypeName = variablesMap.get(variableName);
        if (fullyQualifiedTypeName == null) {
            return;
        }
        int pos = fullyQualifiedTypeName.indexOf(".service.persistence.");
        if (pos == -1) {
            return;
        }
        if (!packageName.startsWith(fullyQualifiedTypeName.substring(0, pos))) {
            this.log(lineNo, _MSG_ILLEGAL_PERSISTENCE_CALL, new Object[]{fullyQualifiedTypeName});
        }
    }

    private String _getFullyQualifiedName(String className, JavaProjectBuilder javaProjectBuilder) {
        Collection sources = javaProjectBuilder.getSources();
        Iterator iterator = sources.iterator();
        String packageName = null;
        while (iterator.hasNext()) {
            JavaSource javaSource = (JavaSource)iterator.next();
            List imports = javaSource.getImports();
            for (String importString : imports) {
                if (!importString.endsWith("." + className)) continue;
                return importString;
            }
            if (packageName != null) continue;
            packageName = javaSource.getPackageName();
        }
        return packageName + "." + className;
    }

    private List<String> _getImportNames(DetailAST detailAST) {
        ArrayList<String> importASTList = new ArrayList<String>();
        DetailAST sibling = detailAST.getPreviousSibling();
        while (sibling.getType() == 30) {
            FullIdent importIdent = FullIdent.createFullIdentBelow((DetailAST)sibling);
            importASTList.add(importIdent.getText());
            sibling = sibling.getPreviousSibling();
        }
        return importASTList;
    }

    private JavaClass _getJavaClass(JavaProjectBuilder javaProjectBuilder, String fileName) {
        int pos = fileName.lastIndexOf("/");
        String className = fileName.substring(pos + 1, fileName.length() - 5);
        for (JavaClass javaClass : javaProjectBuilder.getClasses()) {
            if (!className.equals(javaClass.getName())) continue;
            return javaClass;
        }
        return null;
    }

    private Map<String, String> _getVariablesMap(JavaProjectBuilder javaProjectBuilder) {
        HashMap<String, String> variablesMap = new HashMap<String, String>();
        for (JavaClass javaClass : javaProjectBuilder.getClasses()) {
            for (JavaField javaField : javaClass.getFields()) {
                String fieldTypeClassName;
                String fieldName;
                block5: {
                    fieldName = javaField.getName();
                    JavaClass fieldTypeClass = javaField.getType();
                    fieldTypeClassName = null;
                    try {
                        fieldTypeClassName = fieldTypeClass.getName();
                    }
                    catch (Throwable t) {
                        Pattern pattern = Pattern.compile("\\s(\\S+)\\s+(\\S+\\.)?" + fieldName);
                        Matcher matcher = pattern.matcher(javaField.toString());
                        if (!matcher.find()) break block5;
                        fieldTypeClassName = matcher.group(1);
                    }
                }
                if (fieldTypeClassName == null) continue;
                if (!fieldTypeClassName.contains(".")) {
                    fieldTypeClassName = this._getFullyQualifiedName(fieldTypeClassName, javaProjectBuilder);
                }
                variablesMap.put(fieldName, fieldTypeClassName);
            }
        }
        return variablesMap;
    }
}

