/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.util;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.ProgressStatus;
import com.liferay.source.formatter.ProgressStatusUpdate;
import com.liferay.source.formatter.SourceFormatterMessage;
import com.liferay.source.formatter.checkstyle.Checker;
import com.puppycrawl.tools.checkstyle.ConfigurationLoader;
import com.puppycrawl.tools.checkstyle.DefaultLogger;
import com.puppycrawl.tools.checkstyle.PropertiesExpander;
import com.puppycrawl.tools.checkstyle.PropertyResolver;
import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.api.Filter;
import com.puppycrawl.tools.checkstyle.filters.SuppressionsLoader;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import org.xml.sax.InputSource;

public class CheckStyleUtil {
    private static BlockingQueue<ProgressStatusUpdate> _progressStatusQueue;
    private static final Set<SourceFormatterMessage> _sourceFormatterMessages;

    public static Set<SourceFormatterMessage> process(Set<File> files, List<File> suppressionsFiles, String baseDirName, BlockingQueue<ProgressStatusUpdate> progressStatusQueue) throws Exception {
        _progressStatusQueue = progressStatusQueue;
        _sourceFormatterMessages.clear();
        Checker checker = CheckStyleUtil._getChecker(suppressionsFiles, baseDirName);
        checker.process(ListUtil.fromCollection(files));
        return _sourceFormatterMessages;
    }

    private static Checker _getChecker(List<File> suppressionsFiles, String baseDirName) throws Exception {
        Checker checker = new Checker();
        ClassLoader classLoader = CheckStyleUtil.class.getClassLoader();
        checker.setModuleClassLoader(classLoader);
        for (File suppressionsFile : suppressionsFiles) {
            checker.addFilter((Filter)SuppressionsLoader.loadSuppressions((String)suppressionsFile.getAbsolutePath()));
        }
        Configuration configuration = ConfigurationLoader.loadConfiguration((InputSource)new InputSource(classLoader.getResourceAsStream("checkstyle.xml")), (PropertyResolver)new PropertiesExpander(System.getProperties()), (boolean)false);
        checker.configure(configuration);
        SourceFormatterLogger listener = new SourceFormatterLogger(new UnsyncByteArrayOutputStream(), true, baseDirName);
        checker.addListener((AuditListener)listener);
        return checker;
    }

    static {
        _sourceFormatterMessages = new TreeSet<SourceFormatterMessage>();
    }

    private static class SourceFormatterLogger
    extends DefaultLogger {
        private final String _baseDirName;

        public SourceFormatterLogger(OutputStream outputStream, boolean closeStreamsAfterUse, String baseDirName) {
            super(outputStream, closeStreamsAfterUse);
            this._baseDirName = baseDirName;
        }

        public void addError(AuditEvent auditEvent) {
            _sourceFormatterMessages.add(new SourceFormatterMessage(this._getRelativizedFileName(auditEvent), auditEvent.getMessage(), auditEvent.getLine()));
            super.addError(auditEvent);
        }

        public void fileFinished(AuditEvent auditEvent) {
            try {
                _progressStatusQueue.put(new ProgressStatusUpdate(ProgressStatus.CHECK_STYLE_FILE_COMPLETED));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            super.fileFinished(auditEvent);
        }

        private Path _getAbsoluteNormalizedPath(String pathName) {
            Path path = Paths.get(pathName, new String[0]);
            path = path.toAbsolutePath();
            return path.normalize();
        }

        private String _getRelativizedFileName(AuditEvent auditEvent) {
            if (Validator.isNull(this._baseDirName)) {
                return auditEvent.getFileName();
            }
            Path baseDirPath = this._getAbsoluteNormalizedPath(this._baseDirName);
            Path relativizedPath = baseDirPath.relativize(this._getAbsoluteNormalizedPath(auditEvent.getFileName()));
            return this._baseDirName + StringUtil.replace(relativizedPath.toString(), '\\', '/');
        }
    }
}

