/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.TagAttributesCheck;
import com.liferay.source.formatter.checks.util.SourceUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaClassParser;
import com.liferay.source.formatter.parser.JavaMethod;
import com.liferay.source.formatter.parser.JavaParameter;
import com.liferay.source.formatter.parser.JavaSignature;
import com.liferay.source.formatter.parser.JavaTerm;
import com.liferay.source.formatter.util.FileUtil;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.Element;

public class JSPTagAttributesCheck
extends TagAttributesCheck {
    private List<String> _allFileNames;
    private final Map<String, Map<String, String>> _classSetMethodsMap = new HashMap<String, Map<String, String>>();
    private final Pattern _extendedClassPattern = Pattern.compile("\\sextends\\s+(\\w+)\\W");
    private final Pattern _jspTaglibPattern = Pattern.compile("<[-\\w]+:[-\\w]+ .");
    private Set<String> _primitiveTagAttributeDataTypes;
    private Map<String, Map<String, String>> _tagSetMethodsMap;

    @Override
    public void init() throws Exception {
        this._primitiveTagAttributeDataTypes = this._getPrimitiveTagAttributeDataTypes();
        this._tagSetMethodsMap = this._getTagSetMethodsMap();
    }

    @Override
    public void setAllFileNames(List<String> allFileNames) {
        this._allFileNames = allFileNames;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        content = this._formatSingleLineTagAttributes(fileName, content);
        content = this.formatMultiLinesTagAttributes(fileName, content);
        return content;
    }

    @Override
    protected String formatTagAttributeType(String line, String tagName, String attributeAndValue) throws Exception {
        if (attributeAndValue.matches(".*=\"<%= Boolean\\.(FALSE|TRUE) %>\".*")) {
            String newAttributeAndValue = StringUtil.replace(attributeAndValue, new String[]{"=\"<%= Boolean.FALSE %>\"", "=\"<%= Boolean.TRUE %>\""}, new String[]{"=\"<%= false %>\"", "=\"<%= true %>\""});
            return StringUtil.replace(line, attributeAndValue, newAttributeAndValue);
        }
        if (!this.isPortalSource() && !this.isSubrepository()) {
            return line;
        }
        if (!attributeAndValue.endsWith("\"") || attributeAndValue.contains("\"<%=")) {
            return line;
        }
        Map<String, String> setMethodsMap = this._tagSetMethodsMap.get(tagName);
        if (setMethodsMap == null) {
            return line;
        }
        int pos = attributeAndValue.indexOf("=\"");
        String attribute = attributeAndValue.substring(0, pos);
        String setAttributeMethodName = "set" + TextFormatter.format(attribute, 6);
        String dataType = setMethodsMap.get(setAttributeMethodName);
        if (dataType == null) {
            return line;
        }
        if (this._primitiveTagAttributeDataTypes.contains(dataType)) {
            String value = attributeAndValue.substring(pos + 2, attributeAndValue.length() - 1);
            if (!this._isValidTagAttributeValue(value, dataType)) {
                return line;
            }
            String newAttributeAndValue = StringUtil.replace(attributeAndValue, "\"" + value + "\"", "\"<%= " + value + " %>\"");
            return StringUtil.replace(line, attributeAndValue, newAttributeAndValue);
        }
        if (!dataType.equals("java.lang.String") && !dataType.equals("String")) {
            return line;
        }
        String newAttributeAndValue = StringUtil.replace(attributeAndValue, new String[]{"=\"false\"", "=\"true\""}, new String[]{"=\"<%= Boolean.FALSE.toString() %>\"", "=\"<%= Boolean.TRUE.toString() %>\""});
        return StringUtil.replace(line, attributeAndValue, newAttributeAndValue);
    }

    @Override
    protected String sortHTMLTagAttributes(String line, String value, String attributeAndValue) {
        if (!value.matches("([-a-z0-9]+ )+[-a-z0-9]+")) {
            return line;
        }
        List<String> htmlAttributes = ListUtil.fromArray(StringUtil.split(value, " "));
        Collections.sort(htmlAttributes);
        String newValue = StringUtil.merge(htmlAttributes, " ");
        if (value.equals(newValue)) {
            return line;
        }
        String newAttributeAndValue = StringUtil.replace(attributeAndValue, value, newValue);
        return StringUtil.replace(line, attributeAndValue, newAttributeAndValue);
    }

    private String _formatSingleLineTagAttributes(String fileName, String content) throws Exception {
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            int lineCount = 0;
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                ++lineCount;
                String trimmedLine = StringUtil.trimLeading(line);
                if (trimmedLine.matches("<\\w+ .*>.*")) {
                    line = this.formatTagAttributes(fileName, line, trimmedLine, lineCount, false);
                }
                Matcher matcher = this._jspTaglibPattern.matcher(line);
                while (matcher.find()) {
                    line = this.formatTagAttributes(fileName, line, line.substring(matcher.start()), lineCount, false);
                }
                sb.append(line);
                sb.append("\n");
            }
        }
        content = sb.toString();
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        return content;
    }

    private String _getExtendedFileName(String content, String fileName, List<String> imports, String utilTaglibSrcDirName) {
        Matcher matcher = this._extendedClassPattern.matcher(content);
        if (!matcher.find()) {
            return null;
        }
        String extendedClassName = matcher.group(1);
        if (!extendedClassName.contains(".")) {
            for (String importName : imports) {
                if (!importName.endsWith("." + extendedClassName)) continue;
                extendedClassName = importName;
                break;
            }
        }
        StringBundler sb = new StringBundler(3);
        if (extendedClassName.startsWith("com.liferay.taglib")) {
            sb.append(utilTaglibSrcDirName);
            sb.append(StringUtil.replace(extendedClassName, '.', '/'));
        } else if (!extendedClassName.contains(".")) {
            int pos = fileName.lastIndexOf(47);
            sb.append(fileName.substring(0, pos + 1));
            sb.append(extendedClassName);
        } else {
            return null;
        }
        sb.append(".java");
        return sb.toString();
    }

    private Set<String> _getPrimitiveTagAttributeDataTypes() {
        return SetUtil.fromArray(new String[]{"java.lang.Boolean", "Boolean", "boolean", "java.lang.Double", "Double", "double", "java.lang.Integer", "Integer", "int", "java.lang.Long", "Long", "long"});
    }

    private Map<String, String> _getSetMethodsMap(String tagFileName, String utilTaglibSrcDirName) throws Exception {
        if (this._classSetMethodsMap.containsKey(tagFileName)) {
            return this._classSetMethodsMap.get(tagFileName);
        }
        HashMap<String, String> setMethodsMap = new HashMap<String, String>();
        File tagFile = new File(tagFileName);
        if (!tagFile.exists()) {
            return setMethodsMap;
        }
        String tagFileContent = FileUtil.read(tagFile);
        JavaClass javaClass = JavaClassParser.parseJavaClass(tagFileName, tagFileContent);
        for (JavaTerm javaTerm : javaClass.getChildJavaTerms()) {
            JavaSignature javaSignature;
            List<JavaParameter> javaParameters;
            JavaMethod javaMethod;
            String methodName;
            if (!(javaTerm instanceof JavaMethod) || !(methodName = (javaMethod = (JavaMethod)javaTerm).getName()).startsWith("set") || (javaParameters = (javaSignature = javaMethod.getSignature()).getParameters()).size() != 1) continue;
            JavaParameter javaParameter = javaParameters.get(0);
            setMethodsMap.put(methodName, javaParameter.getParameterType());
        }
        String extendedFileName = this._getExtendedFileName(tagFileContent, tagFileName, javaClass.getImports(), utilTaglibSrcDirName);
        if (extendedFileName != null) {
            setMethodsMap.putAll(this._getSetMethodsMap(extendedFileName, utilTaglibSrcDirName));
        }
        this._classSetMethodsMap.put(tagFileName, setMethodsMap);
        return setMethodsMap;
    }

    private Map<String, Map<String, String>> _getTagSetMethodsMap() throws Exception {
        HashMap<String, Map<String, String>> tagSetMethodsMap = new HashMap<String, Map<String, String>>();
        List<String> tldFileNames = this._getTLDFileNames();
        if (tldFileNames.isEmpty()) {
            return tagSetMethodsMap;
        }
        String utilTaglibSrcDirName = this._getUtilTaglibSrcDirName();
        block0: for (String tldFileName : this._getTLDFileNames()) {
            tldFileName = StringUtil.replace(tldFileName, '\\', '/');
            File tldFile = new File(tldFileName);
            String content = FileUtil.read(tldFile);
            Document document = SourceUtil.readXML(content);
            Element rootElement = document.getRootElement();
            Element shortNameElement = rootElement.element("short-name");
            String shortName = shortNameElement.getStringValue();
            List tagElements = rootElement.elements("tag");
            String srcDir = null;
            for (Element tagElement : tagElements) {
                Element tagClassElement = tagElement.element("tag-class");
                String tagClassName = tagClassElement.getStringValue();
                if (!tagClassName.startsWith("com.liferay")) continue;
                Element tagNameElement = tagElement.element("name");
                String tagName = tagNameElement.getStringValue();
                if (tagSetMethodsMap.containsKey(shortName + ":" + tagName)) continue;
                if (srcDir == null) {
                    if (tldFileName.contains("/src/")) {
                        srcDir = SourceUtil.getAbsolutePath(tldFile);
                        srcDir = srcDir.substring(0, srcDir.lastIndexOf("/src/")) + "/src/main/java/";
                    } else {
                        srcDir = utilTaglibSrcDirName;
                        if (Validator.isNull(srcDir)) continue block0;
                    }
                }
                StringBundler sb = new StringBundler(3);
                sb.append(srcDir);
                sb.append(StringUtil.replace(tagClassName, '.', '/'));
                sb.append(".java");
                Map<String, String> setMethodsMap = this._getSetMethodsMap(sb.toString(), utilTaglibSrcDirName);
                if (setMethodsMap.isEmpty()) continue;
                tagSetMethodsMap.put(shortName + ":" + tagName, setMethodsMap);
            }
        }
        return tagSetMethodsMap;
    }

    private List<String> _getTLDFileNames() throws Exception {
        String[] excludes = new String[]{"**/dependencies/**", "**/util-taglib/**", "**/portal-web/**"};
        List<String> tldFileNames = SourceFormatterUtil.filterFileNames(this._allFileNames, excludes, new String[]{"**/*.tld"}, this.getSourceFormatterExcludes(), true);
        if (!this.isPortalSource()) {
            return tldFileNames;
        }
        String tldDirLocation = "portal-web/docroot/WEB-INF/tld/";
        for (int i = 0; i < 6; ++i) {
            File file = new File(this.getBaseDirName() + tldDirLocation);
            if (file.exists()) {
                tldFileNames.addAll(this.getFileNames(this.getBaseDirName() + tldDirLocation, new String[0], new String[]{"**/*.tld"}));
                break;
            }
            tldDirLocation = "../" + tldDirLocation;
        }
        return tldFileNames;
    }

    private String _getUtilTaglibSrcDirName() {
        File utilTaglibDir = this.getFile("util-taglib/src", 7);
        if (utilTaglibDir == null) {
            return "";
        }
        return SourceUtil.getAbsolutePath(utilTaglibDir) + "/";
    }

    private boolean _isValidTagAttributeValue(String value, String dataType) {
        if (dataType.endsWith("Boolean") || dataType.equals("boolean")) {
            return Validator.isBoolean(value);
        }
        if (dataType.endsWith("Double") || dataType.equals("double")) {
            try {
                Double.parseDouble(value);
            }
            catch (NumberFormatException nfe) {
                return false;
            }
            return true;
        }
        if (dataType.endsWith("Integer") || dataType.equals("int") || dataType.endsWith("Long") || dataType.equals("long")) {
            return Validator.isNumber(value);
        }
        return false;
    }
}

