/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.util;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.ProgressStatus;
import com.liferay.source.formatter.ProgressStatusUpdate;
import com.liferay.source.formatter.SourceFormatterArgs;
import com.liferay.source.formatter.SourceFormatterMessage;
import com.liferay.source.formatter.checkstyle.Checker;
import com.liferay.source.formatter.util.CheckType;
import com.liferay.source.formatter.util.DebugUtil;
import com.puppycrawl.tools.checkstyle.ConfigurationLoader;
import com.puppycrawl.tools.checkstyle.DefaultConfiguration;
import com.puppycrawl.tools.checkstyle.DefaultLogger;
import com.puppycrawl.tools.checkstyle.PropertiesExpander;
import com.puppycrawl.tools.checkstyle.PropertyResolver;
import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.api.Filter;
import com.puppycrawl.tools.checkstyle.filters.SuppressionsLoader;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import org.xml.sax.InputSource;

public class CheckStyleUtil {
    private static BlockingQueue<ProgressStatusUpdate> _progressStatusQueue;
    private static final Set<SourceFormatterMessage> _sourceFormatterMessages;

    public static Set<SourceFormatterMessage> process(Set<File> files, List<File> suppressionsFiles, SourceFormatterArgs sourceFormatterArgs, BlockingQueue<ProgressStatusUpdate> progressStatusQueue) throws Exception {
        _progressStatusQueue = progressStatusQueue;
        _sourceFormatterMessages.clear();
        Configuration configuration = CheckStyleUtil._getConfiguration(sourceFormatterArgs);
        if (sourceFormatterArgs.isShowDebugInformation()) {
            DebugUtil.addCheckNames(CheckType.CHECKSTYLE, CheckStyleUtil._getCheckNames(configuration));
        }
        Checker checker = CheckStyleUtil._getChecker(configuration, suppressionsFiles, sourceFormatterArgs);
        checker.process(ListUtil.fromCollection(files));
        return _sourceFormatterMessages;
    }

    private static Configuration _addAttribute(Configuration configuration, String key, String value, String ... regexChecks) {
        String name;
        if (!(configuration instanceof DefaultConfiguration)) {
            return configuration;
        }
        DefaultConfiguration defaultConfiguration = (DefaultConfiguration)configuration;
        DefaultConfiguration treeWalkerModule = null;
        for (Configuration childConfiguration : defaultConfiguration.getChildren()) {
            name = childConfiguration.getName();
            if (!name.equals("TreeWalker") || !(childConfiguration instanceof DefaultConfiguration)) continue;
            treeWalkerModule = (DefaultConfiguration)childConfiguration;
            break;
        }
        if (treeWalkerModule == null) {
            return configuration;
        }
        for (Configuration childConfiguration : treeWalkerModule.getChildren()) {
            if (!(childConfiguration instanceof DefaultConfiguration)) continue;
            name = childConfiguration.getName();
            for (String regexCheck : regexChecks) {
                if (!name.matches(regexCheck)) continue;
                DefaultConfiguration defaultChildConfiguration = (DefaultConfiguration)childConfiguration;
                defaultChildConfiguration.addAttribute(key, value);
            }
        }
        return defaultConfiguration;
    }

    private static Checker _getChecker(Configuration configuration, List<File> suppressionsFiles, SourceFormatterArgs sourceFormatterArgs) throws Exception {
        Checker checker = new Checker();
        ClassLoader classLoader = CheckStyleUtil.class.getClassLoader();
        checker.setModuleClassLoader(classLoader);
        for (File suppressionsFile : suppressionsFiles) {
            checker.addFilter((Filter)SuppressionsLoader.loadSuppressions((String)suppressionsFile.getAbsolutePath()));
        }
        checker.configure(configuration);
        SourceFormatterLogger listener = new SourceFormatterLogger(new UnsyncByteArrayOutputStream(), true, sourceFormatterArgs.getBaseDirName());
        checker.addListener((AuditListener)listener);
        return checker;
    }

    private static List<String> _getCheckNames(Configuration configuration) {
        ArrayList<String> checkNames = new ArrayList<String>();
        String name = configuration.getName();
        if (name.startsWith("com.liferay.")) {
            int pos = name.lastIndexOf(46);
            if (!name.endsWith("Check")) {
                name = name.concat("Check");
            }
            checkNames.add(name.substring(pos + 1));
        }
        for (Configuration childConfiguration : configuration.getChildren()) {
            checkNames.addAll(CheckStyleUtil._getCheckNames(childConfiguration));
        }
        return checkNames;
    }

    private static Configuration _getConfiguration(SourceFormatterArgs sourceFormatterArgs) throws Exception {
        ClassLoader classLoader = CheckStyleUtil.class.getClassLoader();
        Configuration configuration = ConfigurationLoader.loadConfiguration((InputSource)new InputSource(classLoader.getResourceAsStream("checkstyle.xml")), (PropertyResolver)new PropertiesExpander(System.getProperties()), (boolean)false);
        configuration = CheckStyleUtil._addAttribute(configuration, "maxLineLength", String.valueOf(sourceFormatterArgs.getMaxLineLength()), "com.liferay.source.formatter.checkstyle.checks.PlusStatement");
        configuration = CheckStyleUtil._addAttribute(configuration, "showDebugInformation", String.valueOf(sourceFormatterArgs.isShowDebugInformation()), "com.liferay.*");
        return configuration;
    }

    static {
        _sourceFormatterMessages = new TreeSet<SourceFormatterMessage>();
    }

    private static class SourceFormatterLogger
    extends DefaultLogger {
        private final String _baseDirName;

        public SourceFormatterLogger(OutputStream outputStream, boolean closeStreamsAfterUse, String baseDirName) {
            super(outputStream, closeStreamsAfterUse);
            this._baseDirName = baseDirName;
        }

        public void addError(AuditEvent auditEvent) {
            _sourceFormatterMessages.add(new SourceFormatterMessage(this._getRelativizedFileName(auditEvent), auditEvent.getMessage(), auditEvent.getLine()));
            super.addError(auditEvent);
        }

        public void fileFinished(AuditEvent auditEvent) {
            try {
                _progressStatusQueue.put(new ProgressStatusUpdate(ProgressStatus.CHECK_STYLE_FILE_COMPLETED));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            super.fileFinished(auditEvent);
        }

        private Path _getAbsoluteNormalizedPath(String pathName) {
            Path path = Paths.get(pathName, new String[0]);
            path = path.toAbsolutePath();
            return path.normalize();
        }

        private String _getRelativizedFileName(AuditEvent auditEvent) {
            if (Validator.isNull(this._baseDirName)) {
                return auditEvent.getFileName();
            }
            Path baseDirPath = this._getAbsoluteNormalizedPath(this._baseDirName);
            Path relativizedPath = baseDirPath.relativize(this._getAbsoluteNormalizedPath(auditEvent.getFileName()));
            return this._baseDirName + StringUtil.replace(relativizedPath.toString(), '\\', '/');
        }
    }
}

