/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.util.FileImpl;
import com.liferay.portal.xml.DocumentImpl;
import com.liferay.portal.xml.ElementImpl;
import com.liferay.util.xml.DocUtil;
import java.util.Arrays;
import org.apache.tools.ant.DirectoryScanner;
import org.dom4j.DocumentHelper;

public class ExtInfoBuilder {
    private static final FileImpl _fileUtil = FileImpl.getInstance();

    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            throw new IllegalArgumentException();
        }
        new ExtInfoBuilder(args[0], args[1], args[2]);
    }

    public ExtInfoBuilder(String basedir, String outputDir, String servletContextName) throws Exception {
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(basedir);
        ds.setExcludes(new String[]{".svn/**", "**/.svn/**", "ext-impl/ext-impl.jar", "ext-impl/src/**", "ext-kernel/ext-kernel.jar", "ext-kernel/src/**", "ext-util-bridges/ext-util-bridges.jar", "ext-util-bridges/src/**", "ext-util-java/ext-util-java.jar", "ext-util-java/src/**", "ext-util-taglib/ext-util-taglib.jar", "ext-util-taglib/src/**", "liferay-plugin-package.properties"});
        ds.scan();
        Object[] files = ds.getIncludedFiles();
        Arrays.sort(files);
        ElementImpl rootElement = new ElementImpl(DocumentHelper.createElement((String)"ext-info"));
        DocumentImpl document = new DocumentImpl(DocumentHelper.createDocument());
        document.setRootElement(rootElement);
        DocUtil.add((Element)rootElement, (String)"servlet-context-name", (String)servletContextName);
        Element filesElement = rootElement.addElement("files");
        for (Object file : files) {
            DocUtil.add((Element)filesElement, (String)"file", (String)StringUtil.replace((String)file, (char)'\\', (char)'/'));
        }
        _fileUtil.write(outputDir + "/ext-" + servletContextName + ".xml", document.formattedString());
    }
}

