/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.util;

import com.liferay.layouts.admin.kernel.model.LayoutTypePortletConstants;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

@Deprecated
public class UpgradePortletId
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(UpgradePortletId.class);

    protected void doUpgrade() throws Exception {
        this.upgradeInstanceablePortletIds();
        this.upgradeUninstanceablePortletIds();
    }

    protected String getNewTypeSettings(String typeSettings, String oldRootPortletId, String newRootPortletId, boolean exactMatch) {
        throw new UnsupportedOperationException("This class is deprecated and replaced by com.liferay.portal.kernel.upgrade.BaseUpgradePortletId");
    }

    protected String getNewTypeSettings(String typeSettings, String oldRootPortletId, String newRootPortletId, List<String> nestedPortletColumnIds, boolean exactMatch) {
        UnicodeProperties typeSettingsProperties = new UnicodeProperties(true);
        typeSettingsProperties.fastLoad(typeSettings);
        for (Map.Entry entry : typeSettingsProperties.entrySet()) {
            String typeSettingId = (String)entry.getKey();
            if (!LayoutTypePortletConstants.isLayoutTemplateColumnName((String)typeSettingId)) continue;
            Object[] portletIds = StringUtil.split((String)((String)entry.getValue()));
            for (int j = 0; j < portletIds.length; ++j) {
                Object portletId = portletIds[j];
                if (exactMatch) {
                    if (!((String)portletId).equals(oldRootPortletId)) continue;
                    portletIds[j] = newRootPortletId;
                    continue;
                }
                String rootPortletId = PortletIdCodec.decodePortletName((String)portletId);
                if (!rootPortletId.equals(oldRootPortletId)) continue;
                long userId = PortletIdCodec.decodeUserId((String)portletId);
                String instanceId = PortletIdCodec.decodeInstanceId((String)portletId);
                portletIds[j] = PortletIdCodec.encode((String)newRootPortletId, (long)userId, (String)instanceId);
            }
            String portletIdsString = StringUtil.merge((Object[])portletIds);
            typeSettingsProperties.setProperty(typeSettingId, portletIdsString.concat(","));
        }
        return typeSettingsProperties.toString();
    }

    protected String[][] getRenamePortletIdsArray() {
        return new String[][]{{"109", "1_WAR_webformportlet"}, {"google_adsense_portlet_WAR_googleadsenseportlet", "1_WAR_googleadsenseportlet"}, {"google_gadget_portlet_WAR_googlegadgetportlet", "1_WAR_googlegadgetportlet"}, {"google_maps_portlet_WAR_googlemapsportlet", "1_WAR_googlemapsportlet"}};
    }

    protected String getTypeSettingsCriteria(String portletId) {
        StringBundler sb = new StringBundler(21);
        sb.append("typeSettings like '%=");
        sb.append(portletId);
        sb.append(",%' OR typeSettings like '%=");
        sb.append(portletId);
        sb.append("\n%' OR typeSettings like '%=");
        sb.append(portletId);
        sb.append("%' OR typeSettings like '%,");
        sb.append(portletId);
        sb.append(",%' OR typeSettings like '%,");
        sb.append(portletId);
        sb.append("\n%' OR typeSettings like '%,");
        sb.append(portletId);
        sb.append("%' OR typeSettings like '%=");
        sb.append(portletId);
        sb.append("_INSTANCE_%' OR typeSettings like '%,");
        sb.append(portletId);
        sb.append("_INSTANCE_%' OR typeSettings like '%=");
        sb.append(portletId);
        sb.append("_USER_%' OR typeSettings like '%,");
        sb.append(portletId);
        sb.append("_USER_%'");
        return sb.toString();
    }

    protected String[] getUninstanceablePortletIds() {
        return new String[0];
    }

    protected void updateInstanceablePortletPreferences(String oldRootPortletId, String newRootPortletId) throws Exception {
        StringBundler sb = new StringBundler(8);
        sb.append("select portletPreferencesId, portletId from ");
        sb.append("PortletPreferences where portletId = '");
        sb.append(oldRootPortletId);
        sb.append("' OR portletId like '");
        sb.append(oldRootPortletId);
        sb.append("_INSTANCE_%' OR portletId like '");
        sb.append(oldRootPortletId);
        sb.append("_USER_%_INSTANCE_%'");
        try (PreparedStatement ps1 = this.connection.prepareStatement(sb.toString());
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update PortletPreferences set portletId = ? where portletPreferencesId = ?");
             ResultSet rs = ps1.executeQuery();){
            while (rs.next()) {
                long portletPreferencesId = rs.getLong("portletPreferencesId");
                String portletId = rs.getString("portletId");
                String newPortletId = StringUtil.replace((String)portletId, (String)oldRootPortletId, (String)newRootPortletId);
                ps2.setString(1, newPortletId);
                ps2.setLong(2, portletPreferencesId);
                ps2.addBatch();
            }
            ps2.executeBatch();
        }
    }

    protected void updateLayout(long plid, String typeSettings) throws Exception {
        block14: {
            try (PreparedStatement ps = this.connection.prepareStatement("update Layout set typeSettings = ? where plid = " + plid);){
                ps.setString(1, typeSettings);
                ps.executeUpdate();
            }
            catch (SQLException sqle) {
                if (!_log.isWarnEnabled()) break block14;
                _log.warn((Object)sqle, (Throwable)sqle);
            }
        }
    }

    protected void updateLayout(long plid, String oldPortletId, String newPortletId) throws Exception {
        block27: {
            try (PreparedStatement ps = this.connection.prepareStatement("select typeSettings from Layout where plid = " + plid);
                 ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    String typeSettings = rs.getString("typeSettings");
                    String newTypeSettings = StringUtil.replace((String)typeSettings, (String)oldPortletId, (String)newPortletId);
                    this.updateLayout(plid, newTypeSettings);
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block27;
                _log.warn((Object)e, (Throwable)e);
            }
        }
    }

    protected void updateLayoutRevision(long layoutRevisionId, String typeSettings) throws Exception {
        block14: {
            String sql = "update LayoutRevision set typeSettings = ? where layoutRevisionId = " + layoutRevisionId;
            try (PreparedStatement ps = this.connection.prepareStatement(sql);){
                ps.setString(1, typeSettings);
                ps.executeUpdate();
            }
            catch (SQLException sqle) {
                if (!_log.isWarnEnabled()) break block14;
                _log.warn((Object)sqle, (Throwable)sqle);
            }
        }
    }

    protected void updateLayoutRevisions(String oldRootPortletId, String newRootPortletId, boolean exactMatch) throws Exception {
        String sql = "select layoutRevisionId, typeSettings from LayoutRevision where " + this.getTypeSettingsCriteria(oldRootPortletId);
        try (PreparedStatement ps = this.connection.prepareStatement(sql);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                long layoutRevisionId = rs.getLong("layoutRevisionId");
                String typeSettings = rs.getString("typeSettings");
                String newTypeSettings = this.getNewTypeSettings(typeSettings, oldRootPortletId, newRootPortletId, null, exactMatch);
                this.updateLayoutRevision(layoutRevisionId, newTypeSettings);
            }
        }
    }

    protected void updateLayouts(String oldRootPortletId, String newRootPortletId, boolean exactMatch) throws Exception {
        String sql = "select plid, typeSettings from Layout where " + this.getTypeSettingsCriteria(oldRootPortletId);
        try (PreparedStatement ps = this.connection.prepareStatement(sql);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                long plid = rs.getLong("plid");
                String typeSettings = rs.getString("typeSettings");
                String newTypeSettings = this.getNewTypeSettings(typeSettings, oldRootPortletId, newRootPortletId, null, exactMatch);
                this.updateLayout(plid, newTypeSettings);
            }
        }
    }

    protected void updatePortlet(String oldRootPortletId, String newRootPortletId) throws Exception {
        block2: {
            try {
                this.updatePortletId(oldRootPortletId, newRootPortletId);
                this.updateResourceAction(oldRootPortletId, newRootPortletId);
                this.updateResourcePermission(oldRootPortletId, newRootPortletId, true);
                this.updateUserNotificationDelivery(oldRootPortletId, newRootPortletId);
                this.updateUserNotificationEvent(oldRootPortletId, newRootPortletId);
                this.updateInstanceablePortletPreferences(oldRootPortletId, newRootPortletId);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)e, (Throwable)e);
            }
        }
    }

    protected void updatePortletId(String oldRootPortletId, String newRootPortletId) throws Exception {
        this.runSQL("update Portlet set portletId = '" + newRootPortletId + "' where portletId = '" + oldRootPortletId + "'");
    }

    protected void updateResourceAction(String oldName, String newName) throws Exception {
        this.runSQL("update ResourceAction set name = '" + newName + "' where name = '" + oldName + "'");
    }

    protected void updateResourcePermission(String oldRootPortletId, String newRootPortletId, boolean updateName) throws Exception {
        block43: {
            try (PreparedStatement ps1 = this.connection.prepareStatement("select resourcePermissionId, name, scope, primKey from ResourcePermission where name = '" + oldRootPortletId + "'");
                 PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update ResourcePermission set name = ?, primKey = ? where resourcePermissionId = ?");
                 ResultSet rs = ps1.executeQuery();){
                while (rs.next()) {
                    long resourcePermissionId = rs.getLong("resourcePermissionId");
                    String name = rs.getString("name");
                    int scope = rs.getInt("scope");
                    String primKey = rs.getString("primKey");
                    String newName = name;
                    if (updateName) {
                        newName = newRootPortletId;
                    }
                    if (scope == 4) {
                        int pos = primKey.indexOf("_LAYOUT_");
                        if (pos != -1) {
                            long plid = GetterUtil.getLong((String)primKey.substring(0, pos));
                            String portletId = primKey.substring(pos + "_LAYOUT_".length());
                            String instanceId = PortletIdCodec.decodeInstanceId((String)portletId);
                            long userId = PortletIdCodec.decodeUserId((String)portletId);
                            String newPortletId = PortletIdCodec.encode((String)newRootPortletId, (long)userId, (String)instanceId);
                            primKey = PortletPermissionUtil.getPrimaryKey((long)plid, (String)newPortletId);
                        }
                        if (name.equals(primKey)) {
                            primKey = newName;
                        }
                    }
                    ps2.setString(1, newName);
                    ps2.setString(2, primKey);
                    ps2.setLong(3, resourcePermissionId);
                    ps2.addBatch();
                }
                ps2.executeBatch();
            }
            catch (SQLException sqle) {
                if (!_log.isWarnEnabled()) break block43;
                _log.warn((Object)sqle, (Throwable)sqle);
            }
        }
    }

    protected void updateUserNotificationDelivery(String oldPortletId, String newPortletId) throws Exception {
        this.runSQL("update UserNotificationDelivery set portletId = '" + newPortletId + "' where portletId = '" + oldPortletId + "'");
    }

    protected void updateUserNotificationEvent(String oldPortletId, String newPortletId) throws Exception {
        this.runSQL("update UserNotificationEvent set type_ = '" + newPortletId + "' where type_ = '" + oldPortletId + "'");
    }

    protected void upgradeInstanceablePortletIds() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            String[][] renamePortletIdsArray;
            for (String[] renamePortletIds : renamePortletIdsArray = this.getRenamePortletIdsArray()) {
                String oldRootPortletId = renamePortletIds[0];
                String newRootPortletId = renamePortletIds[1];
                this.updatePortlet(oldRootPortletId, newRootPortletId);
                this.updateLayoutRevisions(oldRootPortletId, newRootPortletId, false);
                this.updateLayouts(oldRootPortletId, newRootPortletId, false);
            }
        }
    }

    protected void upgradeUninstanceablePortletIds() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            String[] uninstanceablePortletIds;
            for (String portletId : uninstanceablePortletIds = this.getUninstanceablePortletIds()) {
                if (PortletIdCodec.hasInstanceId((String)portletId)) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)("Portlet " + portletId + " is already instanceable"));
                    continue;
                }
                PortletIdCodec.validatePortletName((String)portletId);
                String newPortletInstanceKey = PortletIdCodec.encode((String)portletId);
                this.updateInstanceablePortletPreferences(portletId, newPortletInstanceKey);
                this.updateResourcePermission(portletId, newPortletInstanceKey, false);
                this.updateLayoutRevisions(portletId, newPortletInstanceKey, true);
                this.updateLayouts(portletId, newPortletInstanceKey, true);
            }
        }
    }
}

