/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_0;

import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.dao.orm.WildcardMode;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class UpgradeKernelPackage
extends UpgradeProcess {
    private static final String[][] _CLASS_NAMES = new String[][]{{"com.liferay.counter.model.Counter", "com.liferay.counter.kernel.model.Counter"}, {"com.liferay.portal.kernel.mail.Account", "com.liferay.mail.kernel.model.Account"}, {"com.liferay.portal.model.BackgroundTask", "com.liferay.portal.background.task.model.BackgroundTask"}, {"com.liferay.portal.model.Lock", "com.liferay.portal.lock.model.Lock"}, {"com.liferay.portal.model.", "com.liferay.portal.kernel.model."}, {"com.liferay.portlet.announcements.model.", "com.liferay.announcements.kernel.model."}, {"com.liferay.portlet.asset.model.", "com.liferay.asset.kernel.model."}, {"com.liferay.portlet.blogs.model.", "com.liferay.blogs.kernel.model."}, {"com.liferay.portlet.documentlibrary.model.", "com.liferay.document.library.kernel.model."}, {"com.liferay.portlet.documentlibrary.util.", "com.liferay.document.library.kernel.util."}, {"com.liferay.portlet.expando.model.", "com.liferay.expando.kernel.model."}, {"com.liferay.portlet.messageboards.model.", "com.liferay.message.boards.kernel.model."}, {"com.liferay.portlet.mobiledevicerules.model.", "com.liferay.mobile.device.rules.model."}, {"com.liferay.portlet.ratings.model.", "com.liferay.ratings.kernel.model."}, {"com.liferay.portlet.social.model.", "com.liferay.social.kernel.model."}, {"com.liferay.portlet.trash.model.", "com.liferay.trash.kernel.model."}, {"com.liferay.socialnetworking.model.", "com.liferay.social.networking.model."}};
    private static final String[][] _RESOURCE_NAMES = new String[][]{{"com.liferay.portlet.asset", "com.liferay.asset"}, {"com.liferay.portlet.blogs", "com.liferay.blogs"}, {"com.liferay.portlet.documentlibrary", "com.liferay.document.library"}, {"com.liferay.portlet.messageboards", "com.liferay.message.boards"}};

    protected void doUpgrade() throws UpgradeException {
        try {
            this.upgradeTable("Counter", "name", this.getClassNames(), WildcardMode.SURROUND);
            this.upgradeTable("ClassName_", "value", this.getClassNames(), WildcardMode.SURROUND);
            this.upgradeTable("Lock_", "className", this.getClassNames(), WildcardMode.SURROUND);
            this.upgradeTable("ResourceAction", "name", this.getClassNames(), WildcardMode.SURROUND);
            this.upgradeTable("ResourceBlock", "name", this.getClassNames(), WildcardMode.SURROUND);
            this.upgradeTable("ResourcePermission", "name", this.getClassNames(), WildcardMode.SURROUND);
            this.upgradeLongTextTable("UserNotificationEvent", "payload", this.getClassNames(), WildcardMode.SURROUND);
            this.upgradeTable("ListType", "type_", this.getClassNames(), WildcardMode.TRAILING);
            this.upgradeTable("ResourceAction", "name", this.getResourceNames(), WildcardMode.LEADING);
            this.upgradeTable("ResourceBlock", "name", this.getResourceNames(), WildcardMode.LEADING);
            this.upgradeTable("ResourcePermission", "name", this.getResourceNames(), WildcardMode.LEADING);
            this.upgradeLongTextTable("UserNotificationEvent", "payload", this.getResourceNames(), WildcardMode.LEADING);
        }
        catch (Exception e) {
            throw new UpgradeException((Throwable)e);
        }
    }

    protected String[][] getClassNames() {
        return _CLASS_NAMES;
    }

    protected String[][] getResourceNames() {
        return _RESOURCE_NAMES;
    }

    protected void upgradeLongTextTable(String columnName, String selectSQL, String updateSQL, String[] name) throws SQLException {
        try (PreparedStatement ps1 = this.connection.prepareStatement(selectSQL);
             ResultSet rs = ps1.executeQuery();
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.autoBatch((PreparedStatement)this.connection.prepareStatement(updateSQL));){
            while (rs.next()) {
                String oldValue = rs.getString(columnName);
                String newValue = StringUtil.replace((String)oldValue, (String)name[0], (String)name[1]);
                ps2.setString(1, newValue);
                ps2.setString(2, oldValue);
                ps2.addBatch();
            }
            ps2.executeBatch();
        }
    }

    protected void upgradeLongTextTable(String tableName, String columnName, String[][] names, WildcardMode wildcardMode) throws Exception {
        DB db = DBManagerUtil.getDB();
        if (db.getDBType() != DBType.SYBASE) {
            this.upgradeTable(tableName, columnName, names, wildcardMode);
            return;
        }
        try (LoggingTimer loggingTimer = new LoggingTimer(tableName);){
            StringBundler updateSB = new StringBundler(7);
            updateSB.append("update ");
            updateSB.append(tableName);
            updateSB.append(" set ");
            updateSB.append(columnName);
            updateSB.append(" = ? where ");
            updateSB.append(columnName);
            updateSB.append(" = ?");
            String updateSQL = updateSB.toString();
            StringBundler selectPrefixSB = new StringBundler(7);
            selectPrefixSB.append("select ");
            selectPrefixSB.append(columnName);
            selectPrefixSB.append(" from ");
            selectPrefixSB.append(tableName);
            selectPrefixSB.append(" where ");
            selectPrefixSB.append(columnName);
            if (wildcardMode.equals((Object)WildcardMode.LEADING) || wildcardMode.equals((Object)WildcardMode.SURROUND)) {
                selectPrefixSB.append(" like '%");
            } else {
                selectPrefixSB.append(" like '");
            }
            String selectPrefix = selectPrefixSB.toString();
            String selectPostfix = "'";
            if (wildcardMode.equals((Object)WildcardMode.SURROUND) || wildcardMode.equals((Object)WildcardMode.TRAILING)) {
                selectPostfix = "%'";
            }
            for (String[] name : names) {
                String selectSQL = selectPrefix.concat(name[0]).concat(selectPostfix);
                this.upgradeLongTextTable(columnName, selectSQL, updateSQL, name);
            }
        }
    }

    protected void upgradeTable(String tableName, String columnName, String[][] names, WildcardMode wildcardMode) throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer(tableName);){
            StringBundler sb1 = new StringBundler(7);
            sb1.append("update ");
            sb1.append(tableName);
            sb1.append(" set ");
            sb1.append(columnName);
            sb1.append(" = replace(");
            sb1.append(this._transformColumnName(columnName));
            sb1.append(", '");
            String tableSQL = sb1.toString();
            StringBundler sb2 = new StringBundler(9);
            for (String[] name : names) {
                sb2.append(tableSQL);
                sb2.append(name[0]);
                sb2.append("', '");
                sb2.append(name[1]);
                sb2.append("') where ");
                sb2.append(columnName);
                if (wildcardMode.equals((Object)WildcardMode.LEADING) || wildcardMode.equals((Object)WildcardMode.SURROUND)) {
                    sb2.append(" like '%");
                } else {
                    sb2.append(" like '");
                }
                sb2.append(name[0]);
                if (wildcardMode.equals((Object)WildcardMode.SURROUND) || wildcardMode.equals((Object)WildcardMode.TRAILING)) {
                    sb2.append("%'");
                } else {
                    sb2.append("'");
                }
                this.runSQL(sb2.toString());
                sb2.setIndex(0);
            }
        }
    }

    private String _transformColumnName(String columnName) {
        DB db = DBManagerUtil.getDB();
        if (db.getDBType() == DBType.SQLSERVER) {
            return "CAST_TEXT(" + columnName + ")";
        }
        return columnName;
    }
}

