/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.counter.kernel.service.CounterLocalServiceUtil;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourceActionLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.verify.VerifyProcess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VerifyPermission
extends VerifyProcess {
    private static final Log _log = LogFactoryUtil.getLog(VerifyPermission.class);
    private static final long _deprecatedOrganizationBitwiseValues;
    private static final Map<Long, Long> _organizationToGroupBitwiseValues;

    protected void checkPermissions() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            List modelNames = ResourceActionsUtil.getModelNames();
            for (String modelName : modelNames) {
                List actionIds = ResourceActionsUtil.getModelResourceActions((String)modelName);
                ResourceActionLocalServiceUtil.checkResourceActions((String)modelName, (List)actionIds, (boolean)true);
            }
            List portletNames = ResourceActionsUtil.getPortletNames();
            for (String portletName : portletNames) {
                List actionIds = ResourceActionsUtil.getPortletResourceActions((String)portletName);
                ResourceActionLocalServiceUtil.checkResourceActions((String)portletName, (List)actionIds, (boolean)true);
            }
        }
    }

    protected void deleteConflictingUserDefaultRolePermissions(long companyId, long powerUserRoleId, long userRoleId, long userClassNameId, long userGroupClassNameId) throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            StringBundler sb = new StringBundler(14);
            sb.append("select resourcePermission1.resourcePermissionId from ");
            sb.append("ResourcePermission resourcePermission1 inner join ");
            sb.append("ResourcePermission resourcePermission2 on ");
            sb.append("resourcePermission1.companyId = ");
            sb.append("resourcePermission2.companyId and ");
            sb.append("resourcePermission1.name = resourcePermission2.name ");
            sb.append("and resourcePermission1.scope = ");
            sb.append("resourcePermission2.scope and ");
            sb.append("resourcePermission1.primKey = ");
            sb.append("resourcePermission2.primKey inner join Layout on ");
            sb.append("resourcePermission1.companyId = Layout.companyId and ");
            sb.append("resourcePermission1.primKey like ");
            sb.append("replace('[$PLID$]_LAYOUT_%', '[$PLID$]', ");
            sb.append("cast_text(Layout.plid)) and Layout.type_ = '");
            sb.append("portlet");
            sb.append('\'');
            sb.append(" inner join Group_ on Layout.groupId = Group_.groupId ");
            sb.append("where resourcePermission1.companyId = ");
            sb.append(companyId);
            sb.append(" and resourcePermission1.roleId = ");
            sb.append(powerUserRoleId);
            sb.append(" and resourcePermission2.roleId = ");
            sb.append(userRoleId);
            sb.append(" and resourcePermission1.scope = ");
            sb.append(4);
            sb.append(" and (Group_.classNameId = ");
            sb.append(userClassNameId);
            sb.append(" or Group_.classNameId = ");
            sb.append(userGroupClassNameId);
            sb.append(")");
            try (Statement ps1 = this.connection.createStatement();
                 PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"delete from ResourcePermission where resourcePermissionId = ?");){
                String sql = SQLTransformer.transform(sb.toString());
                try (ResultSet rs = ps1.executeQuery(sql);){
                    while (rs.next()) {
                        ps2.setLong(1, rs.getLong(1));
                        ps2.addBatch();
                    }
                }
                ps2.executeBatch();
            }
        }
    }

    @Deprecated
    protected void deleteDefaultPrivateLayoutPermissions() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            long[] companyIds;
            for (long companyId : companyIds = PortalInstances.getCompanyIdsBySQL()) {
                try {
                    this.deleteDefaultPrivateLayoutPermissions_6(companyId);
                }
                catch (Exception e) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Object)e, (Throwable)e);
                }
            }
        }
    }

    @Deprecated
    protected void deleteDefaultPrivateLayoutPermissions_6(long companyId) throws Exception {
        final Role role = RoleLocalServiceUtil.getRole((long)companyId, (String)"Guest");
        ActionableDynamicQuery actionableDynamicQuery = ResourcePermissionLocalServiceUtil.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                Property property = PropertyFactoryUtil.forName((String)"roleId");
                dynamicQuery.add(property.eq((Object)role.getRoleId()));
            }
        });
        actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<ResourcePermission>(){

            public void performAction(ResourcePermission resourcePermission) throws PortalException {
                if (VerifyPermission.this.isPrivateLayout(resourcePermission.getName(), resourcePermission.getPrimKey())) {
                    ResourcePermissionLocalServiceUtil.deleteResourcePermission((long)resourcePermission.getResourcePermissionId());
                }
            }
        });
        actionableDynamicQuery.performActions();
    }

    @Override
    protected void doVerify() throws Exception {
        this.checkPermissions();
        this.fixOrganizationRolePermissions();
        this.fixUserDefaultRolePermissions();
    }

    protected void fixOrganizationRolePermissions() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            ActionableDynamicQuery actionableDynamicQuery = ResourcePermissionLocalServiceUtil.getActionableDynamicQuery();
            actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"name", (Object)Organization.class.getName())));
            actionableDynamicQuery.setPerformActionMethod(resourcePermission -> {
                long oldActionIds = resourcePermission.getActionIds();
                long newActionIds = oldActionIds & (_deprecatedOrganizationBitwiseValues ^ 0xFFFFFFFFFFFFFFFFL);
                if (newActionIds == oldActionIds) {
                    return;
                }
                resourcePermission.setActionIds(newActionIds);
                ResourcePermissionLocalServiceUtil.updateResourcePermission((ResourcePermission)resourcePermission);
                long newGroupActionIds = 0L;
                for (Map.Entry<Long, Long> entry : _organizationToGroupBitwiseValues.entrySet()) {
                    long organizationBitwiseValue = entry.getKey();
                    long groupBitwiseValue = entry.getValue();
                    if ((oldActionIds & organizationBitwiseValue) == 0L) continue;
                    newGroupActionIds |= groupBitwiseValue;
                }
                ResourcePermission groupResourcePermission = ResourcePermissionLocalServiceUtil.fetchResourcePermission((long)resourcePermission.getCompanyId(), (String)Group.class.getName(), (int)resourcePermission.getScope(), (String)resourcePermission.getPrimKey(), (long)resourcePermission.getRoleId());
                if (groupResourcePermission == null) {
                    long resourcePermissionId = CounterLocalServiceUtil.increment((String)ResourcePermission.class.getName());
                    groupResourcePermission = ResourcePermissionLocalServiceUtil.createResourcePermission((long)resourcePermissionId);
                    groupResourcePermission.setCompanyId(resourcePermission.getCompanyId());
                    groupResourcePermission.setName(Group.class.getName());
                    groupResourcePermission.setScope(resourcePermission.getScope());
                    groupResourcePermission.setPrimKey(resourcePermission.getPrimKey());
                    groupResourcePermission.setPrimKeyId(GetterUtil.getLong((String)resourcePermission.getPrimKey()));
                    groupResourcePermission.setRoleId(resourcePermission.getRoleId());
                    groupResourcePermission.setOwnerId(0L);
                    groupResourcePermission.setViewActionId(newGroupActionIds % 2L == 1L);
                }
                groupResourcePermission.setActionIds(groupResourcePermission.getActionIds() | newGroupActionIds);
                ResourcePermissionLocalServiceUtil.updateResourcePermission((ResourcePermission)groupResourcePermission);
            });
            actionableDynamicQuery.performActions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void fixUserDefaultRolePermissions() throws Exception {
        DB db = DBManagerUtil.getDB();
        DBType dbType = db.getDBType();
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            long userClassNameId = PortalUtil.getClassNameId(User.class);
            long userGroupClassNameId = PortalUtil.getClassNameId(UserGroup.class);
            long[] companyIds = PortalInstances.getCompanyIdsBySQL();
            if (dbType == DBType.MARIADB || dbType == DBType.MYSQL) {
                this.fixUserDefaultRolePermissionsMySQL(userClassNameId, userGroupClassNameId, companyIds);
                return;
            }
            if (dbType == DBType.ORACLE) {
                this.fixUserDefaultRolePermissionsOracle(userClassNameId, userGroupClassNameId, companyIds);
                return;
            }
            long[] lArray = companyIds;
            int n = lArray.length;
            int n2 = 0;
            while (n2 < n) {
                long companyId = lArray[n2];
                Role powerUserRole = RoleLocalServiceUtil.getRole((long)companyId, (String)"Power User");
                Role userRole = RoleLocalServiceUtil.getRole((long)companyId, (String)"User");
                this.deleteConflictingUserDefaultRolePermissions(companyId, powerUserRole.getRoleId(), userRole.getRoleId(), userClassNameId, userGroupClassNameId);
                StringBundler sb = new StringBundler(20);
                sb.append("update ResourcePermission set roleId = ");
                sb.append(userRole.getRoleId());
                sb.append(" where resourcePermissionId in (select ");
                sb.append("resourcePermissionId from ResourcePermission ");
                sb.append("inner join Layout on ResourcePermission.companyId ");
                sb.append("= Layout.companyId and ResourcePermission.primKey ");
                sb.append("like replace('[$PLID$]_LAYOUT_%', '[$PLID$]', ");
                sb.append("cast_text(Layout.plid)) inner join Group_ on ");
                sb.append("Layout.groupId = Group_.groupId where ");
                sb.append("ResourcePermission.scope = ");
                sb.append(4);
                sb.append(" and ResourcePermission.roleId = ");
                sb.append(powerUserRole.getRoleId());
                sb.append(" and (Group_.classNameId = ");
                sb.append(userClassNameId);
                sb.append(" or Group_.classNameId = ");
                sb.append(userGroupClassNameId);
                sb.append(") and Layout.type_ = '");
                sb.append("portlet");
                sb.append("')");
                this.runSQL(sb.toString());
                ++n2;
            }
            return;
        }
        finally {
            EntityCacheUtil.clearCache();
            FinderCacheUtil.clearCache();
        }
    }

    protected void fixUserDefaultRolePermissionsMySQL(long userClassNameId, long userGroupClassNameId, long[] companyIds) throws Exception {
        block3: {
            try {
                this.runSQL("create index TEMP_INDEX on ResourcePermission (roleId, scope, primKey[$COLUMN_LENGTH:255$])");
            }
            catch (SQLException sqle) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Object)sqle, (Throwable)sqle);
            }
        }
        for (long companyId : companyIds) {
            Role powerUserRole = RoleLocalServiceUtil.getRole((long)companyId, (String)"Power User");
            Role userRole = RoleLocalServiceUtil.getRole((long)companyId, (String)"User");
            StringBundler sb = new StringBundler(18);
            sb.append("update ignore ResourcePermission inner join Layout on ");
            sb.append("ResourcePermission.primKey like ");
            sb.append("replace('[$PLID$]_LAYOUT_%', '[$PLID$]', ");
            sb.append("cast_text(Layout.plid)) inner join Group_ on ");
            sb.append("Layout.groupId = Group_.groupId set ");
            sb.append("ResourcePermission.roleId = ");
            sb.append(userRole.getRoleId());
            sb.append(" where ResourcePermission.scope = ");
            sb.append(4);
            sb.append(" and ResourcePermission.roleId = ");
            sb.append(powerUserRole.getRoleId());
            sb.append(" and (Group_.classNameId = ");
            sb.append(userClassNameId);
            sb.append(" or Group_.classNameId = ");
            sb.append(userGroupClassNameId);
            sb.append(") and Layout.type_ = '");
            sb.append("portlet");
            sb.append("'");
            this.runSQL(sb.toString());
        }
        this.runSQL("drop index TEMP_INDEX on ResourcePermission");
    }

    protected void fixUserDefaultRolePermissionsOracle(long userClassNameId, long userGroupClassNameId, long[] companyIds) throws Exception {
        block3: {
            try {
                this.runSQL("alter table ResourcePermission drop column plid");
            }
            catch (SQLException sqle) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Object)sqle, (Throwable)sqle);
            }
        }
        this.runSQL("alter table ResourcePermission add plid NUMBER null");
        this.runSQL("create index tmp_res_plid on ResourcePermission(plid)");
        StringBundler sb = new StringBundler(6);
        sb.append("update ResourcePermission r1 set plid = (select ");
        sb.append("SUBSTR(ResourcePermission.primKey, 0, ");
        sb.append("INSTR(ResourcePermission.primKey, '_LAYOUT_') -1) from ");
        sb.append("ResourcePermission where r1.resourcePermissionId = ");
        sb.append("ResourcePermission.resourcePermissionId and ");
        sb.append("ResourcePermission.primKey like '%_LAYOUT_%')");
        this.runSQL(sb.toString());
        for (long companyId : companyIds) {
            Role powerUserRole = RoleLocalServiceUtil.getRole((long)companyId, (String)"Power User");
            Role userRole = RoleLocalServiceUtil.getRole((long)companyId, (String)"User");
            sb = new StringBundler(24);
            sb.append("update ResourcePermission r1 set roleId = ");
            sb.append(userRole.getRoleId());
            sb.append(" where exists (select ");
            sb.append("ResourcePermission.resourcePermissionId from ");
            sb.append("ResourcePermission inner join Layout on ");
            sb.append("ResourcePermission.plid = Layout.plid inner join ");
            sb.append("Group_ on Layout.groupId = Group_.groupId where ");
            sb.append("r1.resourcePermissionId = ResourcePermission.");
            sb.append("resourcePermissionId and ResourcePermission.scope = ");
            sb.append(4);
            sb.append(" and ResourcePermission.roleId = ");
            sb.append(powerUserRole.getRoleId());
            sb.append(" and (Group_.classNameId = ");
            sb.append(userClassNameId);
            sb.append(" or Group_.classNameId = ");
            sb.append(userGroupClassNameId);
            sb.append(") and Layout.type_ = '");
            sb.append("portlet");
            sb.append("') and not exists (select resourcePermissionId from ");
            sb.append("ResourcePermission r2 where r1.name = r2.name and ");
            sb.append("r1.scope = r2.scope and r1.primKey = r2.primKey and ");
            sb.append("r2.roleId = ");
            sb.append(userRole.getRoleId());
            sb.append(")");
            this.runSQL(sb.toString());
        }
        this.runSQL("alter table ResourcePermission drop column plid");
    }

    @Deprecated
    protected boolean isPrivateLayout(String name, String primKey) throws PortalException {
        long plid;
        Layout layout;
        if (!name.equals(Layout.class.getName()) && !primKey.contains("_LAYOUT_")) {
            return false;
        }
        if (primKey.contains("_LAYOUT_")) {
            primKey = StringUtil.extractFirst((String)primKey, (String)"_LAYOUT_");
        }
        return !(layout = LayoutLocalServiceUtil.getLayout((long)(plid = GetterUtil.getLong((String)primKey)))).isPublicLayout() && !layout.isTypeControlPanel();
    }

    static {
        _organizationToGroupBitwiseValues = new HashMap<Long, Long>();
        String[] deprecatedOrganizationActionIds = new String[]{"MANAGE_ARCHIVED_SETUPS", "MANAGE_LAYOUTS", "MANAGE_STAGING", "MANAGE_TEAMS", "PUBLISH_STAGING", "APPROVE_PROPOSAL", "ASSIGN_REVIEWER"};
        long deprecatedOrganizationBitwiseValues = 0L;
        for (String actionId : deprecatedOrganizationActionIds) {
            ResourceAction organizationResourceAction = ResourceActionLocalServiceUtil.fetchResourceAction((String)Organization.class.getName(), (String)actionId);
            if (organizationResourceAction == null) continue;
            deprecatedOrganizationBitwiseValues |= organizationResourceAction.getBitwiseValue();
            ResourceAction groupResourceAction = ResourceActionLocalServiceUtil.fetchResourceAction((String)Group.class.getName(), (String)actionId);
            if (groupResourceAction == null) continue;
            _organizationToGroupBitwiseValues.put(organizationResourceAction.getBitwiseValue(), groupResourceAction.getBitwiseValue());
        }
        _deprecatedOrganizationBitwiseValues = deprecatedOrganizationBitwiseValues;
    }
}

