/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cache;

import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheListener;
import java.io.Serializable;
import java.util.Map;

public class PortalCacheMapSynchronizeUtil {
    public static <K extends Serializable, V> void synchronize(PortalCache<K, V> portalCache, Map<? extends K, ? extends V> map, Synchronizer<K, V> synchronizer) {
        portalCache.registerPortalCacheListener(new SynchronizePortalCacheListener<K, V>(map, synchronizer));
    }

    private static class SynchronizePortalCacheListener<K extends Serializable, V>
    implements PortalCacheListener<K, V> {
        private final Map<? extends K, ? extends V> _map;
        private final Synchronizer<K, V> _synchronizer;

        public SynchronizePortalCacheListener(Map<? extends K, ? extends V> map, Synchronizer<K, V> synchronizer) {
            this._map = map;
            this._synchronizer = synchronizer;
        }

        @Override
        public void dispose() {
        }

        @Override
        public void notifyEntryEvicted(PortalCache<K, V> portalCache, K key, V value, int timeToLive) {
            this._synchronizer.onSynchronize(this._map, (K)key, (V)value, timeToLive);
        }

        @Override
        public void notifyEntryExpired(PortalCache<K, V> portalCache, K key, V value, int timeToLive) {
            this._synchronizer.onSynchronize(this._map, (K)key, (V)value, timeToLive);
        }

        @Override
        public void notifyEntryPut(PortalCache<K, V> portalCache, K key, V value, int timeToLive) {
            this._synchronizer.onSynchronize(this._map, (K)key, (V)value, timeToLive);
        }

        @Override
        public void notifyEntryRemoved(PortalCache<K, V> portalCache, K key, V value, int timeToLive) {
            this._synchronizer.onSynchronize(this._map, (K)key, (V)value, timeToLive);
        }

        @Override
        public void notifyEntryUpdated(PortalCache<K, V> portalCache, K key, V value, int timeToLive) {
            this._synchronizer.onSynchronize(this._map, (K)key, (V)value, timeToLive);
        }

        @Override
        public void notifyRemoveAll(PortalCache<K, V> portalCache) {
            this._map.clear();
        }
    }

    public static interface Synchronizer<K extends Serializable, V> {
        public void onSynchronize(Map<? extends K, ? extends V> var1, K var2, V var3, int var4);
    }
}

