/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.nio.intraband.messaging;

import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.nio.intraband.Datagram;
import com.liferay.portal.kernel.nio.intraband.Intraband;
import com.liferay.portal.kernel.nio.intraband.RegistrationReference;
import com.liferay.portal.kernel.nio.intraband.SystemDataType;
import com.liferay.portal.kernel.nio.intraband.messaging.MessageRoutingBag;

public class IntrabandBridgeMessageListener
implements MessageListener {
    private final Intraband _intraband;
    private final byte _messageType;
    private final RegistrationReference _registrationReference;

    public IntrabandBridgeMessageListener(RegistrationReference registrationReference) {
        this._registrationReference = registrationReference;
        this._intraband = registrationReference.getIntraband();
        SystemDataType systemDataType = SystemDataType.MESSAGE;
        this._messageType = systemDataType.getValue();
    }

    @Override
    public void receive(Message message) {
        MessageRoutingBag messageRoutingBag = new MessageRoutingBag(message, false);
        this._intraband.sendDatagram(this._registrationReference, Datagram.createRequestDatagram(this._messageType, messageRoutingBag.toByteArray()));
    }
}

