/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.permission;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResourceBlockIdsBag
implements Serializable {
    private final Map<Long, Long> _permissions = new HashMap<Long, Long>();

    public void addResourceBlockId(long resourceBlockId, long actionIdsLong) {
        this._permissions.put(resourceBlockId, actionIdsLong |= this.getActionIds(resourceBlockId));
    }

    public long getActionIds(long resourceBlockId) {
        Long oldActionIdsLong = this._permissions.get(resourceBlockId);
        if (oldActionIdsLong == null) {
            oldActionIdsLong = 0L;
        }
        return oldActionIdsLong;
    }

    public List<Long> getResourceBlockIds(long actionIdsLong) {
        ArrayList<Long> resourceBlockIds = new ArrayList<Long>();
        for (Map.Entry<Long, Long> permission : this._permissions.entrySet()) {
            if ((permission.getValue() & actionIdsLong) != actionIdsLong) continue;
            resourceBlockIds.add(permission.getKey());
        }
        return resourceBlockIds;
    }

    public boolean hasResourceBlockId(long resourceBlockId, long actionIdsLong) {
        return (this.getActionIds(resourceBlockId) & actionIdsLong) == actionIdsLong;
    }
}

