/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.whitespace.WrapOption;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.util.Locale;
import org.apache.commons.beanutils.ConversionException;

public class OperatorWrapCheck
extends AbstractCheck {
    public static final String MSG_LINE_NEW = "line.new";
    public static final String MSG_LINE_PREVIOUS = "line.previous";
    private WrapOption option = WrapOption.NL;

    public void setOption(String optionStr) {
        try {
            this.option = WrapOption.valueOf(optionStr.trim().toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException iae) {
            throw new ConversionException("unable to parse " + optionStr, (Throwable)iae);
        }
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{109, 82, 116, 115, 127, 125, 126, 60, 128, 123, 124, 120, 118, 122, 119, 117, 113, 112, 110, 114, 111, 174, 121};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{109, 82, 116, 115, 127, 125, 126, 60, 128, 123, 124, 120, 118, 122, 119, 117, 113, 112, 110, 114, 111, 121, 174, 80, 101, 98, 99, 100, 102, 103, 104, 105, 107, 108, 106};
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtils.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST parent = ast.getParent();
        if (ast.getType() != 82 || parent.getType() != 94 && parent.getType() != 93) {
            String text = ast.getText();
            int colNo = ast.getColumnNo();
            int lineNo = ast.getLineNo();
            String currentLine = this.getLine(lineNo - 1);
            if (this.option == WrapOption.NL && !text.equals(currentLine.trim()) && CommonUtils.isBlank(currentLine.substring(colNo + text.length()))) {
                this.log(lineNo, colNo, MSG_LINE_NEW, text);
            } else if (this.option == WrapOption.EOL && CommonUtils.hasWhitespaceBefore(colNo - 1, currentLine)) {
                this.log(lineNo, colNo, MSG_LINE_PREVIOUS, text);
            }
        }
    }
}

