/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.comment;

import com.liferay.portal.kernel.comment.DiscussionPermission;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;

public abstract class BaseDiscussionPermission
implements DiscussionPermission {
    @Override
    public void checkAddPermission(long companyId, long groupId, String className, long classPK) throws PortalException {
        if (!this.hasAddPermission(companyId, groupId, className, classPK)) {
            throw new PrincipalException.MustHavePermission(0L, className, classPK, "ADD_DISCUSSION");
        }
    }

    @Override
    public void checkDeletePermission(long commentId) throws PortalException {
        if (!this.hasDeletePermission(commentId)) {
            throw new PrincipalException.MustHavePermission(0L, "DELETE_DISCUSSION");
        }
    }

    @Override
    public void checkSubscribePermission(long companyId, long groupId, String className, long classPK) throws PortalException {
        if (!this.hasSubscribePermission(companyId, groupId, className, classPK)) {
            throw new PrincipalException();
        }
    }

    @Override
    public void checkUpdatePermission(long commentId) throws PortalException {
        if (!this.hasUpdatePermission(commentId)) {
            throw new PrincipalException.MustHavePermission(0L, "UPDATE_DISCUSSION");
        }
    }

    @Override
    public void checkViewPermission(long companyId, long groupId, String className, long classPK) throws PortalException {
        if (!this.hasViewPermission(companyId, groupId, className, classPK)) {
            throw new PrincipalException.MustHavePermission(0L, className, classPK, "VIEW");
        }
    }

    @Override
    public boolean hasDeletePermission(long commentId) throws PortalException {
        return this.hasPermission(commentId, "DELETE_DISCUSSION");
    }

    @Override
    public boolean hasUpdatePermission(long commentId) throws PortalException {
        return this.hasPermission(commentId, "UPDATE_DISCUSSION");
    }
}

