/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.source.formatter.BaseSourceProcessor;
import com.liferay.source.formatter.SourceFormatterMessage;
import com.liferay.source.formatter.checkstyle.Checker;
import com.liferay.source.formatter.checkstyle.util.CheckstyleUtil;
import com.liferay.source.formatter.util.CheckType;
import com.liferay.source.formatter.util.DebugUtil;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class JavaSourceProcessor
extends BaseSourceProcessor {
    private static final int _CHECKSTYLE_BATCH_SIZE = 1000;
    private static final String[] _INCLUDES = new String[]{"**/*.java"};
    private Checker _checker;
    private List<File> _ungeneratedFiles = new ArrayList<File>();

    @Override
    protected List<String> doGetFileNames() throws Exception {
        Object[] includes = this.getIncludes();
        if (ArrayUtil.isEmpty(includes)) {
            return new ArrayList<String>();
        }
        Collection<String> fileNames = null;
        fileNames = this.portalSource || this.subrepository ? this._getPortalJavaFiles((String[])includes) : this._getPluginJavaFiles((String[])includes);
        return new ArrayList<String>(fileNames);
    }

    @Override
    protected String[] doGetIncludes() {
        return _INCLUDES;
    }

    @Override
    protected void format(File file, String fileName, String absolutePath, String content) throws Exception {
        if (this._hasGeneratedTag(content)) {
            return;
        }
        HashSet<String> modifiedContents = new HashSet<String>();
        String newContent = this.format(file, fileName, absolutePath, content, content, modifiedContents, 0);
        file = this.processFormattedFile(file, fileName, content, newContent);
        this._processCheckstyle(file);
    }

    @Override
    protected void postFormat() throws Exception {
        if (this._ungeneratedFiles.isEmpty()) {
            return;
        }
        Checker checker = this._getChecker();
        checker.process(this._ungeneratedFiles);
        Set<SourceFormatterMessage> sourceFormatterMessages = checker.getSourceFormatterMessages();
        for (SourceFormatterMessage sourceFormatterMessage : sourceFormatterMessages) {
            this.processMessage(sourceFormatterMessage.getFileName(), sourceFormatterMessage);
            this.printError(sourceFormatterMessage.getFileName(), sourceFormatterMessage.toString());
        }
    }

    private Checker _getChecker() throws Exception {
        if (this._checker != null) {
            return this._checker;
        }
        Configuration configuration = CheckstyleUtil.getConfiguration("checkstyle.xml");
        configuration = CheckstyleUtil.addAttribute(configuration, "maxLineLength", String.valueOf(this.sourceFormatterArgs.getMaxLineLength()), "com.liferay.source.formatter.checkstyle.checks.PlusStatement");
        configuration = CheckstyleUtil.addAttribute(configuration, "showDebugInformation", String.valueOf(this.sourceFormatterArgs.isShowDebugInformation()), "com.liferay.*");
        if (this.sourceFormatterArgs.isShowDebugInformation()) {
            DebugUtil.addCheckNames(CheckType.CHECKSTYLE, CheckstyleUtil.getCheckNames(configuration));
        }
        List<File> suppressionsFiles = SourceFormatterUtil.getSuppressionsFiles(this.sourceFormatterArgs.getBaseDirName(), "checkstyle-suppressions.xml", this.getAllFileNames(), this.getSourceFormatterExcludes(), this.portalSource, this.subrepository);
        this._checker = CheckstyleUtil.getChecker(configuration, suppressionsFiles, this.sourceFormatterArgs);
        return this._checker;
    }

    private String[] _getPluginExcludes(String pluginDirectoryName) {
        return new String[]{pluginDirectoryName + "**/model/*Clp.java", pluginDirectoryName + "**/model/impl/*BaseImpl.java", pluginDirectoryName + "**/model/impl/*Model.java", pluginDirectoryName + "**/model/impl/*ModelImpl.java", pluginDirectoryName + "**/service/**/service/*Service.java", pluginDirectoryName + "**/service/**/service/*ServiceClp.java", pluginDirectoryName + "**/service/**/service/*ServiceFactory.java", pluginDirectoryName + "**/service/**/service/*ServiceUtil.java", pluginDirectoryName + "**/service/**/service/*ServiceWrapper.java", pluginDirectoryName + "**/service/**/service/ClpSerializer.java", pluginDirectoryName + "**/service/**/service/messaging/*ClpMessageListener.java", pluginDirectoryName + "**/service/**/service/persistence/*Finder.java", pluginDirectoryName + "**/service/**/service/persistence/*Util.java", pluginDirectoryName + "**/service/base/*ServiceBaseImpl.java", pluginDirectoryName + "**/service/base/*ServiceClpInvoker.java", pluginDirectoryName + "**/service/http/*JSONSerializer.java", pluginDirectoryName + "**/service/http/*ServiceHttp.java", pluginDirectoryName + "**/service/http/*ServiceJSON.java", pluginDirectoryName + "**/service/http/*ServiceSoap.java", pluginDirectoryName + "**/tools/templates/**"};
    }

    private Collection<String> _getPluginJavaFiles(String[] includes) throws Exception {
        TreeSet<String> fileNames = new TreeSet<String>();
        String[] excludes = this._getPluginExcludes("");
        fileNames.addAll(this.getFileNames(excludes, includes));
        return fileNames;
    }

    private Collection<String> _getPortalJavaFiles(String[] includes) throws Exception {
        TreeSet<String> fileNames = new TreeSet<String>();
        String[] excludes = new String[]{"**/*_IW.java", "**/counter/service/**", "**/jsp/*", "**/model/impl/*Model.java", "**/model/impl/*ModelImpl.java", "**/portal/service/**", "**/portal-client/**", "**/portal-web/test/**/*Test.java", "**/test/*-generated/**"};
        if (this.subrepository) {
            excludes = ArrayUtil.append(excludes, this._getPluginExcludes(""));
        } else {
            for (String directoryName : this.getPluginsInsideModulesDirectoryNames()) {
                excludes = ArrayUtil.append(excludes, this._getPluginExcludes("**" + directoryName));
            }
        }
        fileNames.addAll(this.getFileNames(excludes, includes));
        excludes = new String[]{"**/portal-client/**", "**/tools/ext_tmpl/**", "**/*_IW.java", "**/test/**/*PersistenceTest.java"};
        includes = new String[]{"**/com/liferay/portal/kernel/service/ServiceContext*.java", "**/model/BaseModel.java", "**/model/impl/BaseModelImpl.java", "**/portal-test/**/portal/service/**/*.java", "**/portal-test-integration/**/portal/service/**/*.java", "**/service/Base*.java", "**/service/PersistedModelLocalService*.java", "**/service/configuration/**/*.java", "**/service/http/*HttpTest.java", "**/service/http/*SoapTest.java", "**/service/http/TunnelUtil.java", "**/service/impl/*.java", "**/service/jms/*.java", "**/service/permission/*.java", "**/service/persistence/BasePersistence.java", "**/service/persistence/BatchSession*.java", "**/service/persistence/*FinderImpl.java", "**/service/persistence/*Query.java", "**/service/persistence/impl/*.java", "**/portal-impl/test/**/*.java", "**/util-bridges/**/*.java"};
        fileNames.addAll(this.getFileNames(excludes, includes));
        return fileNames;
    }

    private boolean _hasGeneratedTag(String content) {
        return (content.contains("* @generated") || content.contains("$ANTLR")) && !content.contains("hasGeneratedTag");
    }

    private synchronized void _processCheckstyle(File file) throws Exception {
        this._ungeneratedFiles.add(file);
        if (this._ungeneratedFiles.size() == 1000) {
            Checker checker = this._getChecker();
            checker.process(this._ungeneratedFiles);
            this._ungeneratedFiles = new ArrayList<File>();
        }
    }
}

