/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseJavaTermCheck;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaStaticBlock;
import com.liferay.source.formatter.parser.JavaTerm;
import com.liferay.source.formatter.parser.comparator.JavaTermComparator;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaTermOrderCheck
extends BaseJavaTermCheck {
    private final Pattern _customSQLFilePattern = Pattern.compile("<sql file=\"(.*)\" \\/>");
    private String _portalCustomSQLContent;

    @Override
    public void init() throws Exception {
        this._portalCustomSQLContent = this._getPortalCustomSQLContent();
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) throws Exception {
        String javaTermContent = javaTerm.getContent();
        if (javaTermContent.contains("@Meta.OCD")) {
            return javaTermContent;
        }
        String className = javaTerm.getName();
        String customSQLContent = null;
        if (absolutePath.contains("/persistence/") && className.endsWith("FinderImpl")) {
            customSQLContent = this._getCustomSQLContent(fileName, absolutePath);
        }
        return this._sortJavaTerms(fileName, absolutePath, (JavaClass)javaTerm, customSQLContent);
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CLASS};
    }

    private String _getPortalCustomSQLContent() throws Exception {
        if (!this.isPortalSource()) {
            return null;
        }
        File portalCustomSQLFile = this.getFile("portal-impl/src/custom-sql/default.xml", 7);
        if (portalCustomSQLFile == null) {
            return null;
        }
        String portalCustomSQLContent = FileUtil.read(portalCustomSQLFile);
        Matcher matcher = this._customSQLFilePattern.matcher(portalCustomSQLContent);
        while (matcher.find()) {
            File customSQLFile = this.getFile("portal-impl/src/" + matcher.group(1), 7);
            if (customSQLFile == null) continue;
            portalCustomSQLContent = portalCustomSQLContent + FileUtil.read(customSQLFile);
        }
        return portalCustomSQLContent;
    }

    private String _getCustomSQLContent(String fileName, String absolutePath) throws Exception {
        if (this.isPortalSource() && !this.isModulesFile(absolutePath)) {
            return this._portalCustomSQLContent;
        }
        int i = fileName.lastIndexOf("/src/");
        if (i == -1) {
            return null;
        }
        File customSQLFile = new File(fileName.substring(0, i) + "/src/custom-sql/default.xml");
        if (!customSQLFile.exists()) {
            customSQLFile = new File(fileName.substring(0, i) + "/src/main/resources/META-INF/custom-sql/default.xml");
        }
        if (!customSQLFile.exists()) {
            customSQLFile = new File(fileName.substring(0, i) + "/src/main/resources/custom-sql/default.xml");
        }
        if (!customSQLFile.exists()) {
            return null;
        }
        return FileUtil.read(customSQLFile);
    }

    private String _sortJavaTerms(String fileName, String absolutePath, JavaClass javaClass, String customSQLContent) {
        List<JavaTerm> childJavaTerms = javaClass.getChildJavaTerms();
        if (childJavaTerms.size() < 2) {
            return javaClass.getContent();
        }
        JavaTermComparator javaTermComparator = new JavaTermComparator(customSQLContent);
        JavaTerm previousJavaTerm = null;
        for (JavaTerm javaTerm : childJavaTerms) {
            if (javaTerm instanceof JavaStaticBlock) continue;
            if (previousJavaTerm == null) {
                previousJavaTerm = javaTerm;
                continue;
            }
            int compare = javaTermComparator.compare(previousJavaTerm, javaTerm);
            if (compare == 0) {
                this.addMessage(fileName, "Duplicate " + javaTerm.getName());
            } else if (!this.isExcludedPath("javaterm.sort.excludes", absolutePath, previousJavaTerm.getName()) && !this.isExcludedPath("javaterm.sort.excludes", absolutePath, javaTerm.getName()) && compare > 0) {
                String classContent = javaClass.getContent();
                String newClassContent = StringUtil.replaceFirst(classContent, "\n" + previousJavaTerm.getContent(), "\n" + javaTerm.getContent());
                newClassContent = StringUtil.replaceLast(newClassContent, "\n" + javaTerm.getContent(), "\n" + previousJavaTerm.getContent());
                return newClassContent;
            }
            previousJavaTerm = javaTerm;
        }
        return javaClass.getContent();
    }
}

