/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.BNDSettings;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LanguageKeysCheck
extends BaseFileCheck {
    protected final Pattern languageKeyPattern = Pattern.compile("LanguageUtil.(?:get|format)\\([^;%]+|Liferay.Language.get\\('([^']+)");
    private final Pattern _applyLangMergerPluginPattern = Pattern.compile("^apply[ \t]+plugin[ \t]*:[ \t]+\"com.liferay.lang.merger\"$", 8);
    private final Pattern _mergeLangPattern = Pattern.compile("mergeLang \\{\\s*sourceDirs = \\[(.*?)\\]", 32);
    private final Map<String, Properties> _moduleLangLanguagePropertiesMap = new HashMap<String, Properties>();
    private final Map<String, Properties> _moduleLanguagePropertiesMap = new HashMap<String, Properties>();
    private Properties _portalLanguageProperties;

    @Override
    public void init() throws Exception {
        this._portalLanguageProperties = this.getPortalLanguageProperties();
    }

    @Override
    public boolean isPortalCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (!this.isSubrepository() && !absolutePath.contains("/modules/private/apps/")) {
            this._checkLanguageKeys(fileName, absolutePath, content, this.getPatterns());
        }
        return content;
    }

    protected List<Pattern> getPatterns() {
        return Arrays.asList(this.languageKeyPattern);
    }

    private void _checkLanguageKeys(String fileName, String absolutePath, String content, List<Pattern> patterns) throws Exception {
        if (fileName.endsWith(".vm")) {
            return;
        }
        for (Pattern pattern : patterns) {
            this._checkLanguageKeys(fileName, absolutePath, content, pattern);
        }
    }

    private void _checkLanguageKeys(String fileName, String absolutePath, String content, Pattern pattern) throws Exception {
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            String[] languageKeys;
            for (String languageKey : languageKeys = this._getLanguageKeys(matcher)) {
                Properties moduleLangLanguageProperties;
                Properties moduleLanguageProperties;
                if (Validator.isNumber(languageKey) || languageKey.endsWith("}") || languageKey.endsWith("-") || languageKey.endsWith("[") || languageKey.endsWith(".") || languageKey.endsWith("_") || languageKey.startsWith("-") || languageKey.startsWith("$") || languageKey.startsWith("[") || languageKey.startsWith("{") || languageKey.startsWith(".") || languageKey.startsWith("_") || this._portalLanguageProperties.containsKey(languageKey) || (moduleLanguageProperties = this._getModuleLanguageProperties(fileName)) != null && moduleLanguageProperties.containsKey(languageKey) || (moduleLangLanguageProperties = this._getModuleLangLanguageProperties(absolutePath)) != null && moduleLangLanguageProperties.containsKey(languageKey)) continue;
                BNDSettings bndSettings = this.getBNDSettings(fileName);
                if (bndSettings == null) {
                    this.addMessage(fileName, "Missing language key '" + languageKey + "'");
                    continue;
                }
                Properties bndFileLanguageProperties = bndSettings.getLanguageProperties();
                if (bndFileLanguageProperties != null && !bndFileLanguageProperties.containsKey(languageKey)) {
                    this.addMessage(fileName, "Missing language key '" + languageKey + "'");
                }
                this.putBNDSettings(bndSettings);
            }
        }
    }

    private String[] _getLanguageKeys(Matcher matcher) {
        int groupCount = matcher.groupCount();
        if (groupCount == 1) {
            String languageKey = matcher.group(1);
            if (Validator.isNotNull(languageKey)) {
                return new String[]{languageKey};
            }
        } else if (groupCount == 2) {
            String languageKey = matcher.group(2);
            languageKey = TextFormatter.format(languageKey, 10);
            return new String[]{languageKey};
        }
        StringBundler sb = new StringBundler();
        String match = matcher.group();
        int count = 0;
        block5: for (int i = 0; i < match.length(); ++i) {
            char c = match.charAt(i);
            switch (c) {
                case ')': {
                    if (count <= 1) {
                        return new String[0];
                    }
                    --count;
                    continue block5;
                }
                case '(': {
                    ++count;
                    continue block5;
                }
                case '\"': {
                    if (count > 1) continue block5;
                    while (i < match.length()) {
                        if (match.charAt(++i) == '\"') {
                            String languageKey = sb.toString();
                            if (match.startsWith("names")) {
                                return StringUtil.split(languageKey);
                            }
                            return new String[]{languageKey};
                        }
                        sb.append(match.charAt(i));
                    }
                    continue block5;
                }
            }
        }
        return new String[0];
    }

    private List<String> _getModuleLangDirNames(String moduleLocation, String buildGradleContent) {
        ArrayList<String> moduleLangDirNames = new ArrayList<String>();
        Matcher matcher = this._mergeLangPattern.matcher(buildGradleContent);
        if (matcher.find()) {
            String[] sourceDirs;
            for (String sourceDir : sourceDirs = StringUtil.split(matcher.group(1))) {
                sourceDir = StringUtil.trim(sourceDir);
                moduleLangDirNames.add(moduleLocation + "/" + sourceDir.substring(1, sourceDir.length() - 1));
            }
            return moduleLangDirNames;
        }
        int x = moduleLocation.lastIndexOf("/");
        String baseModuleName = moduleLocation.substring(0, x);
        int y = baseModuleName.lastIndexOf("/");
        baseModuleName = baseModuleName.substring(y + 1, baseModuleName.length());
        String moduleLangDirName = moduleLocation.substring(0, x + 1) + baseModuleName + "-lang/src/main/resources/content";
        File moduleLangDir = new File(moduleLangDirName);
        if (!moduleLangDir.exists() && moduleLangDirName.contains("/modules/ee/")) {
            moduleLangDirName = StringUtil.replaceFirst(moduleLangDirName, "/modules/ee/", "/modules/");
        }
        moduleLangDirNames.add(moduleLangDirName);
        return moduleLangDirNames;
    }

    private Properties _getModuleLangLanguageProperties(String absolutePath) throws Exception {
        File file;
        Properties properties = this._moduleLangLanguagePropertiesMap.get(absolutePath);
        if (properties != null) {
            return properties;
        }
        String buildGradleContent = null;
        String buildGradleFileLocation = absolutePath;
        while (true) {
            int pos;
            if ((pos = buildGradleFileLocation.lastIndexOf("/")) == -1) {
                return null;
            }
            file = new File((buildGradleFileLocation = buildGradleFileLocation.substring(0, pos + 1)) + "build.gradle");
            if (file.exists()) break;
            buildGradleFileLocation = StringUtil.replaceLast(buildGradleFileLocation, '/', "");
        }
        buildGradleContent = FileUtil.read(file);
        Matcher matcher = this._applyLangMergerPluginPattern.matcher(buildGradleContent);
        if (!matcher.find()) {
            return null;
        }
        String moduleLocation = StringUtil.replaceLast(buildGradleFileLocation, '/', "");
        List<String> moduleLangDirNames = this._getModuleLangDirNames(moduleLocation, buildGradleContent);
        properties = new Properties();
        for (String moduleLangDirName : moduleLangDirNames) {
            String moduleLangLanguagePropertiesFileName = moduleLangDirName + "/Language.properties";
            File file2 = new File(moduleLangLanguagePropertiesFileName);
            if (!file2.exists()) continue;
            FileInputStream inputStream = new FileInputStream(file2);
            properties.load(inputStream);
        }
        this._moduleLangLanguagePropertiesMap.put(absolutePath, properties);
        return properties;
    }

    private Properties _getModuleLanguageProperties(String fileName) {
        Properties properties = this._moduleLanguagePropertiesMap.get(fileName);
        if (properties != null) {
            return properties;
        }
        StringBundler sb = new StringBundler(3);
        int pos = fileName.indexOf("/docroot/");
        if (pos != -1) {
            sb.append(fileName.substring(0, pos + 9));
            sb.append("WEB-INF/src/");
        } else {
            pos = fileName.indexOf("src/");
            if (pos == -1) {
                return null;
            }
            sb.append(fileName.substring(0, pos + 4));
            if (fileName.contains("src/main/")) {
                sb.append("main/resources/");
            }
        }
        sb.append("content/Language.properties");
        try {
            properties = new Properties();
            FileInputStream inputStream = new FileInputStream(sb.toString());
            properties.load(inputStream);
            this._moduleLanguagePropertiesMap.put(fileName, properties);
            return properties;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

