/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MarkdownStylingCheck
extends BaseFileCheck {
    private final Pattern _boldHeaderPattern = Pattern.compile("(\\A|\n)(#+ ?)(\\*+)([^\\*\n]+)(\\*+)(\n)");
    private final Pattern _incorrectHeaderNotationPattern = Pattern.compile("(\\A|\n)(#+[^#\n]+)(#+)(\n)");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        return this._formatHeaders(content);
    }

    private String _formatHeaders(String content) {
        Matcher matcher = this._incorrectHeaderNotationPattern.matcher(content);
        content = matcher.replaceAll("$1$2$4");
        matcher = this._boldHeaderPattern.matcher(content);
        return matcher.replaceAll("$1$2$4$6");
    }
}

