/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.liferay.source.formatter.util.DebugUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConstantNameCheck
extends com.puppycrawl.tools.checkstyle.checks.naming.ConstantNameCheck {
    private static final String _MSG_INVALID_PRIVATE_NAME = "name.invalidPrivatePattern";
    private static final String _MSG_INVALID_PROTECTED_PUBLIC_NAME = "name.invalidProtectedPublicPattern";
    private static final String _MSG_PRIVATE_COLLECTION = "name.collectionPrivatePattern";
    private static final String _MSG_PROTECTED_PUBLIC_COLLECTION = "name.collectionProtectedPublicPattern";
    private boolean _showDebugInformation;

    public void setShowDebugInformation(boolean showDebugInformation) {
        this._showDebugInformation = showDebugInformation;
    }

    public void visitToken(DetailAST detailAST) {
        if (!this._showDebugInformation) {
            this._checkConstantName(detailAST);
            return;
        }
        long startTime = System.currentTimeMillis();
        this._checkConstantName(detailAST);
        long endTime = System.currentTimeMillis();
        Class<?> clazz = ((Object)((Object)this)).getClass();
        DebugUtil.increaseProcessingTime(clazz.getSimpleName(), endTime - startTime);
    }

    private void _checkConstantName(DetailAST detailAST) {
        if (!this.mustCheckName(detailAST)) {
            return;
        }
        String message = null;
        String regex = null;
        DetailAST modifiersAST = detailAST.findFirstToken(5);
        if (modifiersAST.branchContains(61)) {
            if (DetailASTUtil.isCollection(detailAST.findFirstToken(13))) {
                message = _MSG_PRIVATE_COLLECTION;
                regex = "^_[a-z0-9][_a-zA-Z0-9]*$";
            } else {
                message = _MSG_INVALID_PRIVATE_NAME;
                regex = "^_[_a-zA-Z0-9]*$";
            }
        } else if (modifiersAST.branchContains(63) || modifiersAST.branchContains(62)) {
            if (DetailASTUtil.isCollection(detailAST.findFirstToken(13))) {
                message = _MSG_PROTECTED_PUBLIC_COLLECTION;
                regex = "^[a-z0-9][_a-zA-Z0-9]*$";
            } else {
                message = _MSG_INVALID_PROTECTED_PUBLIC_NAME;
                regex = "^[a-zA-Z0-9][_a-zA-Z0-9]*$";
            }
        } else {
            return;
        }
        DetailAST nameAST = detailAST.findFirstToken(58);
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(nameAST.getText());
        if (!matcher.find()) {
            this.log(nameAST.getLineNo(), message, new Object[]{nameAST.getText(), regex});
        }
    }
}

