/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.jdbc;

import com.liferay.portal.dao.jdbc.pool.metrics.C3P0ConnectionPoolMetrics;
import com.liferay.portal.dao.jdbc.pool.metrics.DBCPConnectionPoolMetrics;
import com.liferay.portal.dao.jdbc.pool.metrics.HikariConnectionPoolMetrics;
import com.liferay.portal.dao.jdbc.pool.metrics.TomcatConnectionPoolMetrics;
import com.liferay.portal.dao.jdbc.util.DataSourceWrapper;
import com.liferay.portal.dao.jdbc.util.RetryDataSourceWrapper;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.dao.jdbc.DataSourceFactory;
import com.liferay.portal.kernel.dao.jdbc.pool.metrics.ConnectionPoolMetrics;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.jndi.JNDIUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.ClassLoaderUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.SortedProperties;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.hibernate.DialectDetector;
import com.liferay.portal.util.JarUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.mchange.v2.c3p0.impl.AbstractPoolBackedDataSource;
import java.io.Closeable;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import jodd.bean.BeanUtil;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.dbcp.BasicDataSourceFactory;
import org.apache.tomcat.jdbc.pool.ConnectionPool;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.apache.tomcat.jdbc.pool.DataSourceProxy;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;
import org.apache.tomcat.jdbc.pool.PoolProperties;

@DoPrivileged
public class DataSourceFactoryImpl
implements DataSourceFactory {
    private static final String _HIKARICP_DATASOURCE_CLASS_NAME = "com.zaxxer.hikari.HikariDataSource";
    private static final String _TOMCAT_JDBC_POOL_OBJECT_NAME_PREFIX = "TomcatJDBCPool:type=ConnectionPool,name=";
    private static final Log _log = LogFactoryUtil.getLog(DataSourceFactoryImpl.class);
    private static final PACL _pacl = new NoPACL();
    private ServiceTracker<MBeanServer, MBeanServer> _serviceTracker;

    public void destroyDataSource(javax.sql.DataSource dataSource) throws Exception {
        while (dataSource instanceof DataSourceWrapper) {
            DataSourceWrapper dataSourceWrapper = (DataSourceWrapper)dataSource;
            dataSource = dataSourceWrapper.getWrappedDataSource();
        }
        if (dataSource instanceof ComboPooledDataSource) {
            ComboPooledDataSource comboPooledDataSource = (ComboPooledDataSource)dataSource;
            comboPooledDataSource.close();
        } else if (dataSource instanceof DataSource) {
            DataSource tomcatDataSource = (DataSource)dataSource;
            if (this._serviceTracker != null) {
                this._serviceTracker.close();
            }
            tomcatDataSource.close();
        } else if (dataSource instanceof BasicDataSource) {
            BasicDataSource basicDataSource = (BasicDataSource)dataSource;
            basicDataSource.close();
        } else if (dataSource instanceof Closeable) {
            Closeable closeable = (Closeable)((Object)dataSource);
            closeable.close();
        }
    }

    public javax.sql.DataSource initDataSource(Properties properties) throws Exception {
        DBType dbType;
        Properties defaultProperties = PropsUtil.getProperties("jdbc.default.", true);
        PropertiesUtil.merge((Properties)defaultProperties, (Properties)properties);
        properties = defaultProperties;
        this.testDatabaseClass(properties);
        this._waitForJDBCConnection(properties);
        String jndiName = properties.getProperty("jndi.name");
        if (Validator.isNotNull((String)jndiName)) {
            try {
                Properties jndiEnvironmentProperties = PropsUtil.getProperties("jndi.environment.", true);
                InitialContext context = new InitialContext(jndiEnvironmentProperties);
                return (javax.sql.DataSource)JNDIUtil.lookup((Context)context, (String)jndiName);
            }
            catch (Exception e) {
                _log.error((Object)("Unable to lookup " + jndiName), (Throwable)e);
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Data source properties:\n");
            SortedProperties sortedProperties = new SortedProperties(properties);
            _log.debug((Object)PropertiesUtil.toString((Properties)sortedProperties));
        }
        javax.sql.DataSource dataSource = null;
        String liferayPoolProvider = PropsValues.JDBC_DEFAULT_LIFERAY_POOL_PROVIDER;
        if (StringUtil.equalsIgnoreCase((String)liferayPoolProvider, (String)"c3p0") || StringUtil.equalsIgnoreCase((String)liferayPoolProvider, (String)"c3po")) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Initializing C3P0 data source");
            }
            dataSource = this.initDataSourceC3PO(properties);
        } else if (StringUtil.equalsIgnoreCase((String)liferayPoolProvider, (String)"dbcp")) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Initializing DBCP data source");
            }
            dataSource = this.initDataSourceDBCP(properties);
        } else if (StringUtil.equalsIgnoreCase((String)liferayPoolProvider, (String)"hikaricp")) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Initializing HikariCP data source");
            }
            dataSource = this.initDataSourceHikariCP(properties);
        } else {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Initializing Tomcat data source");
            }
            dataSource = this.initDataSourceTomcat(properties);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Created data source " + dataSource.getClass()));
        }
        if (PropsValues.RETRY_DATA_SOURCE_MAX_RETRIES > 0 && (dbType = DBManagerUtil.getDBType((Object)DialectDetector.getDialect(dataSource))) == DBType.SYBASE) {
            dataSource = new RetryDataSourceWrapper(dataSource);
        }
        return _pacl.getDataSource(dataSource);
    }

    public javax.sql.DataSource initDataSource(String driverClassName, String url, String userName, String password, String jndiName) throws Exception {
        Properties properties = new Properties();
        properties.setProperty("driverClassName", driverClassName);
        properties.setProperty("url", url);
        properties.setProperty("username", userName);
        properties.setProperty("password", password);
        properties.setProperty("jndi.name", jndiName);
        return this.initDataSource(properties);
    }

    protected javax.sql.DataSource initDataSourceC3PO(Properties properties) throws Exception {
        ComboPooledDataSource comboPooledDataSource = new ComboPooledDataSource();
        String identityToken = StringUtil.randomString();
        comboPooledDataSource.setIdentityToken(identityToken);
        String connectionPropertiesString = (String)properties.remove("connectionProperties");
        if (connectionPropertiesString != null) {
            Properties connectionProperties = PropertiesUtil.load((String)StringUtil.replace((String)connectionPropertiesString, (char)';', (char)'\n'));
            comboPooledDataSource.setProperties(connectionProperties);
        }
        Enumeration<?> enu = properties.propertyNames();
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            String value = properties.getProperty(key);
            if (StringUtil.equalsIgnoreCase((String)key, (String)"driverClassName")) {
                key = "driverClass";
            } else if (StringUtil.equalsIgnoreCase((String)key, (String)"url")) {
                key = "jdbcUrl";
            } else if (StringUtil.equalsIgnoreCase((String)key, (String)"username")) {
                key = "user";
            }
            if (this.isPropertyLiferay(key) || this.isPropertyDBCP(key) || this.isPropertyHikariCP(key) || this.isPropertyTomcat(key)) continue;
            try {
                BeanUtil.setProperty((Object)comboPooledDataSource, (String)key, (Object)value);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Property " + key + " is an invalid C3PO property"));
            }
        }
        this.registerConnectionPoolMetrics(new C3P0ConnectionPoolMetrics((AbstractPoolBackedDataSource)comboPooledDataSource));
        return comboPooledDataSource;
    }

    protected javax.sql.DataSource initDataSourceDBCP(Properties properties) throws Exception {
        javax.sql.DataSource dataSource = BasicDataSourceFactory.createDataSource((Properties)properties);
        this.registerConnectionPoolMetrics(new DBCPConnectionPoolMetrics((BasicDataSource)dataSource));
        return dataSource;
    }

    protected javax.sql.DataSource initDataSourceHikariCP(Properties properties) throws Exception {
        this.testLiferayPoolProviderClass(_HIKARICP_DATASOURCE_CLASS_NAME);
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        Class<?> hikariDataSourceClazz = contextClassLoader.loadClass(_HIKARICP_DATASOURCE_CLASS_NAME);
        Object hikariDataSource = hikariDataSourceClazz.newInstance();
        String connectionPropertiesString = (String)properties.remove("connectionProperties");
        if (connectionPropertiesString != null) {
            Properties connectionProperties = PropertiesUtil.load((String)StringUtil.replace((String)connectionPropertiesString, (char)';', (char)'\n'));
            BeanUtil.setProperty(hikariDataSource, (String)"dataSourceProperties", (Object)connectionProperties);
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (StringUtil.equalsIgnoreCase((String)key, (String)"url")) {
                key = "jdbcUrl";
            }
            if (this.isPropertyLiferay(key) || this.isPropertyC3PO(key) || this.isPropertyDBCP(key) || this.isPropertyTomcat(key)) continue;
            try {
                BeanUtil.setProperty(hikariDataSource, (String)key, (Object)value);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Property " + key + " is an invalid HikariCP property"));
            }
        }
        this.registerConnectionPoolMetrics(new HikariConnectionPoolMetrics(hikariDataSource));
        return (javax.sql.DataSource)hikariDataSource;
    }

    protected javax.sql.DataSource initDataSourceTomcat(Properties properties) throws Exception {
        PoolProperties poolProperties = new PoolProperties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (this.isPropertyLiferay(key) || this.isPropertyC3PO(key) || this.isPropertyHikariCP(key)) continue;
            try {
                BeanUtil.setProperty((Object)poolProperties, (String)key, (Object)value);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Property " + key + " is an invalid Tomcat JDBC property"));
            }
        }
        String poolName = StringUtil.randomString();
        poolProperties.setName(poolName);
        DataSource dataSource = new DataSource((PoolConfiguration)poolProperties);
        if (poolProperties.isJmxEnabled()) {
            Registry registry = RegistryUtil.getRegistry();
            this._serviceTracker = registry.trackServices(MBeanServer.class, (ServiceTrackerCustomizer)new MBeanServerServiceTrackerCustomizer(dataSource, poolName));
            this._serviceTracker.open();
        }
        this.registerConnectionPoolMetrics(new TomcatConnectionPoolMetrics((DataSourceProxy)dataSource));
        return dataSource;
    }

    protected boolean isPropertyC3PO(String key) {
        return StringUtil.equalsIgnoreCase((String)key, (String)"acquireIncrement") || StringUtil.equalsIgnoreCase((String)key, (String)"acquireRetryAttempts") || StringUtil.equalsIgnoreCase((String)key, (String)"acquireRetryDelay") || StringUtil.equalsIgnoreCase((String)key, (String)"connectionCustomizerClassName") || StringUtil.equalsIgnoreCase((String)key, (String)"idleConnectionTestPeriod") || StringUtil.equalsIgnoreCase((String)key, (String)"initialPoolSize") || StringUtil.equalsIgnoreCase((String)key, (String)"maxIdleTime") || StringUtil.equalsIgnoreCase((String)key, (String)"maxPoolSize") || StringUtil.equalsIgnoreCase((String)key, (String)"minPoolSize") || StringUtil.equalsIgnoreCase((String)key, (String)"numHelperThreads") || StringUtil.equalsIgnoreCase((String)key, (String)"preferredTestQuery");
    }

    protected boolean isPropertyDBCP(String key) {
        return StringUtil.equalsIgnoreCase((String)key, (String)"defaultTransactionIsolation") || StringUtil.equalsIgnoreCase((String)key, (String)"maxActive") || StringUtil.equalsIgnoreCase((String)key, (String)"minIdle") || StringUtil.equalsIgnoreCase((String)key, (String)"removeAbandonedTimeout");
    }

    protected boolean isPropertyHikariCP(String key) {
        return StringUtil.equalsIgnoreCase((String)key, (String)"autoCommit") || StringUtil.equalsIgnoreCase((String)key, (String)"connectionTestQuery") || StringUtil.equalsIgnoreCase((String)key, (String)"connectionTimeout") || StringUtil.equalsIgnoreCase((String)key, (String)"idleTimeout") || StringUtil.equalsIgnoreCase((String)key, (String)"initializationFailFast") || StringUtil.equalsIgnoreCase((String)key, (String)"maximumPoolSize") || StringUtil.equalsIgnoreCase((String)key, (String)"maxLifetime") || StringUtil.equalsIgnoreCase((String)key, (String)"minimumIdle") || StringUtil.equalsIgnoreCase((String)key, (String)"registerMbeans");
    }

    protected boolean isPropertyLiferay(String key) {
        return StringUtil.equalsIgnoreCase((String)key, (String)"jndi.name") || StringUtil.equalsIgnoreCase((String)key, (String)"liferay.pool.provider");
    }

    protected boolean isPropertyTomcat(String key) {
        return StringUtil.equalsIgnoreCase((String)key, (String)"fairQueue") || StringUtil.equalsIgnoreCase((String)key, (String)"initialSize") || StringUtil.equalsIgnoreCase((String)key, (String)"jdbcInterceptors") || StringUtil.equalsIgnoreCase((String)key, (String)"jmxEnabled") || StringUtil.equalsIgnoreCase((String)key, (String)"maxIdle") || StringUtil.equalsIgnoreCase((String)key, (String)"testWhileIdle") || StringUtil.equalsIgnoreCase((String)key, (String)"timeBetweenEvictionRunsMillis") || StringUtil.equalsIgnoreCase((String)key, (String)"useEquals") || StringUtil.equalsIgnoreCase((String)key, (String)"validationQuery");
    }

    protected void registerConnectionPoolMetrics(ConnectionPoolMetrics connectionPoolMetrics) {
        Registry registry = RegistryUtil.getRegistry();
        registry.registerService(ConnectionPoolMetrics.class, (Object)connectionPoolMetrics);
    }

    protected void testDatabaseClass(Properties properties) throws Exception {
        String driverClassName = properties.getProperty("driverClassName");
        try {
            Class.forName(driverClassName);
        }
        catch (ClassNotFoundException cnfe) {
            if (!ServerDetector.isJetty() && !ServerDetector.isTomcat()) {
                throw cnfe;
            }
            String url = PropsUtil.get("setup.database.jar.url", new Filter(driverClassName));
            String name = PropsUtil.get("setup.database.jar.name", new Filter(driverClassName));
            if (Validator.isNull((String)url) || Validator.isNull((String)name)) {
                throw cnfe;
            }
            ClassLoader classLoader = SystemException.class.getClassLoader();
            if (!(classLoader instanceof URLClassLoader)) {
                _log.error((Object)"Unable to install JAR because the system class loader is not an instance of URLClassLoader");
                return;
            }
            JarUtil.downloadAndInstallJar(new URL(url), PropsValues.LIFERAY_LIB_GLOBAL_DIR, name, (URLClassLoader)classLoader);
        }
    }

    protected void testLiferayPoolProviderClass(String className) throws Exception {
        try {
            Class.forName(className);
        }
        catch (ClassNotFoundException cnfe) {
            if (!ServerDetector.isJetty() && !ServerDetector.isTomcat()) {
                throw cnfe;
            }
            String url = PropsUtil.get("setup.liferay.pool.provider.jar.url", new Filter(PropsValues.JDBC_DEFAULT_LIFERAY_POOL_PROVIDER));
            String name = PropsUtil.get("setup.liferay.pool.provider.jar.name", new Filter(PropsValues.JDBC_DEFAULT_LIFERAY_POOL_PROVIDER));
            if (Validator.isNull((String)url) || Validator.isNull((String)name)) {
                throw cnfe;
            }
            ClassLoader classLoader = ClassLoaderUtil.getPortalClassLoader();
            if (!(classLoader instanceof URLClassLoader)) {
                _log.error((Object)"Unable to install JAR because the portal class loader is not an instance of URLClassLoader");
                return;
            }
            JarUtil.downloadAndInstallJar(new URL(url), PropsValues.LIFERAY_LIB_PORTAL_DIR, name, (URLClassLoader)classLoader);
        }
    }

    private void _waitForJDBCConnection(Properties properties) {
        int maxRetries = PropsValues.RETRY_JDBC_ON_STARTUP_MAX_RETRIES;
        if (maxRetries <= 0) {
            return;
        }
        int delay = PropsValues.RETRY_JDBC_ON_STARTUP_DELAY;
        if (delay < 0) {
            delay = 0;
        }
        String url = properties.getProperty("url");
        String username = properties.getProperty("username");
        String password = properties.getProperty("password");
        int count = maxRetries;
        while (count-- > 0) {
            block25: {
                try (Connection connection = DriverManager.getConnection(url, username, password);){
                    if (connection != null) {
                        if (_log.isInfoEnabled()) {
                            _log.info((Object)"Successfully acquired JDBC connection");
                        }
                        return;
                    }
                }
                catch (SQLException sqle) {
                    if (!_log.isDebugEnabled()) break block25;
                    _log.error((Object)"Unable to acquire JDBC connection", (Throwable)sqle);
                }
            }
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("At attempt " + (maxRetries - count) + " of " + maxRetries + " in acquiring a JDBC connection after a " + delay + " second " + delay));
            }
            try {
                Thread.sleep((long)delay * 1000L);
            }
            catch (InterruptedException ie) {
                if (!_log.isWarnEnabled()) break;
                _log.warn((Object)"Interruptted acquiring a JDBC connection", (Throwable)ie);
                break;
            }
        }
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Unable to acquire a direct JDBC connection, proceeding to use a data source instead");
        }
    }

    private static class NoPACL
    implements PACL {
        private NoPACL() {
        }

        @Override
        public javax.sql.DataSource getDataSource(javax.sql.DataSource dataSource) {
            return dataSource;
        }
    }

    private static class MBeanServerServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<MBeanServer, MBeanServer> {
        private final DataSource _dataSource;
        private final ObjectName _objectName;

        public MBeanServerServiceTrackerCustomizer(DataSource dataSource, String poolName) throws MalformedObjectNameException {
            this._dataSource = dataSource;
            this._objectName = new ObjectName(DataSourceFactoryImpl._TOMCAT_JDBC_POOL_OBJECT_NAME_PREFIX + poolName);
        }

        public MBeanServer addingService(ServiceReference<MBeanServer> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            MBeanServer mBeanServer = (MBeanServer)registry.getService(serviceReference);
            try {
                ConnectionPool jdbcConnectionPool = this._dataSource.createPool();
                org.apache.tomcat.jdbc.pool.jmx.ConnectionPool jmxConnectionPool = jdbcConnectionPool.getJmxPool();
                mBeanServer.registerMBean(jmxConnectionPool, this._objectName);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
            return mBeanServer;
        }

        public void modifiedService(ServiceReference<MBeanServer> serviceReference, MBeanServer mBeanServer) {
        }

        public void removedService(ServiceReference<MBeanServer> serviceReference, MBeanServer mBeanServer) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            try {
                mBeanServer.unregisterMBean(this._objectName);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
    }

    public static interface PACL {
        public javax.sql.DataSource getDataSource(javax.sql.DataSource var1);
    }
}

