/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.hibernate.event;

import java.util.Map;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.engine.ActionQueue;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.AutoFlushEvent;
import org.hibernate.event.EventSource;
import org.hibernate.event.FlushEvent;
import org.hibernate.event.def.DefaultAutoFlushEventListener;
import org.hibernate.stat.Statistics;
import org.hibernate.stat.StatisticsImplementor;

public class NestableAutoFlushEventListener
extends DefaultAutoFlushEventListener {
    public static final NestableAutoFlushEventListener INSTANCE = new NestableAutoFlushEventListener();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAutoFlush(AutoFlushEvent autoFlushEvent) throws HibernateException {
        EventSource eventSource = autoFlushEvent.getSession();
        if (!this._isFlushable(eventSource)) {
            return;
        }
        ActionQueue actionQueue = eventSource.getActionQueue();
        int oldSize = actionQueue.numberOfCollectionRemovals();
        PersistenceContext persistenceContext = eventSource.getPersistenceContext();
        boolean flushing = persistenceContext.isFlushing();
        try {
            this.flushEverythingToExecutions((FlushEvent)autoFlushEvent);
        }
        finally {
            persistenceContext.setFlushing(flushing);
        }
        if (this._isFlushReallyNeeded(autoFlushEvent, eventSource)) {
            persistenceContext.setFlushing(true);
            try {
                this.performExecutions(eventSource);
                this.postFlush((SessionImplementor)eventSource);
            }
            finally {
                persistenceContext.setFlushing(flushing);
            }
            SessionFactoryImplementor sessionFactoryImplementor = eventSource.getFactory();
            Statistics statistics = sessionFactoryImplementor.getStatistics();
            if (statistics.isStatisticsEnabled()) {
                StatisticsImplementor statisticsImplementor = sessionFactoryImplementor.getStatisticsImplementor();
                statisticsImplementor.flush();
            }
        } else if (!persistenceContext.isFlushing()) {
            actionQueue.clearFromFlushNeededCheck(oldSize);
        }
        autoFlushEvent.setFlushRequired(this._isFlushReallyNeeded(autoFlushEvent, eventSource));
    }

    private boolean _isFlushable(EventSource eventSource) {
        FlushMode flushMode = eventSource.getFlushMode();
        if (flushMode.lessThan(FlushMode.AUTO)) {
            return false;
        }
        if (eventSource.getDontFlushFromFind() != 0) {
            return false;
        }
        PersistenceContext persistenceContext = eventSource.getPersistenceContext();
        Map entityEntries = persistenceContext.getEntityEntries();
        if (!entityEntries.isEmpty()) {
            return true;
        }
        Map collectionEntries = persistenceContext.getCollectionEntries();
        return !collectionEntries.isEmpty();
    }

    private boolean _isFlushReallyNeeded(AutoFlushEvent autoFlushEvent, EventSource eventSource) {
        if (eventSource.getFlushMode() == FlushMode.ALWAYS) {
            return true;
        }
        ActionQueue actionQueue = eventSource.getActionQueue();
        return actionQueue.areTablesToBeUpdated(autoFlushEvent.getQuerySpaces());
    }
}

