/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.jsonwebservice;

import com.liferay.portal.kernel.json.JSONDeserializer;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import jodd.servlet.ServletUtil;

public class JSONRPCRequest {
    private static final Log _log = LogFactoryUtil.getLog(JSONRPCRequest.class);
    private Integer _id;
    private String _jsonrpc;
    private String _method;
    private Map<String, ?> _parameters;

    public static JSONRPCRequest detectJSONRPCRequest(HttpServletRequest request) {
        try {
            String requestBody = ServletUtil.readRequestBody((HttpServletRequest)request);
            if (Validator.isNull((String)requestBody) || !requestBody.startsWith("{") || !requestBody.endsWith("}")) {
                return null;
            }
            JSONDeserializer jsonDeserializer = JSONFactoryUtil.createJSONDeserializer();
            jsonDeserializer.use(null, HashMap.class);
            jsonDeserializer.use("parameters", HashMap.class);
            HashMap requestBodyMap = (HashMap)jsonDeserializer.deserialize(requestBody);
            JSONRPCRequest jsonrpcRequest = new JSONRPCRequest();
            Number id = (Number)requestBodyMap.get("id");
            if (id != null) {
                jsonrpcRequest._id = id.intValue();
            }
            jsonrpcRequest._jsonrpc = (String)requestBodyMap.get("jsonrpc");
            jsonrpcRequest._method = (String)requestBodyMap.get("method");
            jsonrpcRequest._parameters = (Map)requestBodyMap.get("params");
            if (Validator.isNull((String)jsonrpcRequest._method)) {
                return null;
            }
            return jsonrpcRequest;
        }
        catch (Exception e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to parse JSON RPC request", (Throwable)e);
            }
            return null;
        }
    }

    public Integer getId() {
        return this._id;
    }

    public String getJsonrpc() {
        return this._jsonrpc;
    }

    public String getMethod() {
        return this._method;
    }

    public String getParameter(String name) {
        Object value = this._parameters.get(name);
        if (value != null) {
            return String.valueOf(value);
        }
        return null;
    }

    public Set<String> getParameterNames() {
        return this._parameters.keySet();
    }

    public void setId(Integer id) {
        this._id = id;
    }

    public void setJsonrpc(String jsonrpc) {
        this._jsonrpc = jsonrpc;
    }

    public void setMethod(String method) {
        this._method = method;
    }

    public void setParameters(Map<String, ?> parameters) {
        this._parameters = parameters;
    }
}

