/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.exportimport.kernel.staging.LayoutStagingUtil;
import com.liferay.exportimport.kernel.staging.MergeLayoutPrototypesThreadLocal;
import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutRevision;
import com.liferay.portal.kernel.model.LayoutStagingHandler;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletPreferencesIds;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.ExceptionRetryAcceptor;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.settings.PortletInstanceSettingsLocator;
import com.liferay.portal.kernel.settings.PortletPreferencesSettings;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.spring.aop.Property;
import com.liferay.portal.kernel.spring.aop.Retry;
import com.liferay.portal.kernel.spring.aop.Skip;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.service.base.PortletPreferencesLocalServiceBaseImpl;
import com.liferay.portlet.exportimport.staging.ProxiedLayoutsThreadLocal;
import com.liferay.portlet.exportimport.staging.StagingAdvicesThreadLocal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;

public class PortletPreferencesLocalServiceImpl
extends PortletPreferencesLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(PortletPreferencesLocalServiceImpl.class);

    public com.liferay.portal.kernel.model.PortletPreferences addPortletPreferences(long companyId, long ownerId, int ownerType, long plid, String portletId, Portlet portlet, String defaultPreferences) {
        com.liferay.portal.kernel.model.PortletPreferences portletPreferences;
        block5: {
            long portletPreferencesId = this.counterLocalService.increment();
            portletPreferences = this.portletPreferencesPersistence.create(portletPreferencesId);
            portletPreferences.setOwnerId(ownerId);
            portletPreferences.setOwnerType(ownerType);
            portletPreferences.setPlid(plid);
            portletPreferences.setPortletId(portletId);
            if (Validator.isNull((String)defaultPreferences)) {
                defaultPreferences = portlet == null ? "<portlet-preferences />" : portlet.getDefaultPreferences();
            }
            portletPreferences.setPreferences(defaultPreferences);
            if (_log.isDebugEnabled()) {
                StringBundler sb = new StringBundler(13);
                sb.append("Add {companyId=");
                sb.append(companyId);
                sb.append(", ownerId=");
                sb.append(ownerId);
                sb.append(", ownerType=");
                sb.append(ownerType);
                sb.append(", plid=");
                sb.append(plid);
                sb.append(", portletId=");
                sb.append(portletId);
                sb.append(", defaultPreferences=");
                sb.append(defaultPreferences);
                sb.append("}");
                _log.debug((Object)sb.toString());
            }
            try {
                this.portletPreferencesPersistence.update((BaseModel)portletPreferences);
            }
            catch (SystemException se) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Add failed, fetch {ownerId=" + ownerId + ", ownerType=" + ownerType + ", plid=" + plid + ", portletId=" + portletId + "}"));
                }
                if ((portletPreferences = this.portletPreferencesPersistence.fetchByO_O_P_P(ownerId, ownerType, plid, portletId, false)) != null) break block5;
                throw se;
            }
        }
        return portletPreferences;
    }

    public void deletePortletPreferences(long ownerId, int ownerType, long plid) {
        this.portletPreferencesPersistence.removeByO_O_P(ownerId, ownerType, plid);
    }

    public void deletePortletPreferences(long ownerId, int ownerType, long plid, String portletId) throws PortalException {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Delete {ownerId=" + ownerId + ", ownerType=" + ownerType + ", plid=" + plid + ", portletId=" + portletId + "}"));
        }
        this.portletPreferencesPersistence.removeByO_O_P_P(ownerId, ownerType, plid, portletId);
    }

    public void deletePortletPreferencesByPlid(long plid) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Delete {plid=" + plid + "}"));
        }
        this.portletPreferencesPersistence.removeByPlid(plid);
    }

    public com.liferay.portal.kernel.model.PortletPreferences fetchPortletPreferences(long ownerId, int ownerType, long plid, String portletId) {
        return this.portletPreferencesPersistence.fetchByO_O_P_P(ownerId, ownerType, this._swapPlidForPortletPreferences(plid), portletId);
    }

    public PortletPreferences fetchPreferences(long companyId, long ownerId, int ownerType, long plid, String portletId) {
        com.liferay.portal.kernel.model.PortletPreferences portletPreferences = this.portletPreferencesPersistence.fetchByO_O_P_P(ownerId, ownerType, plid, portletId);
        if (portletPreferences == null) {
            return null;
        }
        return PortletPreferencesFactoryUtil.fromXML((long)companyId, (long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)portletPreferences.getPreferences());
    }

    public PortletPreferences fetchPreferences(PortletPreferencesIds portletPreferencesIds) {
        return this.fetchPreferences(portletPreferencesIds.getCompanyId(), portletPreferencesIds.getOwnerId(), portletPreferencesIds.getOwnerType(), portletPreferencesIds.getPlid(), portletPreferencesIds.getPortletId());
    }

    @Skip
    public PortletPreferences getDefaultPreferences(long companyId, String portletId) {
        Portlet portlet = this.portletLocalService.getPortletById(companyId, portletId);
        return PortletPreferencesFactoryUtil.fromDefaultXML((String)portlet.getDefaultPreferences());
    }

    public Settings getPortletInstanceSettings(long companyId, long groupId, String portletId, PortletInstanceSettingsLocator portletInstanceSettingsLocator, Settings portalPreferencesSettings) {
        String defaultPreferences = "<portlet-preferences />";
        Portlet portlet = this.portletLocalService.fetchPortletById(companyId, PortletIdCodec.decodePortletName((String)portletId));
        if (portlet != null) {
            defaultPreferences = portlet.getDefaultPreferences();
        }
        PortletPreferencesSettings companyPortletPreferencesSettings = new PortletPreferencesSettings(this._getStrictPreferences(companyId, companyId, 1, 0L, portletId, defaultPreferences), portalPreferencesSettings);
        PortletPreferencesSettings groupPortletPreferencesSettings = new PortletPreferencesSettings(this._getStrictPreferences(companyId, groupId, 2, 0L, portletId, defaultPreferences), (Settings)companyPortletPreferencesSettings);
        long ownerId = portletInstanceSettingsLocator.getOwnerId();
        int ownerType = 3;
        long userId = PortletIdCodec.decodeUserId((String)portletId);
        if (userId > 0L) {
            ownerId = userId;
            ownerType = 4;
        }
        long plid = this._swapPlidForPortletPreferences(portletInstanceSettingsLocator.getPlid());
        return new PortletPreferencesSettings(this._getStrictPreferences(companyId, ownerId, ownerType, plid, portletId, defaultPreferences), (Settings)groupPortletPreferencesSettings);
    }

    public List<com.liferay.portal.kernel.model.PortletPreferences> getPortletPreferences() {
        return this.portletPreferencesPersistence.findAll();
    }

    public List<com.liferay.portal.kernel.model.PortletPreferences> getPortletPreferences(int ownerType, long plid, String portletId) {
        return this.portletPreferencesPersistence.findByO_P_P(ownerType, this._swapPlidForPortletPreferences(plid), portletId);
    }

    public List<com.liferay.portal.kernel.model.PortletPreferences> getPortletPreferences(long ownerId, int ownerType, long plid) {
        return this.portletPreferencesPersistence.findByO_O_P(ownerId, ownerType, this._swapPlidForPortletPreferences(plid));
    }

    public com.liferay.portal.kernel.model.PortletPreferences getPortletPreferences(long ownerId, int ownerType, long plid, String portletId) throws PortalException {
        return this.portletPreferencesPersistence.findByO_O_P_P(ownerId, ownerType, this._swapPlidForPortletPreferences(plid), portletId);
    }

    public List<com.liferay.portal.kernel.model.PortletPreferences> getPortletPreferences(long companyId, long ownerId, int ownerType, String portletId) throws PortalException {
        return this.portletPreferencesPersistence.findByC_O_O_LikeP(companyId, ownerId, ownerType, portletId);
    }

    public List<com.liferay.portal.kernel.model.PortletPreferences> getPortletPreferences(long companyId, long groupId, long ownerId, int ownerType, String portletId, boolean privateLayout) {
        return this.portletPreferencesFinder.findByC_G_O_O_P_P(companyId, groupId, ownerId, ownerType, portletId, privateLayout);
    }

    public List<com.liferay.portal.kernel.model.PortletPreferences> getPortletPreferences(long plid, String portletId) {
        return this.portletPreferencesPersistence.findByP_P(this._swapPlidForPortletPreferences(plid), portletId);
    }

    public List<com.liferay.portal.kernel.model.PortletPreferences> getPortletPreferencesByPlid(long plid) {
        return this.portletPreferencesPersistence.findByPlid(plid);
    }

    public long getPortletPreferencesCount(int ownerType, long plid, String portletId) {
        return this.portletPreferencesPersistence.countByO_P_P(ownerType, this._swapPlidForPortletPreferences(plid), portletId);
    }

    public long getPortletPreferencesCount(int ownerType, String portletId) {
        return this.portletPreferencesPersistence.countByO_P(ownerType, portletId);
    }

    public long getPortletPreferencesCount(long ownerId, int ownerType, long plid, Portlet portlet, boolean excludeDefaultPreferences) {
        plid = this._swapPlidForPortletPreferences(plid);
        String portletId = portlet.getPortletId();
        if (plid == -1L) {
            portletId = portlet.getRootPortletId();
        }
        return this.portletPreferencesFinder.countByO_O_P_P_P(ownerId, ownerType, plid, portletId, excludeDefaultPreferences);
    }

    public long getPortletPreferencesCount(long ownerId, int ownerType, String portletId, boolean excludeDefaultPreferences) {
        return this.portletPreferencesFinder.countByO_O_P(ownerId, ownerType, portletId, excludeDefaultPreferences);
    }

    @Retry(acceptor=ExceptionRetryAcceptor.class, properties={@Property(name="EXCEPTION_NAME", value="org.springframework.dao.DataIntegrityViolationException")})
    public PortletPreferences getPreferences(long companyId, long ownerId, int ownerType, long plid, String portletId) {
        return this.getPreferences(companyId, ownerId, ownerType, plid, portletId, null);
    }

    @Retry(acceptor=ExceptionRetryAcceptor.class, properties={@Property(name="EXCEPTION_NAME", value="org.springframework.dao.DataIntegrityViolationException")})
    public PortletPreferences getPreferences(long companyId, long ownerId, int ownerType, long plid, String portletId, String defaultPreferences) {
        com.liferay.portal.kernel.model.PortletPreferences portletPreferences = this.portletPreferencesPersistence.fetchByO_O_P_P(ownerId, ownerType, plid = this._swapPlidForPreferences(plid), portletId);
        if (portletPreferences == null) {
            Portlet portlet = this.portletLocalService.fetchPortletById(companyId, portletId);
            portletPreferences = this.portletPreferencesLocalService.addPortletPreferences(companyId, ownerId, ownerType, plid, portletId, portlet, defaultPreferences);
        }
        return PortletPreferencesFactoryUtil.fromXML((long)companyId, (long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)portletPreferences.getPreferences());
    }

    @Retry(acceptor=ExceptionRetryAcceptor.class, properties={@Property(name="EXCEPTION_NAME", value="org.springframework.dao.DataIntegrityViolationException")})
    public PortletPreferences getPreferences(PortletPreferencesIds portletPreferencesIds) {
        return this.getPreferences(portletPreferencesIds.getCompanyId(), portletPreferencesIds.getOwnerId(), portletPreferencesIds.getOwnerType(), portletPreferencesIds.getPlid(), portletPreferencesIds.getPortletId());
    }

    public Map<String, PortletPreferences> getStrictPreferences(Layout layout, List<Portlet> portlets) {
        long plid = layout.getPlid();
        plid = this._swapPlidForPreferences(plid);
        HashMap<String, PortletPreferences> portletPreferencesMap = new HashMap<String, PortletPreferences>();
        List portletPreferencesList = this.portletPreferencesPersistence.findByO_O_P(0L, 3, plid);
        for (Portlet portlet : portlets) {
            String preferences;
            String portletId;
            int ownerType;
            long ownerId;
            block3: {
                block2: {
                    ownerId = 0L;
                    ownerType = 3;
                    portletId = portlet.getPortletId();
                    preferences = portlet.getDefaultPreferences();
                    if (!PortletIdCodec.hasUserId((String)portletId)) break block2;
                    ownerId = PortletIdCodec.decodeUserId((String)portletId);
                    com.liferay.portal.kernel.model.PortletPreferences portletsPreferences = this.portletPreferencesPersistence.fetchByO_O_P_P(ownerId, ownerType = 4, plid, portletId);
                    if (portletsPreferences == null) break block3;
                    preferences = portletsPreferences.getPreferences();
                    break block3;
                }
                for (com.liferay.portal.kernel.model.PortletPreferences portletPreferences : portletPreferencesList) {
                    if (!portletId.equals(portletPreferences.getPortletId())) continue;
                    preferences = portletPreferences.getPreferences();
                    break;
                }
            }
            portletPreferencesMap.put(portletId, PortletPreferencesFactoryUtil.strictFromXML((long)layout.getCompanyId(), (long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)preferences));
        }
        return portletPreferencesMap;
    }

    public PortletPreferences getStrictPreferences(long companyId, long ownerId, int ownerType, long plid, String portletId) {
        com.liferay.portal.kernel.model.PortletPreferences portletPreferences = this.portletPreferencesPersistence.fetchByO_O_P_P(ownerId, ownerType, plid = this._swapPlidForPreferences(plid), portletId);
        if (portletPreferences == null) {
            String defaultPreferences = "<portlet-preferences />";
            Portlet portlet = this.portletLocalService.fetchPortletById(companyId, portletId);
            if (portlet != null) {
                defaultPreferences = portlet.getDefaultPreferences();
            }
            return PortletPreferencesFactoryUtil.strictFromXML((long)companyId, (long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)defaultPreferences);
        }
        return PortletPreferencesFactoryUtil.fromXML((long)companyId, (long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)portletPreferences.getPreferences());
    }

    public PortletPreferences getStrictPreferences(PortletPreferencesIds portletPreferencesIds) {
        return this.getStrictPreferences(portletPreferencesIds.getCompanyId(), portletPreferencesIds.getOwnerId(), portletPreferencesIds.getOwnerType(), portletPreferencesIds.getPlid(), portletPreferencesIds.getPortletId());
    }

    public com.liferay.portal.kernel.model.PortletPreferences updatePreferences(long ownerId, int ownerType, long plid, String portletId, PortletPreferences portletPreferences) {
        String xml = PortletPreferencesFactoryUtil.toXML((PortletPreferences)portletPreferences);
        return this.updatePreferences(ownerId, ownerType, plid, portletId, xml);
    }

    public com.liferay.portal.kernel.model.PortletPreferences updatePreferences(long ownerId, int ownerType, long plid, String portletId, String xml) {
        com.liferay.portal.kernel.model.PortletPreferences portletPreferences;
        plid = this._swapPlidForUpdatePreferences(plid);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Update {ownerId=" + ownerId + ", ownerType=" + ownerType + ", plid=" + plid + ", portletId=" + portletId + ", xml=" + xml + "}"));
        }
        if ((portletPreferences = this.portletPreferencesPersistence.fetchByO_O_P_P(ownerId, ownerType, plid, portletId)) == null) {
            long portletPreferencesId = this.counterLocalService.increment();
            portletPreferences = this.portletPreferencesPersistence.create(portletPreferencesId);
            portletPreferences.setOwnerId(ownerId);
            portletPreferences.setOwnerType(ownerType);
            portletPreferences.setPlid(plid);
            portletPreferences.setPortletId(portletId);
        }
        portletPreferences.setPreferences(xml);
        this.portletPreferencesPersistence.update((BaseModel)portletPreferences);
        return portletPreferences;
    }

    private LayoutRevision _getLayoutRevision(long plid) {
        if (plid <= 0L) {
            return null;
        }
        LayoutRevision layoutRevision = this.layoutRevisionPersistence.fetchByPrimaryKey(plid);
        if (layoutRevision != null) {
            return layoutRevision;
        }
        Layout layout = this.layoutPersistence.fetchByPrimaryKey(plid);
        if (layout == null) {
            return null;
        }
        if (LayoutStagingUtil.isBranchingLayout((Layout)layout)) {
            LayoutStagingHandler layoutStagingHandler = new LayoutStagingHandler(layout);
            return layoutStagingHandler.getLayoutRevision();
        }
        return null;
    }

    private PortletPreferences _getStrictPreferences(long companyId, long ownerId, int ownerType, long plid, String portletId, String defaultPreferences) {
        com.liferay.portal.kernel.model.PortletPreferences portletPreferences = this.portletPreferencesPersistence.fetchByO_O_P_P(ownerId, ownerType, plid, portletId);
        if (portletPreferences == null) {
            return PortletPreferencesFactoryUtil.strictFromXML((long)companyId, (long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)defaultPreferences);
        }
        return PortletPreferencesFactoryUtil.fromXML((long)companyId, (long)ownerId, (int)ownerType, (long)plid, (String)portletId, (String)portletPreferences.getPreferences());
    }

    private long _swapPlidForPortletPreferences(long plid) {
        if (!StagingAdvicesThreadLocal.isEnabled()) {
            return plid;
        }
        LayoutRevision layoutRevision = this._getLayoutRevision(plid);
        if (layoutRevision == null) {
            return plid;
        }
        return layoutRevision.getLayoutRevisionId();
    }

    private long _swapPlidForPreferences(long plid) {
        if (!StagingAdvicesThreadLocal.isEnabled()) {
            return plid;
        }
        LayoutRevision layoutRevision = this._getLayoutRevision(plid);
        if (layoutRevision == null) {
            return plid;
        }
        User user = this.userPersistence.fetchByPrimaryKey(PrincipalThreadLocal.getUserId());
        if (user == null || user.isDefaultUser()) {
            return layoutRevision.getLayoutRevisionId();
        }
        try {
            return StagingUtil.getRecentLayoutRevisionId((User)user, (long)layoutRevision.getLayoutSetBranchId(), (long)layoutRevision.getPlid());
        }
        catch (PortalException pe) {
            return (Long)ReflectionUtil.throwException((Throwable)pe);
        }
    }

    private long _swapPlidForUpdatePreferences(long plid) {
        if (!StagingAdvicesThreadLocal.isEnabled()) {
            return plid;
        }
        LayoutRevision layoutRevision = this._getLayoutRevision(plid);
        if (layoutRevision == null) {
            return plid;
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            return plid;
        }
        boolean exporting = ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"exporting");
        if (exporting) {
            return plid;
        }
        if (!MergeLayoutPrototypesThreadLocal.isInProgress()) {
            serviceContext.setWorkflowAction(2);
        }
        try {
            layoutRevision = this.layoutRevisionLocalService.updateLayoutRevision(serviceContext.getUserId(), layoutRevision.getLayoutRevisionId(), layoutRevision.getLayoutBranchId(), layoutRevision.getName(), layoutRevision.getTitle(), layoutRevision.getDescription(), layoutRevision.getKeywords(), layoutRevision.getRobots(), layoutRevision.getTypeSettings(), layoutRevision.getIconImage(), layoutRevision.getIconImageId(), layoutRevision.getThemeId(), layoutRevision.getColorSchemeId(), layoutRevision.getCss(), serviceContext);
        }
        catch (PortalException pe) {
            ReflectionUtil.throwException((Throwable)pe);
        }
        plid = layoutRevision.getLayoutRevisionId();
        ProxiedLayoutsThreadLocal.clearProxiedLayouts();
        return plid;
    }
}

