/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.ORMException;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.ResourceBlocksNotSupportedException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.PermissionedModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.ResourceAction;
import com.liferay.portal.kernel.model.ResourceBlock;
import com.liferay.portal.kernel.model.ResourceBlockPermissionsContainer;
import com.liferay.portal.kernel.model.ResourceTypePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.security.permission.ResourceBlockIdsBag;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.PersistedModelLocalServiceRegistryUtil;
import com.liferay.portal.kernel.spring.aop.Skip;
import com.liferay.portal.kernel.transaction.Isolation;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.model.impl.ResourceBlockImpl;
import com.liferay.portal.security.permission.PermissionCacheUtil;
import com.liferay.portal.service.base.ResourceBlockLocalServiceBaseImpl;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.sql.DataSource;

public class ResourceBlockLocalServiceImpl
extends ResourceBlockLocalServiceBaseImpl {
    private static final String _DELETE_RESOURCE_BLOCK = ResourceBlockLocalServiceImpl.class.getName() + ".deleteResourceBlock";
    private static final String _RELEASE_RESOURCE_BLOCK = ResourceBlockLocalServiceImpl.class.getName() + ".releaseResourceBlock";
    private static final String _RETAIN_RESOURCE_BLOCK = ResourceBlockLocalServiceImpl.class.getName() + ".retainResourceBlock";
    private static final Log _log = LogFactoryUtil.getLog(ResourceBlockLocalServiceImpl.class);

    public void addCompanyScopePermission(long companyId, String name, long roleId, String actionId) throws PortalException {
        this.updateCompanyScopePermissions(companyId, name, roleId, this.getActionId(name, actionId), 1);
    }

    public void addCompanyScopePermissions(long companyId, String name, long roleId, long actionIdsLong) {
        this.updateCompanyScopePermissions(companyId, name, roleId, actionIdsLong, 1);
    }

    public void addGroupScopePermission(long companyId, long groupId, String name, long roleId, String actionId) throws PortalException {
        this.updateGroupScopePermissions(companyId, groupId, name, roleId, this.getActionId(name, actionId), 1);
    }

    public void addGroupScopePermissions(long companyId, long groupId, String name, long roleId, long actionIdsLong) {
        this.updateGroupScopePermissions(companyId, groupId, name, roleId, actionIdsLong, 1);
    }

    public void addIndividualScopePermission(long companyId, long groupId, String name, long primKey, long roleId, String actionId) throws PortalException {
        PermissionedModel permissionedModel = this.getPermissionedModel(name, primKey);
        this.updateIndividualScopePermissions(companyId, groupId, name, permissionedModel, roleId, this.getActionId(name, actionId), 1);
    }

    public void addIndividualScopePermission(long companyId, long groupId, String name, PermissionedModel permissionedModel, long roleId, String actionId) throws PortalException {
        this.updateIndividualScopePermissions(companyId, groupId, name, permissionedModel, roleId, this.getActionId(name, actionId), 1);
    }

    public void addIndividualScopePermissions(long companyId, long groupId, String name, long primKey, long roleId, long actionIdsLong) throws PortalException {
        PermissionedModel permissionedModel = this.getPermissionedModel(name, primKey);
        this.updateIndividualScopePermissions(companyId, groupId, name, permissionedModel, roleId, actionIdsLong, 1);
    }

    public void addIndividualScopePermissions(long companyId, long groupId, String name, PermissionedModel permissionedModel, long roleId, long actionIdsLong) {
        this.updateIndividualScopePermissions(companyId, groupId, name, permissionedModel, roleId, actionIdsLong, 1);
    }

    public ResourceBlock addResourceBlock(long companyId, long groupId, String name, String permissionsHash, ResourceBlockPermissionsContainer resourceBlockPermissionsContainer) {
        long resourceBlockId = this.counterLocalService.increment(ResourceBlock.class.getName());
        ResourceBlock resourceBlock = this.resourceBlockPersistence.create(resourceBlockId);
        resourceBlock.setCompanyId(companyId);
        resourceBlock.setGroupId(groupId);
        resourceBlock.setName(name);
        resourceBlock.setPermissionsHash(permissionsHash);
        resourceBlock.setReferenceCount(1L);
        this.updateResourceBlock(resourceBlock);
        this.resourceBlockPermissionLocalService.addResourceBlockPermissions(resourceBlockId, resourceBlockPermissionsContainer);
        return resourceBlock;
    }

    @Override
    public ResourceBlock deleteResourceBlock(long resourceBlockId) throws PortalException {
        ResourceBlock resourceBlock = this.resourceBlockPersistence.findByPrimaryKey(resourceBlockId);
        return this.deleteResourceBlock(resourceBlock);
    }

    @Override
    public ResourceBlock deleteResourceBlock(ResourceBlock resourceBlock) {
        this.resourceBlockPermissionLocalService.deleteResourceBlockPermissions(resourceBlock.getPrimaryKey());
        this.resourceBlockPersistence.remove((BaseModel)resourceBlock);
        return resourceBlock;
    }

    public long getActionId(String name, String actionId) throws PortalException {
        ResourceAction resourcAction = this.resourceActionLocalService.getResourceAction(name, actionId);
        return resourcAction.getBitwiseValue();
    }

    public long getActionIds(String name, List<String> actionIds) throws PortalException {
        long actionIdsLong = 0L;
        for (String actionId : actionIds) {
            ResourceAction resourceAction = this.resourceActionLocalService.getResourceAction(name, actionId);
            actionIdsLong |= resourceAction.getBitwiseValue();
        }
        return actionIdsLong;
    }

    public List<String> getActionIds(String name, long actionIdsLong) {
        List resourceActions = this.resourceActionLocalService.getResourceActions(name);
        ArrayList<String> actionIds = new ArrayList<String>();
        for (ResourceAction resourceAction : resourceActions) {
            if ((actionIdsLong & resourceAction.getBitwiseValue()) != resourceAction.getBitwiseValue()) continue;
            actionIds.add(resourceAction.getActionId());
        }
        return actionIds;
    }

    public List<String> getCompanyScopePermissions(ResourceBlock resourceBlock, long roleId) {
        long actionIdsLong = this.resourceTypePermissionLocalService.getCompanyScopeActionIds(resourceBlock.getCompanyId(), resourceBlock.getName(), roleId);
        return this.getActionIds(resourceBlock.getName(), actionIdsLong);
    }

    public List<String> getGroupScopePermissions(ResourceBlock resourceBlock, long roleId) {
        long actionIdsLong = this.resourceTypePermissionLocalService.getGroupScopeActionIds(resourceBlock.getCompanyId(), resourceBlock.getGroupId(), resourceBlock.getName(), roleId);
        return this.getActionIds(resourceBlock.getName(), actionIdsLong);
    }

    public PermissionedModel getPermissionedModel(String name, long primKey) throws PortalException {
        PersistedModelLocalService persistedModelLocalService = PersistedModelLocalServiceRegistryUtil.getPersistedModelLocalService((String)name);
        if (persistedModelLocalService == null) {
            throw new ResourceBlocksNotSupportedException();
        }
        PersistedModel persistedModel = persistedModelLocalService.getPersistedModel((Serializable)Long.valueOf(primKey));
        try {
            return (PermissionedModel)persistedModel;
        }
        catch (ClassCastException cce) {
            throw new ResourceBlocksNotSupportedException((Throwable)cce);
        }
    }

    public List<String> getPermissions(ResourceBlock resourceBlock, long roleId) {
        ResourceBlockPermissionsContainer resourceBlockPermissionsContainer = this.resourceBlockPermissionLocalService.getResourceBlockPermissionsContainer(resourceBlock.getPrimaryKey());
        long actionIdsLong = resourceBlockPermissionsContainer.getActionIds(roleId);
        return this.getActionIds(resourceBlock.getName(), actionIdsLong);
    }

    public ResourceBlock getResourceBlock(String name, long primKey) throws PortalException {
        PermissionedModel permissionedModel = this.getPermissionedModel(name, primKey);
        return this.getResourceBlock(permissionedModel.getResourceBlockId());
    }

    public List<Long> getResourceBlockIds(ResourceBlockIdsBag resourceBlockIdsBag, String name, String actionId) throws PortalException {
        long actionIdsLong = this.getActionId(name, actionId);
        return resourceBlockIdsBag.getResourceBlockIds(actionIdsLong);
    }

    public ResourceBlockIdsBag getResourceBlockIdsBag(long companyId, long groupId, String name, long[] roleIds) {
        return this.resourceBlockFinder.findByC_G_N_R(companyId, groupId, name, roleIds);
    }

    public List<Role> getRoles(String name, long primKey, String actionId) throws PortalException {
        long actionIdLong = this.getActionId(name, actionId);
        ResourceBlock resourceBlock = this.getResourceBlock(name, primKey);
        ResourceBlockPermissionsContainer resourceBlockPermissionsContainer = this.resourceBlockPermissionLocalService.getResourceBlockPermissionsContainer(resourceBlock.getResourceBlockId());
        Set roleIds = resourceBlockPermissionsContainer.getRoleIds();
        ArrayList<Role> roles = new ArrayList<Role>(roleIds.size());
        Iterator iterator = roleIds.iterator();
        while (iterator.hasNext()) {
            long roleId = (Long)iterator.next();
            if (!resourceBlockPermissionsContainer.hasPermission(roleId, actionIdLong)) continue;
            roles.add(this.roleLocalService.getRole(roleId));
        }
        return roles;
    }

    public boolean hasPermission(String name, long primKey, String actionId, ResourceBlockIdsBag resourceBlockIdsBag) throws PortalException {
        PermissionedModel permissionedModel = this.getPermissionedModel(name, primKey);
        return this.hasPermission(name, permissionedModel, actionId, resourceBlockIdsBag);
    }

    public boolean hasPermission(String name, PermissionedModel permissionedModel, String actionId, ResourceBlockIdsBag resourceBlockIdsBag) throws PortalException {
        long actionIdsLong = this.getActionId(name, actionId);
        return resourceBlockIdsBag.hasResourceBlockId(permissionedModel.getResourceBlockId(), actionIdsLong);
    }

    @Skip
    public boolean isSupported(String name) {
        return PersistedModelLocalServiceRegistryUtil.isPermissionedModelLocalService((String)name);
    }

    @Transactional(isolation=Isolation.READ_COMMITTED, propagation=Propagation.REQUIRES_NEW)
    public void releasePermissionedModelResourceBlock(PermissionedModel permissionedModel) {
        this.releaseResourceBlock(permissionedModel.getResourceBlockId());
    }

    public void releasePermissionedModelResourceBlock(String name, long primKey) throws PortalException {
        PermissionedModel permissionedModel = this.getPermissionedModel(name, primKey);
        this.releasePermissionedModelResourceBlock(permissionedModel);
    }

    @Transactional(isolation=Isolation.READ_COMMITTED, propagation=Propagation.REQUIRES_NEW)
    public void releaseResourceBlock(long resourceBlockId) {
        Session session = this.resourceBlockPersistence.openSession();
        while (true) {
            try {
                ResourceBlock resourceBlock;
                String sql = CustomSQLUtil.get((String)_RELEASE_RESOURCE_BLOCK);
                SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)sqlQuery);
                qPos.add(resourceBlockId);
                if (sqlQuery.executeUpdate() > 0 && (resourceBlock = (ResourceBlock)session.get(ResourceBlockImpl.class, (Serializable)Long.valueOf(resourceBlockId))).getReferenceCount() == 0L) {
                    sql = CustomSQLUtil.get((String)_DELETE_RESOURCE_BLOCK);
                    sqlQuery = session.createSynchronizedSQLQuery(sql);
                    qPos = QueryPos.getInstance((Query)sqlQuery);
                    qPos.add(resourceBlockId);
                    if (sqlQuery.executeUpdate() > 0) {
                        this.resourceBlockPermissionLocalService.deleteResourceBlockPermissions(resourceBlockId);
                    }
                    PermissionCacheUtil.clearResourceBlockCache(resourceBlock.getCompanyId(), resourceBlock.getGroupId(), resourceBlock.getName());
                }
                this.resourceBlockPersistence.closeSession(session);
            }
            catch (ORMException orme) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to decrement reference count for resource block " + resourceBlockId + ". Retrying."));
                continue;
            }
            break;
        }
    }

    @Transactional(isolation=Isolation.READ_COMMITTED, propagation=Propagation.REQUIRES_NEW)
    public void releaseResourceBlock(ResourceBlock resourceBlock) {
        this.releaseResourceBlock(resourceBlock.getResourceBlockId());
    }

    public void removeAllGroupScopePermissions(long companyId, String name, long roleId, long actionIdsLong) {
        List resourceTypePermissions = this.resourceTypePermissionLocalService.getGroupScopeResourceTypePermissions(companyId, name, roleId);
        for (ResourceTypePermission resourceTypePermission : resourceTypePermissions) {
            this.removeGroupScopePermissions(companyId, resourceTypePermission.getGroupId(), name, roleId, actionIdsLong);
        }
    }

    public void removeAllGroupScopePermissions(long companyId, String name, long roleId, String actionId) throws PortalException {
        this.removeAllGroupScopePermissions(companyId, name, roleId, this.getActionId(name, actionId));
    }

    public void removeCompanyScopePermission(long companyId, String name, long roleId, String actionId) throws PortalException {
        this.updateCompanyScopePermissions(companyId, name, roleId, this.getActionId(name, actionId), 2);
    }

    public void removeCompanyScopePermissions(long companyId, String name, long roleId, long actionIdsLong) {
        this.updateCompanyScopePermissions(companyId, name, roleId, actionIdsLong, 2);
    }

    public void removeGroupScopePermission(long companyId, long groupId, String name, long roleId, String actionId) throws PortalException {
        this.updateGroupScopePermissions(companyId, groupId, name, roleId, this.getActionId(name, actionId), 2);
    }

    public void removeGroupScopePermissions(long companyId, long groupId, String name, long roleId, long actionIdsLong) {
        this.updateGroupScopePermissions(companyId, groupId, name, roleId, actionIdsLong, 2);
    }

    public void removeIndividualScopePermission(long companyId, long groupId, String name, long primKey, long roleId, String actionId) throws PortalException {
        PermissionedModel permissionedModel = this.getPermissionedModel(name, primKey);
        this.updateIndividualScopePermissions(companyId, groupId, name, permissionedModel, roleId, this.getActionId(name, actionId), 2);
    }

    public void removeIndividualScopePermission(long companyId, long groupId, String name, PermissionedModel permissionedModel, long roleId, String actionId) throws PortalException {
        this.updateIndividualScopePermissions(companyId, groupId, name, permissionedModel, roleId, this.getActionId(name, actionId), 2);
    }

    public void removeIndividualScopePermissions(long companyId, long groupId, String name, long primKey, long roleId, long actionIdsLong) throws PortalException {
        PermissionedModel permissionedModel = this.getPermissionedModel(name, primKey);
        this.updateIndividualScopePermissions(companyId, groupId, name, permissionedModel, roleId, actionIdsLong, 2);
    }

    public void removeIndividualScopePermissions(long companyId, long groupId, String name, PermissionedModel permissionedModel, long roleId, long actionIdsLong) {
        this.updateIndividualScopePermissions(companyId, groupId, name, permissionedModel, roleId, actionIdsLong, 2);
    }

    public void setCompanyScopePermissions(long companyId, String name, long roleId, List<String> actionIds) throws PortalException {
        this.checkGuestSupportedPermission(companyId, name, roleId, actionIds);
        this.updateCompanyScopePermissions(companyId, name, roleId, this.getActionIds(name, actionIds), 3);
    }

    public void setCompanyScopePermissions(long companyId, String name, long roleId, long actionIdsLong) {
        this.updateCompanyScopePermissions(companyId, name, roleId, actionIdsLong, 3);
    }

    public void setGroupScopePermissions(long companyId, long groupId, String name, long roleId, List<String> actionIds) throws PortalException {
        this.checkGuestSupportedPermission(companyId, name, roleId, actionIds);
        this.updateGroupScopePermissions(companyId, groupId, name, roleId, this.getActionIds(name, actionIds), 3);
    }

    public void setGroupScopePermissions(long companyId, long groupId, String name, long roleId, long actionIdsLong) {
        this.updateGroupScopePermissions(companyId, groupId, name, roleId, actionIdsLong, 3);
    }

    public void setIndividualScopePermissions(long companyId, long groupId, String name, long primKey, long roleId, List<String> actionIds) throws PortalException {
        PermissionedModel permissionedModel = this.getPermissionedModel(name, primKey);
        this.checkGuestSupportedPermission(companyId, name, roleId, actionIds);
        this.updateIndividualScopePermissions(companyId, groupId, name, permissionedModel, roleId, this.getActionIds(name, actionIds), 3);
    }

    public void setIndividualScopePermissions(long companyId, long groupId, String name, long primKey, long roleId, long actionIdsLong) throws PortalException {
        PermissionedModel permissionedModel = this.getPermissionedModel(name, primKey);
        this.updateIndividualScopePermissions(companyId, groupId, name, permissionedModel, roleId, actionIdsLong, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIndividualScopePermissions(long companyId, long groupId, String name, long primKey, Map<Long, String[]> roleIdsToActionIds) throws PortalException {
        boolean flushResourceBlockEnabled = PermissionThreadLocal.isFlushResourceBlockEnabled((long)companyId, (long)groupId, (String)name);
        PermissionThreadLocal.setFlushResourceBlockEnabled((long)companyId, (long)groupId, (String)name, (boolean)false);
        try {
            PermissionedModel permissionedModel = this.getPermissionedModel(name, primKey);
            for (Map.Entry<Long, String[]> entry : roleIdsToActionIds.entrySet()) {
                long roleId = entry.getKey();
                List actionIds = ListUtil.fromArray((Object[])entry.getValue());
                this.checkGuestSupportedPermission(companyId, name, roleId, actionIds);
                this.updateIndividualScopePermissions(companyId, groupId, name, permissionedModel, roleId, this.getActionIds(name, actionIds), 3);
            }
        }
        finally {
            PermissionThreadLocal.setFlushResourceBlockEnabled((long)companyId, (long)groupId, (String)name, (boolean)flushResourceBlockEnabled);
            PermissionCacheUtil.clearResourceBlockCache(companyId, groupId, name);
            PermissionCacheUtil.clearResourcePermissionCache(4, name, String.valueOf(primKey));
        }
    }

    public void setIndividualScopePermissions(long companyId, long groupId, String name, PermissionedModel permissionedModel, long roleId, List<String> actionIds) throws PortalException {
        this.checkGuestSupportedPermission(companyId, name, roleId, actionIds);
        this.updateIndividualScopePermissions(companyId, groupId, name, permissionedModel, roleId, this.getActionIds(name, actionIds), 3);
    }

    public void setIndividualScopePermissions(long companyId, long groupId, String name, PermissionedModel permissionedModel, long roleId, long actionIdsLong) {
        this.updateIndividualScopePermissions(companyId, groupId, name, permissionedModel, roleId, actionIdsLong, 3);
    }

    public void updateCompanyScopePermissions(long companyId, String name, long roleId, long actionIdsLong, int operator) {
        this.resourceTypePermissionLocalService.updateCompanyScopeResourceTypePermissions(companyId, name, roleId, actionIdsLong, (long)operator);
        List resourceBlocks = this.resourceBlockPersistence.findByC_N(companyId, name);
        this.updatePermissions(resourceBlocks, roleId, actionIdsLong, operator);
        PermissionCacheUtil.clearResourceCache();
    }

    public void updateGroupScopePermissions(long companyId, long groupId, String name, long roleId, long actionIdsLong, int operator) {
        this.resourceTypePermissionLocalService.updateGroupScopeResourceTypePermissions(companyId, groupId, name, roleId, actionIdsLong, (long)operator);
        List resourceBlocks = this.resourceBlockPersistence.findByC_G_N(companyId, groupId, name);
        this.updatePermissions(resourceBlocks, roleId, actionIdsLong, operator);
        PermissionCacheUtil.clearResourceCache();
    }

    public void updateIndividualScopePermissions(long companyId, long groupId, String name, PermissionedModel permissionedModel, long roleId, long actionIdsLong, int operator) {
        ResourceBlock resourceBlock = this.resourceBlockPersistence.fetchByPrimaryKey(permissionedModel.getResourceBlockId());
        ResourceBlockPermissionsContainer resourceBlockPermissionsContainer = null;
        resourceBlockPermissionsContainer = resourceBlock == null ? this.resourceTypePermissionLocalService.getResourceBlockPermissionsContainer(companyId, groupId, name) : this.resourceBlockPermissionLocalService.getResourceBlockPermissionsContainer(resourceBlock.getPrimaryKey());
        long oldActionIdsLong = resourceBlockPermissionsContainer.getActionIds(roleId);
        if (operator == 1) {
            actionIdsLong |= oldActionIdsLong;
        } else if (operator == 2) {
            actionIdsLong = oldActionIdsLong & (actionIdsLong ^ 0xFFFFFFFFFFFFFFFFL);
        }
        if (resourceBlock != null) {
            if (oldActionIdsLong == actionIdsLong) {
                return;
            }
            this.resourceBlockLocalService.releaseResourceBlock(resourceBlock);
        }
        resourceBlockPermissionsContainer.setPermissions(roleId, actionIdsLong);
        String permissionsHash = resourceBlockPermissionsContainer.getPermissionsHash();
        this.resourceBlockLocalService.updateResourceBlockId(companyId, groupId, name, permissionedModel, permissionsHash, resourceBlockPermissionsContainer);
        PermissionCacheUtil.clearResourceBlockCache(companyId, groupId, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(isolation=Isolation.READ_COMMITTED, propagation=Propagation.REQUIRES_NEW)
    public ResourceBlock updateResourceBlockId(long companyId, long groupId, String name, final PermissionedModel permissionedModel, String permissionsHash, ResourceBlockPermissionsContainer resourceBlockPermissionsContainer) {
        ResourceBlock resourceBlock = null;
        while (true) {
            if ((resourceBlock = this.resourceBlockPersistence.fetchByC_G_N_P(companyId, groupId, name, permissionsHash, false)) == null) {
                try {
                    resourceBlock = this.addResourceBlock(companyId, groupId, name, permissionsHash, resourceBlockPermissionsContainer);
                    if (!PropsValues.SPRING_HIBERNATE_SESSION_DELEGATED) break;
                    this.resourceBlockPersistence.flush();
                    break;
                }
                catch (SystemException se) {
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)"Unable to add a new resource block. Retrying", (Throwable)se);
                    }
                    Session session = this.resourceBlockPersistence.getCurrentSession();
                    session.clear();
                    DB db = DBManagerUtil.getDB();
                    if (db.isSupportsQueryingAfterException()) continue;
                    DataSource dataSource = this.resourceBlockPersistence.getDataSource();
                    Connection connection = CurrentConnectionUtil.getConnection((DataSource)dataSource);
                    try {
                        connection.rollback();
                        connection.setAutoCommit(false);
                        continue;
                    }
                    catch (SQLException sqle) {
                        throw new SystemException((Throwable)sqle);
                    }
                }
            }
            Session session = this.resourceBlockPersistence.openSession();
            try {
                String sql = CustomSQLUtil.get((String)_RETAIN_RESOURCE_BLOCK);
                SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)sqlQuery);
                qPos.add(resourceBlock.getResourceBlockId());
                if (sqlQuery.executeUpdate() <= 0) continue;
                resourceBlock.setReferenceCount(resourceBlock.getReferenceCount() + 1L);
            }
            catch (ORMException orme) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to increment reference count for resource block " + resourceBlock.getResourceBlockId() + ". Retrying"));
                continue;
            }
            finally {
                session.evict((Object)resourceBlock);
                this.resourceBlockPersistence.closeSession(session);
                continue;
            }
            break;
        }
        permissionedModel.setResourceBlockId(resourceBlock.getResourceBlockId());
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                permissionedModel.persist();
                return null;
            }
        };
        TransactionCommitCallbackUtil.registerCallback((Callable)callable);
        return resourceBlock;
    }

    public void verifyResourceBlockId(long companyId, String name, long primKey) throws PortalException {
        PermissionedModel permissionedModel = this.getPermissionedModel(name, primKey);
        ResourceBlock resourceBlock = this.resourceBlockPersistence.fetchByPrimaryKey(permissionedModel.getResourceBlockId());
        if (resourceBlock != null) {
            return;
        }
        if (_log.isWarnEnabled()) {
            _log.warn((Object)("Resource block " + permissionedModel.getResourceBlockId() + " missing for " + name + "#" + primKey));
        }
        long groupId = 0L;
        long ownerId = 0L;
        if (permissionedModel instanceof GroupedModel) {
            GroupedModel groupedModel = (GroupedModel)permissionedModel;
            groupId = groupedModel.getGroupId();
            ownerId = groupedModel.getUserId();
        } else if (permissionedModel instanceof AuditedModel) {
            AuditedModel auditedModel = (AuditedModel)permissionedModel;
            ownerId = auditedModel.getUserId();
        }
        this.resourceLocalService.addResources(companyId, groupId, ownerId, name, primKey, false, true, true);
    }

    protected void checkGuestSupportedPermission(long companyId, String name, long roleId, List<String> actionIds) throws PortalException {
        if (!this.isGuestRole(companyId, roleId)) {
            return;
        }
        List unsupportedActionIds = ResourceActionsUtil.getResourceGuestUnsupportedActions((String)name, (String)name);
        for (String actionId : actionIds) {
            if (!unsupportedActionIds.contains(actionId)) continue;
            throw new PrincipalException(actionId + "is not supported by role " + roleId);
        }
    }

    protected boolean isGuestRole(long companyId, long roleId) throws PortalException {
        Role guestRole = this.roleLocalService.getRole(companyId, "Guest");
        return roleId == guestRole.getRoleId();
    }

    protected void updatePermissions(List<ResourceBlock> resourceBlocks, long roleId, long actionIdsLong, int operator) {
        for (ResourceBlock resourceBlock : resourceBlocks) {
            this.resourceBlockPermissionLocalService.updateResourceBlockPermission(resourceBlock.getPrimaryKey(), roleId, actionIdsLong, operator);
            this.updatePermissionsHash(resourceBlock);
        }
    }

    protected void updatePermissionsHash(ResourceBlock resourceBlock) {
        ResourceBlockPermissionsContainer resourceBlockPermissionsContainer = this.resourceBlockPermissionLocalService.getResourceBlockPermissionsContainer(resourceBlock.getPrimaryKey());
        String permissionsHash = resourceBlockPermissionsContainer.getPermissionsHash();
        ResourceBlock existingResourceBlock = this.resourceBlockPersistence.fetchByC_G_N_P(resourceBlock.getCompanyId(), resourceBlock.getGroupId(), resourceBlock.getName(), permissionsHash);
        if (existingResourceBlock == null) {
            resourceBlock.setPermissionsHash(permissionsHash);
            this.updateResourceBlock(resourceBlock);
            return;
        }
        if (existingResourceBlock.equals(resourceBlock)) {
            return;
        }
        try {
            this._updatePermissionedModels(resourceBlock.getName(), resourceBlock.getResourceBlockId(), existingResourceBlock.getResourceBlockId());
        }
        catch (Exception e) {
            _log.error((Object)("Unable to update resource block IDs for resource " + resourceBlock.getName()), (Throwable)e);
            return;
        }
        existingResourceBlock.setReferenceCount(existingResourceBlock.getReferenceCount() + resourceBlock.getReferenceCount());
        this.resourceBlockPersistence.update((BaseModel)existingResourceBlock);
        this.deleteResourceBlock(resourceBlock);
    }

    private void _updatePermissionedModels(String name, final long oldResourceBlockId, final long newResourceBlockId) throws Exception {
        PersistedModelLocalService persistedModelLocalService = PersistedModelLocalServiceRegistryUtil.getPersistedModelLocalService((String)name);
        if (persistedModelLocalService == null) {
            throw new ResourceBlocksNotSupportedException();
        }
        Class<?> clazz = persistedModelLocalService.getClass();
        Method getActionableDynamicQueryMethod = clazz.getMethod("getActionableDynamicQuery", new Class[0]);
        ActionableDynamicQuery actionableDynamicQuery = (ActionableDynamicQuery)getActionableDynamicQueryMethod.invoke((Object)persistedModelLocalService, new Object[0]);
        actionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                Property property = PropertyFactoryUtil.forName((String)"resourceBlockId");
                dynamicQuery.add(property.eq((Object)oldResourceBlockId));
            }
        });
        actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<PermissionedModel>(){

            public void performAction(PermissionedModel permissionedModel) {
                permissionedModel.setResourceBlockId(newResourceBlockId);
                permissionedModel.persist();
            }
        });
        actionableDynamicQuery.performActions();
    }
}

