/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.exception.NoSuchWorkflowDefinitionLinkException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.WorkflowDefinitionLink;
import com.liferay.portal.kernel.spring.aop.Skip;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowEngineManagerUtil;
import com.liferay.portal.service.base.WorkflowDefinitionLinkLocalServiceBaseImpl;
import java.util.List;

public class WorkflowDefinitionLinkLocalServiceImpl
extends WorkflowDefinitionLinkLocalServiceBaseImpl {
    public WorkflowDefinitionLink addWorkflowDefinitionLink(long userId, long companyId, long groupId, String className, long classPK, long typePK, String workflowDefinitionName, int workflowDefinitionVersion) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        groupId = StagingUtil.getLiveGroupId((long)groupId);
        long classNameId = this.classNameLocalService.getClassNameId(className);
        long workflowDefinitionLinkId = this.counterLocalService.increment();
        WorkflowDefinitionLink workflowDefinitionLink = this.workflowDefinitionLinkPersistence.create(workflowDefinitionLinkId);
        workflowDefinitionLink.setUserId(userId);
        workflowDefinitionLink.setUserName(user.getFullName());
        workflowDefinitionLink.setGroupId(groupId);
        workflowDefinitionLink.setCompanyId(companyId);
        workflowDefinitionLink.setClassNameId(classNameId);
        workflowDefinitionLink.setClassPK(classPK);
        workflowDefinitionLink.setTypePK(typePK);
        workflowDefinitionLink.setWorkflowDefinitionName(workflowDefinitionName);
        workflowDefinitionLink.setWorkflowDefinitionVersion(workflowDefinitionVersion);
        this.workflowDefinitionLinkPersistence.update((BaseModel)workflowDefinitionLink);
        return workflowDefinitionLink;
    }

    public void deleteWorkflowDefinitionLink(long companyId, long groupId, String className, long classPK, long typePK) {
        WorkflowDefinitionLink workflowDefinitionLink = this.fetchWorkflowDefinitionLink(companyId, groupId, className, classPK, typePK, true);
        if (workflowDefinitionLink != null) {
            this.deleteWorkflowDefinitionLink(workflowDefinitionLink);
        }
    }

    public WorkflowDefinitionLink fetchDefaultWorkflowDefinitionLink(long companyId, String className, long classPK, long typePK) {
        if (!WorkflowEngineManagerUtil.isDeployed()) {
            return null;
        }
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.workflowDefinitionLinkPersistence.fetchByG_C_C_C_T(0L, companyId, classNameId, classPK, typePK);
    }

    public WorkflowDefinitionLink fetchWorkflowDefinitionLink(long companyId, long groupId, String className, long classPK, long typePK) {
        return this.fetchWorkflowDefinitionLink(companyId, groupId, className, classPK, typePK, false);
    }

    public WorkflowDefinitionLink fetchWorkflowDefinitionLink(long companyId, long groupId, String className, long classPK, long typePK, boolean strict) {
        if (!WorkflowEngineManagerUtil.isDeployed()) {
            return null;
        }
        groupId = StagingUtil.getLiveGroupId((long)groupId);
        long classNameId = this.classNameLocalService.getClassNameId(className);
        WorkflowDefinitionLink workflowDefinitionLink = null;
        workflowDefinitionLink = this.workflowDefinitionLinkPersistence.fetchByG_C_C_C_T(groupId, companyId, classNameId, classPK, typePK);
        if (!strict && workflowDefinitionLink == null) {
            workflowDefinitionLink = this.workflowDefinitionLinkPersistence.fetchByG_C_C_C_T(0L, companyId, classNameId, classPK, typePK);
        }
        return workflowDefinitionLink;
    }

    public WorkflowDefinitionLink getDefaultWorkflowDefinitionLink(long companyId, String className, long classPK, long typePK) throws PortalException {
        if (!WorkflowEngineManagerUtil.isDeployed()) {
            throw new NoSuchWorkflowDefinitionLinkException();
        }
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.workflowDefinitionLinkPersistence.findByG_C_C_C_T(0L, companyId, classNameId, classPK, typePK);
    }

    public WorkflowDefinitionLink getWorkflowDefinitionLink(long companyId, long groupId, String className, long classPK, long typePK) throws PortalException {
        return this.getWorkflowDefinitionLink(companyId, groupId, className, classPK, typePK, false);
    }

    public WorkflowDefinitionLink getWorkflowDefinitionLink(long companyId, long groupId, String className, long classPK, long typePK, boolean strict) throws PortalException {
        if (!WorkflowEngineManagerUtil.isDeployed()) {
            throw new NoSuchWorkflowDefinitionLinkException();
        }
        WorkflowDefinitionLink workflowDefinitionLink = this.fetchWorkflowDefinitionLink(companyId, groupId, className, classPK, typePK, strict);
        if (workflowDefinitionLink == null) {
            throw new NoSuchWorkflowDefinitionLinkException("No workflow for groupId=" + groupId + ", companyId=" + companyId + " and className=" + className);
        }
        return workflowDefinitionLink;
    }

    public List<WorkflowDefinitionLink> getWorkflowDefinitionLinks(long companyId, String workflowDefinitionName, int workflowDefinitionVersion) throws PortalException {
        if (!WorkflowEngineManagerUtil.isDeployed()) {
            throw new NoSuchWorkflowDefinitionLinkException();
        }
        return this.workflowDefinitionLinkPersistence.findByC_W_W(companyId, workflowDefinitionName, workflowDefinitionVersion);
    }

    public int getWorkflowDefinitionLinksCount(long companyId, long groupId, String className) {
        return this.workflowDefinitionLinkPersistence.countByG_C_C(groupId, companyId, this.classNameLocalService.getClassNameId(className));
    }

    public int getWorkflowDefinitionLinksCount(long companyId, String workflowDefinitionName, int workflowDefinitionVersion) {
        if (!WorkflowEngineManagerUtil.isDeployed()) {
            return 0;
        }
        return this.workflowDefinitionLinkPersistence.countByC_W_W(companyId, workflowDefinitionName, workflowDefinitionVersion);
    }

    @Skip
    public boolean hasWorkflowDefinitionLink(long companyId, long groupId, String className) {
        return this.hasWorkflowDefinitionLink(companyId, groupId, className, 0L);
    }

    @Skip
    public boolean hasWorkflowDefinitionLink(long companyId, long groupId, String className, long classPK) {
        return this.hasWorkflowDefinitionLink(companyId, groupId, className, classPK, 0L);
    }

    @Skip
    public boolean hasWorkflowDefinitionLink(long companyId, long groupId, String className, long classPK, long typePK) {
        if (!WorkflowEngineManagerUtil.isDeployed()) {
            return false;
        }
        WorkflowDefinitionLink workflowDefinitionLink = this.workflowDefinitionLinkLocalService.fetchWorkflowDefinitionLink(companyId, groupId, className, classPK, typePK);
        return workflowDefinitionLink != null;
    }

    public void updateWorkflowDefinitionLink(long userId, long companyId, long groupId, String className, long classPK, long typePK, String workflowDefinition) throws PortalException {
        if (Validator.isNull((String)workflowDefinition)) {
            this.deleteWorkflowDefinitionLink(companyId, groupId, className, classPK, typePK);
        } else {
            String[] workflowDefinitionParts = StringUtil.split((String)workflowDefinition, (char)'@');
            String workflowDefinitionName = workflowDefinitionParts[0];
            int workflowDefinitionVersion = GetterUtil.getInteger((String)workflowDefinitionParts[1]);
            this.updateWorkflowDefinitionLink(userId, companyId, groupId, className, classPK, typePK, workflowDefinitionName, workflowDefinitionVersion);
        }
    }

    public WorkflowDefinitionLink updateWorkflowDefinitionLink(long userId, long companyId, long groupId, String className, long classPK, long typePK, String workflowDefinitionName, int workflowDefinitionVersion) throws PortalException {
        long classNameId;
        User user = this.userPersistence.findByPrimaryKey(userId);
        WorkflowDefinitionLink workflowDefinitionLink = this.workflowDefinitionLinkPersistence.fetchByG_C_C_C_T(groupId = StagingUtil.getLiveGroupId((long)groupId), companyId, classNameId = this.classNameLocalService.getClassNameId(className), classPK, typePK);
        if (workflowDefinitionLink == null) {
            workflowDefinitionLink = this.addWorkflowDefinitionLink(userId, companyId, groupId, className, classPK, typePK, workflowDefinitionName, workflowDefinitionVersion);
        }
        workflowDefinitionLink.setUserId(userId);
        workflowDefinitionLink.setUserName(user.getFullName());
        workflowDefinitionLink.setGroupId(groupId);
        workflowDefinitionLink.setCompanyId(companyId);
        workflowDefinitionLink.setClassNameId(classNameId);
        workflowDefinitionLink.setClassPK(classPK);
        workflowDefinitionLink.setTypePK(typePK);
        workflowDefinitionLink.setWorkflowDefinitionName(workflowDefinitionName);
        workflowDefinitionLink.setWorkflowDefinitionVersion(workflowDefinitionVersion);
        this.workflowDefinitionLinkPersistence.update((BaseModel)workflowDefinitionLink);
        return workflowDefinitionLink;
    }

    public void updateWorkflowDefinitionLinks(long userId, long companyId, long groupId, String className, long classPK, List<ObjectValuePair<Long, String>> workflowDefinitionOVPs) throws PortalException {
        for (ObjectValuePair<Long, String> workflowDefinitionOVP : workflowDefinitionOVPs) {
            long typePK = (Long)workflowDefinitionOVP.getKey();
            String workflowDefinitionName = (String)workflowDefinitionOVP.getValue();
            if (Validator.isNull((String)workflowDefinitionName)) {
                this.deleteWorkflowDefinitionLink(companyId, groupId, className, classPK, typePK);
                continue;
            }
            this.updateWorkflowDefinitionLink(userId, companyId, groupId, className, classPK, typePK, workflowDefinitionName);
        }
    }
}

