/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.aop;

import com.liferay.portal.spring.aop.BeanMatcher;
import com.liferay.portal.spring.aop.ChainableMethodAdviceInjector;
import com.liferay.portal.spring.aop.ChainableMethodAdviceInjectorCollector;
import com.liferay.portal.spring.aop.ServiceBeanAopCacheManager;
import com.liferay.portal.spring.aop.ServiceBeanAopCacheManagerUtil;
import com.liferay.portal.spring.aop.ServiceBeanAopProxy;
import com.liferay.portal.spring.aop.ServiceBeanMatcher;
import java.util.List;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.springframework.aop.TargetSource;
import org.springframework.aop.framework.AdvisedSupport;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.framework.AopProxy;
import org.springframework.aop.framework.AopProxyFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.framework.autoproxy.AbstractAdvisorAutoProxyCreator;
import org.springframework.beans.factory.ListableBeanFactory;

public class ServiceBeanAutoProxyCreator
extends AbstractAdvisorAutoProxyCreator {
    private BeanMatcher _beanMatcher;
    private MethodInterceptor _methodInterceptor;
    private final ServiceBeanAopCacheManager _serviceBeanAopCacheManager = new ServiceBeanAopCacheManager();

    public void afterPropertiesSet() {
        ServiceBeanAopCacheManagerUtil.registerServiceBeanAopCacheManager(this._serviceBeanAopCacheManager);
        if (this._beanMatcher == null) {
            this._beanMatcher = new ServiceBeanMatcher();
        }
        ListableBeanFactory listableBeanFactory = (ListableBeanFactory)this.getBeanFactory();
        Map chainableMethodAdviceInjectors = listableBeanFactory.getBeansOfType(ChainableMethodAdviceInjector.class);
        for (ChainableMethodAdviceInjector chainableMethodAdviceInjector : chainableMethodAdviceInjectors.values()) {
            chainableMethodAdviceInjector.inject();
        }
        if (!listableBeanFactory.containsBean(ChainableMethodAdviceInjectorCollector.BEAN_NAME)) {
            return;
        }
        ChainableMethodAdviceInjectorCollector chainableMethodAdviceInjectorCollector = (ChainableMethodAdviceInjectorCollector)listableBeanFactory.getBean(ChainableMethodAdviceInjectorCollector.BEAN_NAME);
        List<String> beanNames = chainableMethodAdviceInjectorCollector.getBeanNames();
        for (String beanName : beanNames) {
            Object bean = listableBeanFactory.getBean(beanName);
            if (!(bean instanceof ChainableMethodAdviceInjector)) continue;
            ChainableMethodAdviceInjector chainableMethodAdviceInjector = (ChainableMethodAdviceInjector)bean;
            chainableMethodAdviceInjector.inject();
        }
    }

    public void destroy() {
        ServiceBeanAopCacheManagerUtil.unregisterServiceBeanAopCacheManager(this._serviceBeanAopCacheManager);
    }

    public void setBeanMatcher(BeanMatcher beanMatcher) {
        this._beanMatcher = beanMatcher;
    }

    public void setMethodInterceptor(MethodInterceptor methodInterceptor) {
        this._methodInterceptor = methodInterceptor;
    }

    protected void customizeProxyFactory(ProxyFactory proxyFactory) {
        proxyFactory.setAopProxyFactory(new AopProxyFactory(){

            public AopProxy createAopProxy(AdvisedSupport advisedSupport) throws AopConfigException {
                return new ServiceBeanAopProxy(advisedSupport, ServiceBeanAutoProxyCreator.this._methodInterceptor, ServiceBeanAutoProxyCreator.this._serviceBeanAopCacheManager);
            }
        });
    }

    protected Object[] getAdvicesAndAdvisorsForBean(Class beanClass, String beanName, TargetSource targetSource) {
        Object[] advices = DO_NOT_PROXY;
        if (this._beanMatcher.match(beanClass, beanName) && (advices = super.getAdvicesAndAdvisorsForBean(beanClass, beanName, targetSource)) == DO_NOT_PROXY) {
            advices = PROXY_WITHOUT_ADDITIONAL_INTERCEPTORS;
        }
        return advices;
    }
}

