/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template;

import aQute.bnd.annotation.ProviderType;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.bean.PortletBeanLocatorUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import java.util.function.Function;

@ProviderType
public class ServiceLocator {
    private static final Log _log = LogFactoryUtil.getLog(ServiceLocator.class);
    private static final ServiceLocator _instance = new ServiceLocator();

    public static ServiceLocator getInstance() {
        return _instance;
    }

    public Object findService(String serviceName) {
        Object bean = null;
        try {
            Registry registry = RegistryUtil.getRegistry();
            bean = registry.callService(serviceName, Function.identity());
            if (bean == null) {
                bean = PortalBeanLocatorUtil.locate((String)this._getServiceName(serviceName));
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return bean;
    }

    public Object findService(String servletContextName, String serviceName) {
        Object bean = null;
        try {
            bean = PortletBeanLocatorUtil.locate((String)servletContextName, (String)this._getServiceName(serviceName));
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return bean;
    }

    private ServiceLocator() {
    }

    private String _getServiceName(String serviceName) {
        if (!serviceName.endsWith(".velocity")) {
            serviceName = serviceName + ".velocity";
        }
        return serviceName;
    }
}

