/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.words;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.jazzy.InvalidWord;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.SecureRandomUtil;
import com.liferay.portal.kernel.words.Words;
import com.liferay.portal.words.BasicSpellCheckListener;
import com.swabunga.spell.engine.SpellDictionary;
import com.swabunga.spell.engine.SpellDictionaryHashMap;
import com.swabunga.spell.event.DefaultWordFinder;
import com.swabunga.spell.event.SpellCheckListener;
import com.swabunga.spell.event.SpellChecker;
import com.swabunga.spell.event.StringWordTokenizer;
import com.swabunga.spell.event.WordFinder;
import com.swabunga.spell.event.WordTokenizer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class WordsImpl
implements Words {
    private static final Log _log = LogFactoryUtil.getLog(WordsImpl.class);

    public List<InvalidWord> checkSpelling(String text) {
        SpellChecker spellChecker = new SpellChecker((SpellDictionary)SpellDictionaryHashMapHolder._spellDictionaryHashMap);
        BasicSpellCheckListener basicSpellCheckListener = new BasicSpellCheckListener(text);
        spellChecker.addSpellCheckListener((SpellCheckListener)basicSpellCheckListener);
        spellChecker.checkSpelling((WordTokenizer)new StringWordTokenizer((WordFinder)new DefaultWordFinder(text)));
        return basicSpellCheckListener.getInvalidWords();
    }

    public List<String> getDictionaryList() {
        return DictionaryListSetHolder._dictionaryList;
    }

    public Set<String> getDictionarySet() {
        return DictionaryListSetHolder._dictionarySet;
    }

    public String getRandomWord() {
        List<String> dictionaryList = this.getDictionaryList();
        Random random = new Random(SecureRandomUtil.nextLong());
        int pos = random.nextInt(dictionaryList.size());
        return dictionaryList.get(pos);
    }

    public boolean isDictionaryWord(String word) {
        Set<String> dictionarySet = this.getDictionarySet();
        return dictionarySet.contains(word);
    }

    private static class SpellDictionaryHashMapHolder {
        private static final SpellDictionaryHashMap _spellDictionaryHashMap;

        private SpellDictionaryHashMapHolder() {
        }

        static {
            SpellDictionaryHashMap spellDictionaryHashMap = null;
            try {
                String[] dics;
                spellDictionaryHashMap = new SpellDictionaryHashMap();
                for (String dic : dics = new String[]{"center.dic", "centre.dic", "color.dic", "colour.dic", "eng_com.dic", "english.0", "english.1", "ise.dic", "ize.dic", "labeled.dic", "labelled.dic", "yse.dic", "yze.dic"}) {
                    try (InputStream is = WordsImpl.class.getResourceAsStream("dependencies/" + dic);
                         UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new InputStreamReader(is));){
                        spellDictionaryHashMap.addDictionary((Reader)unsyncBufferedReader);
                    }
                    catch (IOException ioe) {
                        _log.error((Object)ioe, (Throwable)ioe);
                    }
                }
            }
            catch (IOException ioe) {
                _log.error((Object)"Unable to initialize dictionary", (Throwable)ioe);
            }
            _spellDictionaryHashMap = spellDictionaryHashMap;
        }
    }

    private static class DictionaryListSetHolder {
        private static final List<String> _dictionaryList;
        private static final Set<String> _dictionarySet;

        private DictionaryListSetHolder() {
        }

        static {
            ArrayList<String> dictionaryList = new ArrayList<String>();
            try (InputStream is = WordsImpl.class.getResourceAsStream("dependencies/words.txt");
                 UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new InputStreamReader(is));){
                String line = null;
                while ((line = unsyncBufferedReader.readLine()) != null) {
                    dictionaryList.add(line);
                }
            }
            catch (IOException ioe) {
                _log.error((Object)ioe, (Throwable)ioe);
            }
            _dictionaryList = dictionaryList;
            _dictionarySet = new HashSet<String>(dictionaryList);
        }
    }
}

