/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.InvokerFilterContainer;
import com.liferay.portal.kernel.util.ClassLoaderUtil;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.model.impl.PortletFilterImpl;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.FilterConfigImpl;
import com.liferay.portlet.PortletFilterFactory;
import com.liferay.registry.Filter;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceRegistration;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import java.io.Closeable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.filter.ActionFilter;
import javax.portlet.filter.EventFilter;
import javax.portlet.filter.FilterConfig;
import javax.portlet.filter.PortletFilter;
import javax.portlet.filter.RenderFilter;
import javax.portlet.filter.ResourceFilter;

public class InvokerFilterContainerImpl
implements Closeable,
InvokerFilterContainer {
    public static final InvokerFilterContainer EMPTY_INVOKER_FILTER_CONTAINER = new EmptyInvokerFilterContainer();
    private static final Log _log = LogFactoryUtil.getLog(InvokerFilterContainerImpl.class);
    private final List<ActionFilter> _actionFilters = new CopyOnWriteArrayList<ActionFilter>();
    private final List<EventFilter> _eventFilters = new CopyOnWriteArrayList<EventFilter>();
    private final List<RenderFilter> _renderFilters = new CopyOnWriteArrayList<RenderFilter>();
    private final List<ResourceFilter> _resourceFilters = new CopyOnWriteArrayList<ResourceFilter>();
    private final List<ServiceRegistrationTuple> _serviceRegistrationTuples = new CopyOnWriteArrayList<ServiceRegistrationTuple>();
    private final ServiceTracker<PortletFilter, PortletFilter> _serviceTracker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InvokerFilterContainerImpl(Portlet portlet, PortletContext portletContext) throws PortletException {
        String rootPortletId = portlet.getRootPortletId();
        Registry registry = RegistryUtil.getRegistry();
        Filter filter = registry.getFilter("(&(javax.portlet.name=" + rootPortletId + ")(objectClass=" + PortletFilter.class.getName() + "))");
        this._serviceTracker = registry.trackServices(filter, (ServiceTrackerCustomizer)new PortletFilterServiceTrackerCustomizer(portletContext));
        this._serviceTracker.open();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("javax.portlet.name", rootPortletId);
        properties.put("preinitialized.filter", Boolean.TRUE);
        Map portletFilters = portlet.getPortletFilters();
        for (Map.Entry entry : portletFilters.entrySet()) {
            com.liferay.portal.kernel.model.PortletFilter portletFilterModel = (com.liferay.portal.kernel.model.PortletFilter)entry.getValue();
            PortletFilter portletFilter = PortletFilterFactory.create(portletFilterModel, portletContext);
            ServiceRegistration serviceRegistration = registry.registerService(PortletFilter.class, (Object)portletFilter, properties);
            ServiceRegistrationTuple serviceRegistrationTuple = new ServiceRegistrationTuple(portletFilterModel, (ServiceRegistration<PortletFilter>)serviceRegistration);
            this._serviceRegistrationTuples.add(serviceRegistrationTuple);
        }
        ClassLoader classLoader = ClassLoaderUtil.getContextClassLoader();
        try {
            ClassLoaderUtil.setContextClassLoader((ClassLoader)ClassLoaderUtil.getPortalClassLoader());
            for (String portletFilterClassName : PropsValues.PORTLET_FILTERS_SYSTEM) {
                PortletFilterImpl portletFilterModel = new PortletFilterImpl(portletFilterClassName, portletFilterClassName, Collections.emptySet(), Collections.emptyMap(), portlet.getPortletApp());
                PortletFilter portletFilter = PortletFilterFactory.create(portletFilterModel, portletContext);
                ServiceRegistration serviceRegistration = registry.registerService(PortletFilter.class, (Object)portletFilter, properties);
                this._serviceRegistrationTuples.add(new ServiceRegistrationTuple(portletFilterModel, (ServiceRegistration<PortletFilter>)serviceRegistration));
            }
        }
        finally {
            ClassLoaderUtil.setContextClassLoader((ClassLoader)classLoader);
        }
    }

    @Override
    public void close() {
        for (ServiceRegistrationTuple serviceRegistrationTuple : this._serviceRegistrationTuples) {
            PortletFilterFactory.destroy(serviceRegistrationTuple.getPortletFilterModel());
            ServiceRegistration<PortletFilter> serviceRegistration = serviceRegistrationTuple.getServiceRegistration();
            serviceRegistration.unregister();
        }
        this._serviceRegistrationTuples.clear();
        this._serviceTracker.close();
        this._actionFilters.clear();
        this._eventFilters.clear();
        this._renderFilters.clear();
        this._resourceFilters.clear();
    }

    public List<ActionFilter> getActionFilters() {
        return this._actionFilters;
    }

    public List<EventFilter> getEventFilters() {
        return this._eventFilters;
    }

    public List<RenderFilter> getRenderFilters() {
        return this._renderFilters;
    }

    public List<ResourceFilter> getResourceFilters() {
        return this._resourceFilters;
    }

    private class PortletFilterServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<PortletFilter, PortletFilter> {
        private final PortletContext _portletContext;

        public PortletFilterServiceTrackerCustomizer(PortletContext portletContext) {
            this._portletContext = portletContext;
        }

        public PortletFilter addingService(ServiceReference<PortletFilter> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            PortletFilter portletFilter = (PortletFilter)registry.getService(serviceReference);
            boolean preinitializedFilter = GetterUtil.getBoolean((Object)serviceReference.getProperty("preinitialized.filter"));
            if (!preinitializedFilter) {
                String filterName = GetterUtil.getString((Object)serviceReference.getProperty("service.id"), (String)ClassUtil.getClassName((Object)portletFilter));
                HashMap<String, String> params = new HashMap<String, String>();
                for (String key : serviceReference.getPropertyKeys()) {
                    String value = GetterUtil.getString((Object)serviceReference.getProperty(key));
                    params.put(key, value);
                }
                FilterConfigImpl filterConfig = new FilterConfigImpl(filterName, this._portletContext, params);
                try {
                    portletFilter.init((FilterConfig)filterConfig);
                }
                catch (PortletException pe) {
                    _log.error((Object)pe, (Throwable)pe);
                    registry.ungetService(serviceReference);
                    return null;
                }
            }
            if (portletFilter instanceof ActionFilter) {
                InvokerFilterContainerImpl.this._actionFilters.add((ActionFilter)portletFilter);
            }
            if (portletFilter instanceof EventFilter) {
                InvokerFilterContainerImpl.this._eventFilters.add((EventFilter)portletFilter);
            }
            if (portletFilter instanceof RenderFilter) {
                InvokerFilterContainerImpl.this._renderFilters.add((RenderFilter)portletFilter);
            }
            if (portletFilter instanceof ResourceFilter) {
                InvokerFilterContainerImpl.this._resourceFilters.add((ResourceFilter)portletFilter);
            }
            return portletFilter;
        }

        public void modifiedService(ServiceReference<PortletFilter> serviceReference, PortletFilter portletFilter) {
        }

        public void removedService(ServiceReference<PortletFilter> serviceReference, PortletFilter portletFilter) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            InvokerFilterContainerImpl.this._actionFilters.remove(portletFilter);
            InvokerFilterContainerImpl.this._eventFilters.remove(portletFilter);
            InvokerFilterContainerImpl.this._renderFilters.remove(portletFilter);
            InvokerFilterContainerImpl.this._resourceFilters.remove(portletFilter);
            boolean preinitializedFilter = GetterUtil.getBoolean((Object)serviceReference.getProperty("preinitialized.filter"));
            if (preinitializedFilter) {
                return;
            }
            portletFilter.destroy();
        }
    }

    private static class ServiceRegistrationTuple {
        private final com.liferay.portal.kernel.model.PortletFilter _portletFilterModel;
        private final ServiceRegistration<PortletFilter> _serviceRegistration;

        public ServiceRegistrationTuple(com.liferay.portal.kernel.model.PortletFilter portletFilterModel, ServiceRegistration<PortletFilter> serviceRegistration) {
            this._portletFilterModel = portletFilterModel;
            this._serviceRegistration = serviceRegistration;
        }

        public com.liferay.portal.kernel.model.PortletFilter getPortletFilterModel() {
            return this._portletFilterModel;
        }

        public ServiceRegistration<PortletFilter> getServiceRegistration() {
            return this._serviceRegistration;
        }
    }

    private static class EmptyInvokerFilterContainer
    implements Closeable,
    InvokerFilterContainer {
        private EmptyInvokerFilterContainer() {
        }

        @Override
        public void close() {
        }

        public List<ActionFilter> getActionFilters() {
            return Collections.emptyList();
        }

        public List<EventFilter> getEventFilters() {
            return Collections.emptyList();
        }

        public List<RenderFilter> getRenderFilters() {
            return Collections.emptyList();
        }

        public List<ResourceFilter> getResourceFilters() {
            return Collections.emptyList();
        }
    }
}

