/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.model.PortletInfo;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public class PortletResourceBundle
extends ResourceBundle {
    private final Map<String, String> _portletInfos;

    public static Map<String, String> getPortletInfos(PortletInfo portletInfo) {
        String title;
        String shortTitle;
        String keywords;
        if (portletInfo == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> portletInfos = new HashMap<String, String>();
        String description = portletInfo.getDescription();
        if (description != null) {
            portletInfos.put("javax.portlet.description", description);
        }
        if ((keywords = portletInfo.getKeywords()) != null) {
            portletInfos.put("javax.portlet.keywords", keywords);
        }
        if ((shortTitle = portletInfo.getShortTitle()) != null) {
            portletInfos.put("javax.portlet.short-title", shortTitle);
        }
        if ((title = portletInfo.getTitle()) != null) {
            portletInfos.put("javax.portlet.title", title);
        }
        return portletInfos;
    }

    @Deprecated
    public PortletResourceBundle(PortletInfo portletInfo) {
        this(null, PortletResourceBundle.getPortletInfos(portletInfo));
    }

    public PortletResourceBundle(ResourceBundle parentResourceBundle, Map<String, String> portletInfos) {
        this.parent = parentResourceBundle;
        this._portletInfos = portletInfos;
    }

    @Deprecated
    public PortletResourceBundle(ResourceBundle parentResourceBundle, PortletInfo portletInfo) {
        this(parentResourceBundle, PortletResourceBundle.getPortletInfos(portletInfo));
    }

    @Override
    public Enumeration<String> getKeys() {
        if (this.parent == null) {
            return Collections.enumeration(this._portletInfos.keySet());
        }
        HashSet<String> keys = new HashSet<String>(this.parent.keySet());
        keys.addAll(this._portletInfos.keySet());
        return Collections.enumeration(keys);
    }

    @Override
    public Locale getLocale() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getLocale();
    }

    @Override
    protected Object handleGetObject(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (this.parent != null && this.parent.containsKey(key)) {
            return this.parent.getString(key);
        }
        return this._portletInfos.get(key);
    }

    @Override
    protected Set<String> handleKeySet() {
        return this._portletInfos.keySet();
    }
}

