/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.expando.service.impl;

import com.liferay.expando.kernel.exception.NoSuchRowException;
import com.liferay.expando.kernel.model.ExpandoColumn;
import com.liferay.expando.kernel.model.ExpandoRow;
import com.liferay.expando.kernel.model.ExpandoTable;
import com.liferay.expando.kernel.model.ExpandoValue;
import com.liferay.expando.kernel.util.ExpandoValueDeleteHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.typeconverter.DateArrayConverter;
import com.liferay.portal.typeconverter.NumberArrayConverter;
import com.liferay.portal.typeconverter.NumberConverter;
import com.liferay.portlet.expando.model.impl.ExpandoValueImpl;
import com.liferay.portlet.expando.service.base.ExpandoValueLocalServiceBaseImpl;
import com.liferay.registry.collections.ServiceTrackerCollections;
import com.liferay.registry.collections.ServiceTrackerList;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import jodd.typeconverter.TypeConverter;
import jodd.typeconverter.TypeConverterManager;
import jodd.typeconverter.TypeConverterManagerBean;

public class ExpandoValueLocalServiceImpl
extends ExpandoValueLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(ExpandoValueLocalServiceImpl.class);

    public ExpandoValueLocalServiceImpl() {
        TypeConverterManagerBean defaultTypeConverterManager = TypeConverterManager.getDefaultTypeConverterManager();
        defaultTypeConverterManager.register(Date[].class, (TypeConverter)new DateArrayConverter(defaultTypeConverterManager.getConvertBean()));
        defaultTypeConverterManager.register(Number.class, (TypeConverter)new NumberConverter());
        defaultTypeConverterManager.register(Number[].class, (TypeConverter)new NumberArrayConverter(defaultTypeConverterManager.getConvertBean()));
    }

    public ExpandoValue addValue(long classNameId, long tableId, long columnId, long classPK, String data) throws PortalException {
        ExpandoTable table = this.expandoTablePersistence.findByPrimaryKey(tableId);
        return this.doAddValue(table.getCompanyId(), classNameId, tableId, columnId, classPK, data);
    }

    public ExpandoValue addValue(long companyId, String className, String tableName, String columnName, long classPK, boolean data) throws PortalException {
        ExpandoTable table = this.expandoTableLocalService.getTable(companyId, className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setBoolean(data);
        return this.expandoValueLocalService.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(long companyId, String className, String tableName, String columnName, long classPK, boolean[] data) throws PortalException {
        ExpandoTable table = this.expandoTableLocalService.getTable(companyId, className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setBooleanArray(data);
        return this.expandoValueLocalService.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(long companyId, String className, String tableName, String columnName, long classPK, Date data) throws PortalException {
        ExpandoTable table = this.expandoTableLocalService.getTable(companyId, className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setDate(data);
        return this.expandoValueLocalService.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(long companyId, String className, String tableName, String columnName, long classPK, Date[] data) throws PortalException {
        ExpandoTable table = this.expandoTableLocalService.getTable(companyId, className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setDateArray(data);
        return this.expandoValueLocalService.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(long companyId, String className, String tableName, String columnName, long classPK, double data) throws PortalException {
        ExpandoTable table = this.expandoTableLocalService.getTable(companyId, className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setDouble(data);
        return this.expandoValueLocalService.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(long companyId, String className, String tableName, String columnName, long classPK, double[] data) throws PortalException {
        ExpandoTable table = this.expandoTableLocalService.getTable(companyId, className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setDoubleArray(data);
        return this.expandoValueLocalService.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(long companyId, String className, String tableName, String columnName, long classPK, float data) throws PortalException {
        ExpandoTable table = this.expandoTableLocalService.getTable(companyId, className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setFloat(data);
        return this.expandoValueLocalService.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(long companyId, String className, String tableName, String columnName, long classPK, float[] data) throws PortalException {
        ExpandoTable table = this.expandoTableLocalService.getTable(companyId, className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setFloatArray(data);
        return this.expandoValueLocalService.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(long companyId, String className, String tableName, String columnName, long classPK, int data) throws PortalException {
        ExpandoTable table = this.expandoTableLocalService.getTable(companyId, className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setInteger(data);
        return this.expandoValueLocalService.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(long companyId, String className, String tableName, String columnName, long classPK, int[] data) throws PortalException {
        ExpandoTable table = this.expandoTableLocalService.getTable(companyId, className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setIntegerArray(data);
        return this.expandoValueLocalService.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(long companyId, String className, String tableName, String columnName, long classPK, JSONObject data) throws PortalException {
        ExpandoTable table = this.expandoTableLocalService.getTable(companyId, className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setGeolocationJSONObject(data);
        return this.expandoValueLocalService.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(long companyId, String className, String tableName, String columnName, long classPK, long data) throws PortalException {
        ExpandoTable table = this.expandoTableLocalService.getTable(companyId, className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setLong(data);
        return this.expandoValueLocalService.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(long companyId, String className, String tableName, String columnName, long classPK, long[] data) throws PortalException {
        ExpandoTable table = this.expandoTableLocalService.getTable(companyId, className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setLongArray(data);
        return this.expandoValueLocalService.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(long companyId, String className, String tableName, String columnName, long classPK, Map<Locale, ?> dataMap, Locale defautlLocale) throws PortalException {
        ExpandoTable table = this.expandoTableLocalService.getTable(companyId, className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        int type = column.getType();
        if (type == 19) {
            value.setStringArrayMap(dataMap, defautlLocale);
        } else {
            value.setStringMap(dataMap, defautlLocale);
        }
        return this.expandoValueLocalService.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(long companyId, String className, String tableName, String columnName, long classPK, Number data) throws PortalException {
        ExpandoTable table = this.expandoTableLocalService.getTable(companyId, className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setNumber(data);
        return this.expandoValueLocalService.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(long companyId, String className, String tableName, String columnName, long classPK, Number[] data) throws PortalException {
        ExpandoTable table = this.expandoTableLocalService.getTable(companyId, className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setNumberArray(data);
        return this.expandoValueLocalService.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(long companyId, String className, String tableName, String columnName, long classPK, Object data) throws PortalException {
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(companyId, className, tableName, columnName);
        int type = column.getType();
        data = this.convertType(type, data);
        if (type == 1) {
            return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, ((Boolean)data).booleanValue());
        }
        if (type == 2) {
            return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, (boolean[])data);
        }
        if (type == 3) {
            return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, (Date)data);
        }
        if (type == 4) {
            return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, (Date[])data);
        }
        if (type == 5) {
            return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, ((Double)data).doubleValue());
        }
        if (type == 6) {
            return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, (double[])data);
        }
        if (type == 7) {
            return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, ((Float)data).floatValue());
        }
        if (type == 8) {
            return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, (float[])data);
        }
        if (type == 21) {
            return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, JSONFactoryUtil.createJSONObject((String)data.toString()));
        }
        if (type == 9) {
            return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, ((Integer)data).intValue());
        }
        if (type == 10) {
            return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, (int[])data);
        }
        if (type == 11) {
            return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, ((Long)data).longValue());
        }
        if (type == 12) {
            return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, (long[])data);
        }
        if (type == 17) {
            return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, (Number)data);
        }
        if (type == 18) {
            return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, (Number[])data);
        }
        if (type == 13) {
            return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, ((Short)data).shortValue());
        }
        if (type == 14) {
            return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, (short[])data);
        }
        if (type == 16) {
            return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, (String[])data);
        }
        if (type == 15) {
            return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, (String)data);
        }
        return this.expandoValueLocalService.addValue(companyId, className, tableName, columnName, classPK, (Map)data, Locale.getDefault());
    }

    public ExpandoValue addValue(long companyId, String className, String tableName, String columnName, long classPK, short data) throws PortalException {
        ExpandoTable table = this.expandoTableLocalService.getTable(companyId, className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setShort(data);
        return this.expandoValueLocalService.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(long companyId, String className, String tableName, String columnName, long classPK, short[] data) throws PortalException {
        ExpandoTable table = this.expandoTableLocalService.getTable(companyId, className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setShortArray(data);
        return this.expandoValueLocalService.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(long companyId, String className, String tableName, String columnName, long classPK, String data) throws PortalException {
        ExpandoTable table = this.expandoTableLocalService.getTable(companyId, className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setString(data);
        return this.expandoValueLocalService.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public ExpandoValue addValue(long companyId, String className, String tableName, String columnName, long classPK, String[] data) throws PortalException {
        ExpandoTable table = this.expandoTableLocalService.getTable(companyId, className, tableName);
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(table.getTableId(), columnName);
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setCompanyId(table.getCompanyId());
        value.setColumnId(column.getColumnId());
        value.setStringArray(data);
        return this.expandoValueLocalService.addValue(table.getClassNameId(), table.getTableId(), column.getColumnId(), classPK, value.getData());
    }

    public void addValues(long classNameId, long tableId, List<ExpandoColumn> columns, long classPK, Map<String, String> data) throws PortalException {
        ExpandoTable table = this.expandoTablePersistence.findByPrimaryKey(tableId);
        ExpandoRow row = this.expandoRowPersistence.fetchByT_C(tableId, classPK);
        if (row == null) {
            long rowId = this.counterLocalService.increment();
            row = this.expandoRowPersistence.create(rowId);
            row.setCompanyId(table.getCompanyId());
            row.setTableId(tableId);
            row.setClassPK(classPK);
            this.expandoRowPersistence.update((BaseModel)row);
        }
        boolean rowModified = false;
        for (ExpandoColumn column : columns) {
            String dataString = data.get(column.getName());
            if (dataString == null) continue;
            ExpandoValue value = this.expandoValuePersistence.fetchByC_R(column.getColumnId(), row.getRowId());
            if (value == null) {
                long valueId = this.counterLocalService.increment();
                value = this.expandoValuePersistence.create(valueId);
                value.setCompanyId(table.getCompanyId());
                value.setTableId(tableId);
                value.setColumnId(column.getColumnId());
                value.setRowId(row.getRowId());
                value.setClassNameId(classNameId);
                value.setClassPK(classPK);
            }
            if (!value.isNew() && Objects.equals(value.getData(), dataString)) continue;
            value.setData(dataString);
            this.expandoValuePersistence.update((BaseModel)value);
            rowModified = true;
        }
        if (rowModified) {
            row.setModifiedDate(new Date());
            this.expandoRowPersistence.update((BaseModel)row);
        }
    }

    public void addValues(long companyId, long classNameId, String tableName, long classPK, Map<String, Serializable> attributes) throws PortalException {
        ExpandoTable table = this.expandoTableLocalService.getTable(companyId, classNameId, tableName);
        List columns = this.expandoColumnLocalService.getColumns(table.getTableId(), attributes.keySet());
        for (ExpandoColumn column : columns) {
            ExpandoValueImpl value = new ExpandoValueImpl();
            value.setCompanyId(companyId);
            Serializable attributeValue = attributes.get(column.getName());
            value.setColumn(column);
            int type = column.getType();
            if (type == 1) {
                value.setBoolean((Boolean)attributeValue);
            } else if (type == 2) {
                value.setBooleanArray((boolean[])attributeValue);
            } else if (type == 3) {
                value.setDate((Date)attributeValue);
            } else if (type == 4) {
                value.setDateArray((Date[])attributeValue);
            } else if (type == 5) {
                value.setDouble((Double)attributeValue);
            } else if (type == 6) {
                value.setDoubleArray((double[])attributeValue);
            } else if (type == 7) {
                value.setFloat(((Float)attributeValue).floatValue());
            } else if (type == 8) {
                value.setFloatArray((float[])attributeValue);
            } else if (type == 21) {
                JSONObject geolocation = JSONFactoryUtil.createJSONObject((String)attributeValue.toString());
                value.setGeolocationJSONObject(geolocation);
            } else if (type == 9) {
                value.setInteger((Integer)attributeValue);
            } else if (type == 10) {
                value.setIntegerArray((int[])attributeValue);
            } else if (type == 11) {
                value.setLong((Long)attributeValue);
            } else if (type == 12) {
                value.setLongArray((long[])attributeValue);
            } else if (type == 17) {
                value.setNumber((Number)attributeValue);
            } else if (type == 18) {
                value.setNumberArray((Number[])attributeValue);
            } else if (type == 13) {
                value.setShort((Short)attributeValue);
            } else if (type == 14) {
                value.setShortArray((short[])attributeValue);
            } else if (type == 16) {
                value.setStringArray((String[])attributeValue);
            } else if (type == 20) {
                value.setStringMap((Map)((Object)attributeValue), Locale.getDefault());
            } else {
                value.setString((String)((Object)attributeValue));
            }
            this.doAddValue(companyId, classNameId, table.getTableId(), column.getColumnId(), classPK, value.getData());
        }
    }

    public void addValues(long companyId, String className, String tableName, long classPK, Map<String, Serializable> attributes) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        this.addValues(companyId, classNameId, tableName, classPK, attributes);
    }

    public void deleteColumnValues(long columnId) {
        List values = this.expandoValuePersistence.findByColumnId(columnId);
        for (ExpandoValue value : values) {
            this.deleteValue(value);
        }
    }

    public void deleteRowValues(long rowId) {
        List values = this.expandoValuePersistence.findByRowId(rowId);
        for (ExpandoValue value : values) {
            this.deleteValue(value);
        }
    }

    public void deleteTableValues(long tableId) {
        List values = this.expandoValuePersistence.findByTableId(tableId);
        for (ExpandoValue value : values) {
            this.deleteValue(value);
        }
    }

    public void deleteValue(ExpandoValue value) {
        block4: {
            this.expandoValuePersistence.remove((BaseModel)value);
            ServiceTrackerList serviceTrackerList = ServiceTrackerCollections.openList(ExpandoValueDeleteHandler.class, (String)("(model.class.name=" + value.getClassName() + ")"));
            for (ExpandoValueDeleteHandler expandoValueDeleteHandler : serviceTrackerList) {
                expandoValueDeleteHandler.deletedExpandoValue(value.getClassPK());
            }
            List values = this.expandoValuePersistence.findByRowId(value.getRowId());
            if (values.isEmpty()) {
                try {
                    this.expandoRowPersistence.remove(value.getRowId());
                }
                catch (NoSuchRowException nsre) {
                    if (!_log.isDebugEnabled()) break block4;
                    _log.debug((Object)("Row " + value.getRowId() + " does not exist"), (Throwable)nsre);
                }
            }
        }
    }

    public void deleteValue(long valueId) throws PortalException {
        ExpandoValue value = this.expandoValuePersistence.findByPrimaryKey(valueId);
        this.deleteValue(value);
    }

    public void deleteValue(long columnId, long rowId) throws PortalException {
        ExpandoValue value = this.expandoValuePersistence.findByC_R(columnId, rowId);
        this.deleteValue(value);
    }

    public void deleteValue(long companyId, long classNameId, String tableName, String columnName, long classPK) throws PortalException {
        ExpandoTable table = this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, tableName);
        if (table == null) {
            return;
        }
        ExpandoColumn column = this.expandoColumnPersistence.fetchByT_N(table.getTableId(), columnName);
        if (column == null) {
            return;
        }
        ExpandoValue value = this.expandoValuePersistence.fetchByT_C_C(table.getTableId(), column.getColumnId(), classPK);
        if (value != null) {
            this.deleteValue(value.getValueId());
        }
    }

    public void deleteValue(long companyId, String className, String tableName, String columnName, long classPK) throws PortalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        this.expandoValueLocalService.deleteValue(companyId, classNameId, tableName, columnName, classPK);
    }

    public void deleteValues(long classNameId, long classPK) {
        List values = this.expandoValuePersistence.findByC_C(classNameId, classPK);
        for (ExpandoValue value : values) {
            this.deleteValue(value);
        }
    }

    public void deleteValues(String className, long classPK) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        this.expandoValueLocalService.deleteValues(classNameId, classPK);
    }

    public List<ExpandoValue> getColumnValues(long columnId, int start, int end) {
        return this.expandoValuePersistence.findByColumnId(columnId, start, end);
    }

    public List<ExpandoValue> getColumnValues(long companyId, long classNameId, String tableName, String columnName, int start, int end) {
        return this.expandoValueLocalService.getColumnValues(companyId, classNameId, tableName, columnName, null, start, end);
    }

    public List<ExpandoValue> getColumnValues(long companyId, long classNameId, String tableName, String columnName, String data, int start, int end) {
        ExpandoTable table = this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, tableName);
        if (table == null) {
            return Collections.emptyList();
        }
        ExpandoColumn column = this.expandoColumnPersistence.fetchByT_N(table.getTableId(), columnName);
        if (column == null) {
            return Collections.emptyList();
        }
        if (data == null) {
            return this.expandoValuePersistence.findByT_C(table.getTableId(), column.getColumnId(), start, end);
        }
        return this.expandoValuePersistence.findByT_C_D(table.getTableId(), column.getColumnId(), data, start, end);
    }

    public List<ExpandoValue> getColumnValues(long companyId, String className, String tableName, String columnName, int start, int end) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.expandoValueLocalService.getColumnValues(companyId, classNameId, tableName, columnName, start, end);
    }

    public List<ExpandoValue> getColumnValues(long companyId, String className, String tableName, String columnName, String data, int start, int end) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.expandoValueLocalService.getColumnValues(companyId, classNameId, tableName, columnName, data, start, end);
    }

    public int getColumnValuesCount(long columnId) {
        return this.expandoValuePersistence.countByColumnId(columnId);
    }

    public int getColumnValuesCount(long companyId, long classNameId, String tableName, String columnName) {
        return this.expandoValueLocalService.getColumnValuesCount(companyId, classNameId, tableName, columnName, null);
    }

    public int getColumnValuesCount(long companyId, long classNameId, String tableName, String columnName, String data) {
        ExpandoTable table = this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, tableName);
        if (table == null) {
            return 0;
        }
        ExpandoColumn column = this.expandoColumnPersistence.fetchByT_N(table.getTableId(), columnName);
        if (column == null) {
            return 0;
        }
        if (data == null) {
            return this.expandoValuePersistence.countByT_C(table.getTableId(), column.getColumnId());
        }
        return this.expandoValuePersistence.countByT_C_D(table.getTableId(), column.getColumnId(), data);
    }

    public int getColumnValuesCount(long companyId, String className, String tableName, String columnName) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.expandoValueLocalService.getColumnValuesCount(companyId, classNameId, tableName, columnName);
    }

    public int getColumnValuesCount(long companyId, String className, String tableName, String columnName, String data) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.expandoValueLocalService.getColumnValuesCount(companyId, classNameId, tableName, columnName, data);
    }

    public Map<String, Serializable> getData(long companyId, String className, String tableName, Collection<String> columnNames, long classPK) throws PortalException {
        List columns = this.expandoColumnLocalService.getColumns(companyId, className, tableName, columnNames);
        HashMap<String, Serializable> attributeValues = new HashMap<String, Serializable>((int)((double)columnNames.size() * 1.4));
        ExpandoValueImpl value = new ExpandoValueImpl();
        for (ExpandoColumn column : columns) {
            value.setColumn(column);
            value.setData(column.getDefaultData());
            Serializable attributeValue = this.doGetData(companyId, className, tableName, column.getName(), classPK, value, column.getType());
            attributeValues.put(column.getName(), attributeValue);
        }
        return attributeValues;
    }

    public Serializable getData(long companyId, String className, String tableName, String columnName, long classPK) throws PortalException {
        ExpandoColumn column = this.expandoColumnLocalService.getColumn(companyId, className, tableName, columnName);
        if (column == null) {
            return null;
        }
        ExpandoValueImpl value = new ExpandoValueImpl();
        value.setColumn(column);
        value.setData(column.getDefaultData());
        return this.doGetData(companyId, className, tableName, columnName, classPK, value, column.getType());
    }

    public boolean getData(long companyId, String className, String tableName, String columnName, long classPK, boolean defaultData) throws PortalException {
        ExpandoValue value = this.expandoValueLocalService.getValue(companyId, className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        return value.getBoolean();
    }

    public boolean[] getData(long companyId, String className, String tableName, String columnName, long classPK, boolean[] defaultData) throws PortalException {
        ExpandoValue value = this.expandoValueLocalService.getValue(companyId, className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        return value.getBooleanArray();
    }

    public Date getData(long companyId, String className, String tableName, String columnName, long classPK, Date defaultData) throws PortalException {
        ExpandoValue value = this.expandoValueLocalService.getValue(companyId, className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        return value.getDate();
    }

    public Date[] getData(long companyId, String className, String tableName, String columnName, long classPK, Date[] defaultData) throws PortalException {
        ExpandoValue value = this.expandoValueLocalService.getValue(companyId, className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        return value.getDateArray();
    }

    public double getData(long companyId, String className, String tableName, String columnName, long classPK, double defaultData) throws PortalException {
        ExpandoValue value = this.expandoValueLocalService.getValue(companyId, className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        return value.getDouble();
    }

    public double[] getData(long companyId, String className, String tableName, String columnName, long classPK, double[] defaultData) throws PortalException {
        ExpandoValue value = this.expandoValueLocalService.getValue(companyId, className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        return value.getDoubleArray();
    }

    public float getData(long companyId, String className, String tableName, String columnName, long classPK, float defaultData) throws PortalException {
        ExpandoValue value = this.expandoValueLocalService.getValue(companyId, className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        return value.getFloat();
    }

    public float[] getData(long companyId, String className, String tableName, String columnName, long classPK, float[] defaultData) throws PortalException {
        ExpandoValue value = this.expandoValueLocalService.getValue(companyId, className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        return value.getFloatArray();
    }

    public int getData(long companyId, String className, String tableName, String columnName, long classPK, int defaultData) throws PortalException {
        ExpandoValue value = this.expandoValueLocalService.getValue(companyId, className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        return value.getInteger();
    }

    public int[] getData(long companyId, String className, String tableName, String columnName, long classPK, int[] defaultData) throws PortalException {
        ExpandoValue value = this.expandoValueLocalService.getValue(companyId, className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        return value.getIntegerArray();
    }

    public JSONObject getData(long companyId, String className, String tableName, String columnName, long classPK, JSONObject defaultData) throws PortalException {
        ExpandoValue value = this.expandoValueLocalService.getValue(companyId, className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        return value.getGeolocationJSONObject();
    }

    public long getData(long companyId, String className, String tableName, String columnName, long classPK, long defaultData) throws PortalException {
        ExpandoValue value = this.expandoValueLocalService.getValue(companyId, className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        return value.getLong();
    }

    public long[] getData(long companyId, String className, String tableName, String columnName, long classPK, long[] defaultData) throws PortalException {
        ExpandoValue value = this.expandoValueLocalService.getValue(companyId, className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        return value.getLongArray();
    }

    public Map<?, ?> getData(long companyId, String className, String tableName, String columnName, long classPK, Map<?, ?> defaultData) throws PortalException {
        ExpandoValue value = this.expandoValueLocalService.getValue(companyId, className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        ExpandoColumn column = value.getColumn();
        int type = column.getType();
        if (type == 19) {
            return value.getStringArrayMap();
        }
        return value.getStringMap();
    }

    public Number getData(long companyId, String className, String tableName, String columnName, long classPK, Number defaultData) throws PortalException {
        ExpandoValue value = this.expandoValueLocalService.getValue(companyId, className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        return value.getNumber();
    }

    public Number[] getData(long companyId, String className, String tableName, String columnName, long classPK, Number[] defaultData) throws PortalException {
        ExpandoValue value = this.expandoValueLocalService.getValue(companyId, className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        return value.getNumberArray();
    }

    public short getData(long companyId, String className, String tableName, String columnName, long classPK, short defaultData) throws PortalException {
        ExpandoValue value = this.expandoValueLocalService.getValue(companyId, className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        return value.getShort();
    }

    public short[] getData(long companyId, String className, String tableName, String columnName, long classPK, short[] defaultData) throws PortalException {
        ExpandoValue value = this.expandoValueLocalService.getValue(companyId, className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        return value.getShortArray();
    }

    public String getData(long companyId, String className, String tableName, String columnName, long classPK, String defaultData) throws PortalException {
        ExpandoValue value = this.expandoValueLocalService.getValue(companyId, className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        return value.getString();
    }

    public String[] getData(long companyId, String className, String tableName, String columnName, long classPK, String[] defaultData) throws PortalException {
        ExpandoValue value = this.expandoValueLocalService.getValue(companyId, className, tableName, columnName, classPK);
        if (value == null) {
            return defaultData;
        }
        return value.getStringArray();
    }

    public List<ExpandoValue> getDefaultTableColumnValues(long companyId, long classNameId, String columnName, int start, int end) {
        return this.expandoValueLocalService.getColumnValues(companyId, classNameId, "CUSTOM_FIELDS", columnName, start, end);
    }

    public List<ExpandoValue> getDefaultTableColumnValues(long companyId, String className, String columnName, int start, int end) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.expandoValueLocalService.getDefaultTableColumnValues(companyId, classNameId, columnName, start, end);
    }

    public int getDefaultTableColumnValuesCount(long companyId, long classNameId, String columnName) {
        return this.expandoValueLocalService.getColumnValuesCount(companyId, classNameId, "CUSTOM_FIELDS", columnName);
    }

    public int getDefaultTableColumnValuesCount(long companyId, String className, String columnName) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.expandoValueLocalService.getDefaultTableColumnValuesCount(companyId, classNameId, columnName);
    }

    public List<ExpandoValue> getRowValues(long rowId) {
        return this.expandoValuePersistence.findByRowId(rowId);
    }

    public List<ExpandoValue> getRowValues(long rowId, int start, int end) {
        return this.expandoValuePersistence.findByRowId(rowId, start, end);
    }

    public List<ExpandoValue> getRowValues(long companyId, long classNameId, String tableName, long classPK, int start, int end) {
        ExpandoTable table = this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, tableName);
        if (table == null) {
            return Collections.emptyList();
        }
        return this.expandoValuePersistence.findByT_CPK(table.getTableId(), classPK, start, end);
    }

    public List<ExpandoValue> getRowValues(long companyId, String className, String tableName, long classPK, int start, int end) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.expandoValueLocalService.getRowValues(companyId, classNameId, tableName, classPK, start, end);
    }

    public int getRowValuesCount(long rowId) {
        return this.expandoValuePersistence.countByRowId(rowId);
    }

    public int getRowValuesCount(long companyId, long classNameId, String tableName, long classPK) {
        ExpandoTable table = this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, tableName);
        if (table == null) {
            return 0;
        }
        return this.expandoValuePersistence.countByT_CPK(table.getTableId(), classPK);
    }

    public int getRowValuesCount(long companyId, String className, String tableName, long classPK) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.expandoValueLocalService.getRowValuesCount(companyId, classNameId, tableName, classPK);
    }

    public ExpandoValue getValue(long valueId) throws PortalException {
        return this.expandoValuePersistence.findByPrimaryKey(valueId);
    }

    public ExpandoValue getValue(long columnId, long rowId) throws PortalException {
        return this.expandoValuePersistence.findByC_R(columnId, rowId);
    }

    public ExpandoValue getValue(long tableId, long columnId, long classPK) {
        return this.expandoValuePersistence.fetchByT_C_C(tableId, columnId, classPK);
    }

    public ExpandoValue getValue(long companyId, long classNameId, String tableName, String columnName, long classPK) {
        ExpandoTable table = this.expandoTablePersistence.fetchByC_C_N(companyId, classNameId, tableName);
        if (table == null) {
            return null;
        }
        ExpandoColumn column = this.expandoColumnPersistence.fetchByT_N(table.getTableId(), columnName);
        if (column == null) {
            return null;
        }
        return this.expandoValuePersistence.fetchByT_C_C(table.getTableId(), column.getColumnId(), classPK);
    }

    public ExpandoValue getValue(long companyId, String className, String tableName, String columnName, long classPK) {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        return this.expandoValueLocalService.getValue(companyId, classNameId, tableName, columnName, classPK);
    }

    protected <T> T convertType(int type, Object data) {
        if (data == null) {
            return (T)data;
        }
        data = this.handleCollections(type, data);
        data = this.handleStrings(type, data);
        if (type == 1) {
            data = TypeConverterManager.convertType((Object)data, Boolean.TYPE);
        } else if (type == 2) {
            data = TypeConverterManager.convertType((Object)data, boolean[].class);
        } else if (type == 3) {
            data = TypeConverterManager.convertType((Object)data, Date.class);
        } else if (type == 4) {
            data = TypeConverterManager.convertType((Object)data, Date[].class);
        } else if (type == 5) {
            data = TypeConverterManager.convertType((Object)data, Double.TYPE);
        } else if (type == 6) {
            data = TypeConverterManager.convertType((Object)data, double[].class);
        } else if (type == 7) {
            data = TypeConverterManager.convertType((Object)data, Float.TYPE);
        } else if (type == 8) {
            data = TypeConverterManager.convertType((Object)data, float[].class);
        } else if (type == 9) {
            data = TypeConverterManager.convertType((Object)data, Integer.TYPE);
        } else if (type == 10) {
            data = TypeConverterManager.convertType((Object)data, int[].class);
        } else if (type == 11) {
            data = TypeConverterManager.convertType((Object)data, Long.TYPE);
        } else if (type == 12) {
            data = TypeConverterManager.convertType((Object)data, long[].class);
        } else if (type == 17) {
            data = TypeConverterManager.convertType((Object)data, Number.class);
        } else if (type == 18) {
            data = TypeConverterManager.convertType((Object)data, Number[].class);
        } else if (type == 13) {
            data = TypeConverterManager.convertType((Object)data, Short.TYPE);
        } else if (type == 14) {
            data = TypeConverterManager.convertType((Object)data, short[].class);
        } else if (type == 16) {
            data = TypeConverterManager.convertType((Object)data, String[].class);
        }
        return (T)data;
    }

    protected ExpandoValue doAddValue(long companyId, long classNameId, long tableId, long columnId, long classPK, String data) {
        ExpandoValue value;
        ExpandoRow row = this.expandoRowPersistence.fetchByT_C(tableId, classPK);
        if (row == null) {
            long rowId = this.counterLocalService.increment();
            row = this.expandoRowPersistence.create(rowId);
            row.setCompanyId(companyId);
            row.setTableId(tableId);
            row.setClassPK(classPK);
            this.expandoRowPersistence.update((BaseModel)row);
        }
        if ((value = this.expandoValuePersistence.fetchByC_R(columnId, row.getRowId())) == null) {
            long valueId = this.counterLocalService.increment();
            value = this.expandoValuePersistence.create(valueId);
            value.setCompanyId(companyId);
            value.setTableId(tableId);
            value.setColumnId(columnId);
            value.setRowId(row.getRowId());
            value.setClassNameId(classNameId);
            value.setClassPK(classPK);
        }
        if (value.isNew() || !Objects.equals(value.getData(), data)) {
            value.setData(data);
            this.expandoValuePersistence.update((BaseModel)value);
            row.setModifiedDate(new Date());
            this.expandoRowPersistence.update((BaseModel)row);
        }
        return value;
    }

    protected Serializable doGetData(long companyId, String className, String tableName, String columnName, long classPK, ExpandoValue value, int type) throws PortalException {
        if (type == 1) {
            return Boolean.valueOf(this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, value.getBoolean()));
        }
        if (type == 2) {
            return this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, new boolean[0]);
        }
        if (type == 3) {
            return this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, value.getDate());
        }
        if (type == 4) {
            return this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, new Date[0]);
        }
        if (type == 5) {
            return Double.valueOf(this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, value.getDouble()));
        }
        if (type == 6) {
            return this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, new double[0]);
        }
        if (type == 7) {
            return Float.valueOf(this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, value.getFloat()));
        }
        if (type == 8) {
            return this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, new float[0]);
        }
        if (type == 21) {
            return this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, value.getGeolocationJSONObject());
        }
        if (type == 9) {
            return Integer.valueOf(this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, value.getInteger()));
        }
        if (type == 10) {
            return this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, new int[0]);
        }
        if (type == 11) {
            return Long.valueOf(this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, value.getLong()));
        }
        if (type == 12) {
            return this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, new long[0]);
        }
        if (type == 17) {
            return this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, value.getNumber());
        }
        if (type == 18) {
            return this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, new Number[0]);
        }
        if (type == 13) {
            return Short.valueOf(this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, value.getShort()));
        }
        if (type == 14) {
            return this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, new short[0]);
        }
        if (type == 16) {
            return this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, new String[0]);
        }
        if (type == 15) {
            return this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, value.getString());
        }
        return (Serializable)((Object)this.expandoValueLocalService.getData(companyId, className, tableName, columnName, classPK, new HashMap()));
    }

    protected Object handleCollections(int type, Object object) {
        if (!(object instanceof Collection) || !this.isTypeArray(type)) {
            return object;
        }
        Collection collection = (Collection)object;
        return collection.toArray();
    }

    protected Object handleStrings(int type, Object object) {
        if (!(object instanceof String)) {
            return object;
        }
        String string = (String)object;
        if (this.isTypeArray(type) && string.startsWith("[") && string.endsWith("]")) {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    protected boolean isTypeArray(int type) {
        return type == 2 || type == 4 || type == 6 || type == 8 || type == 10 || type == 12 || type == 18 || type == 14 || type == 16;
    }
}

