/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.model.impl;

import com.liferay.message.boards.kernel.model.MBCategory;
import com.liferay.message.boards.kernel.model.MBMessage;
import com.liferay.message.boards.kernel.model.MBMessageDisplay;
import com.liferay.message.boards.kernel.model.MBThread;
import com.liferay.message.boards.kernel.model.MBTreeWalker;
import com.liferay.message.boards.kernel.service.MBMessageLocalService;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.messageboards.model.impl.MBTreeWalkerImpl;
import java.util.Comparator;

public class MBMessageDisplayImpl
implements MBMessageDisplay {
    private final MBCategory _category;
    private final int _discussionMessagesCount;
    private final MBMessage _message;
    private final MBThread _nextThread;
    private final MBMessage _parentMessage;
    private final MBThread _previousThread;
    private final MBThread _thread;
    private final String _threadView;
    private final MBTreeWalker _treeWalker;

    public MBMessageDisplayImpl(long userId, MBMessage message, MBMessage parentMessage, MBCategory category, MBThread thread, int status, MBMessageLocalService messageLocalService, Comparator<MBMessage> comparator) {
        this._message = message;
        this._parentMessage = parentMessage;
        this._category = category;
        this._thread = thread;
        this._treeWalker = new MBTreeWalkerImpl(userId, message.getThreadId(), status, messageLocalService, comparator);
        this._previousThread = null;
        this._nextThread = null;
        this._threadView = "tree";
        int dicussionMessagesCount = 0;
        if (message.isDiscussion() && PropsValues.DISCUSSION_MAX_COMMENTS > 0) {
            dicussionMessagesCount = messageLocalService.getDiscussionMessagesCount(message.getClassName(), message.getClassPK(), 0);
        }
        this._discussionMessagesCount = dicussionMessagesCount;
    }

    @Deprecated
    public MBMessageDisplayImpl(MBMessage message, MBMessage parentMessage, MBCategory category, MBThread thread, int status, MBMessageLocalService messageLocalService, Comparator<MBMessage> comparator) {
        this(0L, message, parentMessage, category, thread, status, messageLocalService, comparator);
    }

    @Deprecated
    public MBMessageDisplayImpl(MBMessage message, MBMessage parentMessage, MBCategory category, MBThread thread, MBThread previousThread, MBThread nextThread, int status, String threadView, MBMessageLocalService messageLocalService, Comparator<MBMessage> comparator) {
        this._message = message;
        this._parentMessage = parentMessage;
        this._category = category;
        this._thread = thread;
        this._treeWalker = !threadView.equals("flat") ? new MBTreeWalkerImpl(message.getThreadId(), status, messageLocalService, comparator) : null;
        this._previousThread = previousThread;
        this._nextThread = nextThread;
        this._threadView = threadView;
        int dicussionMessagesCount = 0;
        if (message.isDiscussion() && PropsValues.DISCUSSION_MAX_COMMENTS > 0) {
            dicussionMessagesCount = messageLocalService.getDiscussionMessagesCount(message.getClassName(), message.getClassPK(), 0);
        }
        this._discussionMessagesCount = dicussionMessagesCount;
    }

    public MBCategory getCategory() {
        return this._category;
    }

    public MBMessage getMessage() {
        return this._message;
    }

    @Deprecated
    public MBThread getNextThread() {
        return this._nextThread;
    }

    public MBMessage getParentMessage() {
        return this._parentMessage;
    }

    @Deprecated
    public MBThread getPreviousThread() {
        return this._previousThread;
    }

    public MBThread getThread() {
        return this._thread;
    }

    @Deprecated
    public String getThreadView() {
        return this._threadView;
    }

    public MBTreeWalker getTreeWalker() {
        return this._treeWalker;
    }

    public boolean isDiscussionMaxComments() {
        return this._message.isDiscussion() && PropsValues.DISCUSSION_MAX_COMMENTS > 0 && PropsValues.DISCUSSION_MAX_COMMENTS <= this._discussionMessagesCount;
    }
}

