/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.util;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.message.boards.kernel.model.MBCategory;
import com.liferay.message.boards.kernel.model.MBDiscussion;
import com.liferay.message.boards.kernel.model.MBMessage;
import com.liferay.message.boards.kernel.service.MBCategoryLocalServiceUtil;
import com.liferay.message.boards.kernel.service.MBCategoryServiceUtil;
import com.liferay.message.boards.kernel.service.MBDiscussionLocalServiceUtil;
import com.liferay.message.boards.kernel.service.MBMessageLocalServiceUtil;
import com.liferay.portal.kernel.comment.Comment;
import com.liferay.portal.kernel.comment.CommentManagerUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.parsers.bbcode.BBCodeTranslatorUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BaseRelatedEntryIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelperUtil;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.RelatedEntryIndexer;
import com.liferay.portal.kernel.search.RelatedEntryIndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.messageboards.service.permission.MBMessagePermission;
import com.liferay.portlet.messageboards.util.MBMessageAttachmentsUtil;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;

@OSGiBeanProperties(property={"related.entry.indexer.class.name=com.liferay.message.boards.kernel.model.MBMessage"})
public class MBMessageIndexer
extends BaseIndexer<MBMessage>
implements RelatedEntryIndexer {
    public static final String CLASS_NAME = MBMessage.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(MBMessageIndexer.class);
    private final RelatedEntryIndexer _relatedEntryIndexer = new BaseRelatedEntryIndexer();

    public MBMessageIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"assetTagNames", "classNameId", "classPK", "companyId", "content", "entryClassName", "entryClassPK", "groupId", "modified", "scopeGroupId", "title", "uid"});
        this.setFilterSearch(true);
        this.setPermissionAware(true);
    }

    public void addRelatedClassNames(BooleanFilter contextFilter, SearchContext searchContext) throws Exception {
        this._relatedEntryIndexer.addRelatedClassNames(contextFilter, searchContext);
    }

    public void addRelatedEntryFields(Document document, Object obj) throws Exception {
        FileEntry fileEntry = (FileEntry)obj;
        MBMessage message = MBMessageAttachmentsUtil.fetchMessage(fileEntry.getFileEntryId());
        if (message == null) {
            return;
        }
        document.addKeyword("categoryId", message.getCategoryId());
        document.addKeyword("discussion", false);
        document.addKeyword("threadId", message.getThreadId());
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        MBMessage message = MBMessageLocalServiceUtil.getMessage((long)entryClassPK);
        if (message.isDiscussion()) {
            Indexer indexer = IndexerRegistryUtil.getIndexer((String)message.getClassName());
            return indexer.hasPermission(permissionChecker, message.getClassName(), message.getClassPK(), "VIEW");
        }
        return MBMessagePermission.contains(permissionChecker, entryClassPK, "VIEW");
    }

    public boolean isVisible(long classPK, int status) throws Exception {
        MBMessage message = MBMessageLocalServiceUtil.getMessage((long)classPK);
        return this.isVisible(message.getStatus(), status);
    }

    public boolean isVisibleRelatedEntry(long classPK, int status) {
        try {
            MBMessage message = MBMessageLocalServiceUtil.getMessage((long)classPK);
            if (message.isDiscussion()) {
                Indexer indexer = IndexerRegistryUtil.getIndexer((String)message.getClassName());
                return indexer.isVisible(message.getClassPK(), status);
            }
        }
        catch (Exception e) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Unable to get message boards message", (Throwable)e);
            }
            return false;
        }
        return true;
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        long[] categoryIds;
        long threadId;
        String classNameId;
        this.addStatus(contextBooleanFilter, searchContext);
        boolean discussion = GetterUtil.getBoolean((Object)searchContext.getAttribute("discussion"));
        contextBooleanFilter.addRequiredTerm("discussion", discussion);
        if (searchContext.isIncludeDiscussions()) {
            this.addRelatedClassNames(contextBooleanFilter, searchContext);
        }
        if (Validator.isNotNull((String)(classNameId = GetterUtil.getString((Object)searchContext.getAttribute("classNameId"))))) {
            contextBooleanFilter.addRequiredTerm("classNameId", classNameId);
        }
        if ((threadId = GetterUtil.getLong((String)((String)((Object)searchContext.getAttribute("threadId"))))) > 0L) {
            contextBooleanFilter.addRequiredTerm("threadId", threadId);
        }
        if ((categoryIds = searchContext.getCategoryIds()) != null && categoryIds.length > 0 && categoryIds[0] != 0L) {
            TermsFilter categoriesTermsFilter = new TermsFilter("categoryId");
            for (long categoryId : categoryIds) {
                try {
                    MBCategoryServiceUtil.getCategory((long)categoryId);
                }
                catch (PortalException pe) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Object)("Unable to get message boards category " + categoryId), (Throwable)pe);
                    continue;
                }
                categoriesTermsFilter.addValue(String.valueOf(categoryId));
            }
            if (!categoriesTermsFilter.isEmpty()) {
                contextBooleanFilter.add((Filter)categoriesTermsFilter, BooleanClauseOccur.MUST);
            }
        }
    }

    public void updateFullQuery(SearchContext searchContext) {
        if (searchContext.isIncludeDiscussions()) {
            searchContext.addFullQueryEntryClassName(MBMessage.class.getName());
            searchContext.setAttribute("discussion", (Serializable)Boolean.TRUE);
        }
    }

    protected void doDelete(MBMessage mbMessage) throws Exception {
        this.deleteDocument(mbMessage.getCompanyId(), mbMessage.getMessageId());
    }

    protected Document doGetDocument(MBMessage mbMessage) throws Exception {
        List relatedEntryIndexers;
        MBDiscussion discussion;
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)mbMessage);
        document.addKeyword("categoryId", mbMessage.getCategoryId());
        document.addText("content", this.processContent(mbMessage));
        document.addKeyword("rootEntryClassPK", mbMessage.getRootMessageId());
        document.addText("title", mbMessage.getSubject());
        if (mbMessage.isAnonymous()) {
            document.remove("userName");
        }
        if ((discussion = MBDiscussionLocalServiceUtil.fetchThreadDiscussion((long)mbMessage.getThreadId())) == null) {
            document.addKeyword("discussion", false);
        } else {
            document.addKeyword("discussion", true);
        }
        document.addKeyword("threadId", mbMessage.getThreadId());
        if (mbMessage.isDiscussion() && (relatedEntryIndexers = RelatedEntryIndexerRegistryUtil.getRelatedEntryIndexers((String)mbMessage.getClassName())) != null) {
            for (RelatedEntryIndexer relatedEntryIndexer : relatedEntryIndexers) {
                Comment comment = CommentManagerUtil.fetchComment((long)mbMessage.getMessageId());
                if (comment == null) continue;
                relatedEntryIndexer.addRelatedEntryFields(document, (Object)comment);
                document.addKeyword("relatedEntry", true);
            }
        }
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        Summary summary = this.createSummary(document, "title", "content");
        summary.setMaxContentLength(200);
        return summary;
    }

    protected void doReindex(MBMessage mbMessage) throws Exception {
        if (!mbMessage.isApproved() && !mbMessage.isInTrash() || mbMessage.isDiscussion() && mbMessage.isRoot()) {
            return;
        }
        Document document = this.getDocument(mbMessage);
        IndexWriterHelperUtil.updateDocument((String)this.getSearchEngineId(), (long)mbMessage.getCompanyId(), (Document)document, (boolean)this.isCommitImmediately());
        this.reindexAttachments(mbMessage);
    }

    protected void doReindex(String className, long classPK) throws Exception {
        MBMessage message = MBMessageLocalServiceUtil.getMessage((long)classPK);
        this.doReindex(message);
        if (message.isRoot()) {
            List messages = MBMessageLocalServiceUtil.getThreadMessages((long)message.getThreadId(), (int)0);
            for (MBMessage curMessage : messages) {
                this.reindex(curMessage);
            }
        } else {
            this.reindex(message);
        }
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexCategories(companyId);
        this.reindexDiscussions(companyId);
        this.reindexRoot(companyId);
    }

    protected String processContent(MBMessage message) {
        String content = message.getBody();
        try {
            if (message.isFormatBBCode()) {
                content = BBCodeTranslatorUtil.getHTML((String)content);
            }
        }
        catch (Exception e) {
            _log.error((Object)("Unable to parse message " + message.getMessageId() + ": " + e.getMessage()), (Throwable)e);
        }
        content = HtmlUtil.extractText((String)content);
        return content;
    }

    protected void reindexAttachments(MBMessage mbMessage) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(DLFileEntry.class);
        for (FileEntry attachmentsFileEntry : mbMessage.getAttachmentsFileEntries()) {
            indexer.reindex((Object)((DLFileEntry)attachmentsFileEntry.getModel()));
        }
    }

    protected void reindexCategories(final long companyId) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = MBCategoryLocalServiceUtil.getActionableDynamicQuery();
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<MBCategory>(){

            public void performAction(MBCategory category) throws PortalException {
                MBMessageIndexer.this.reindexMessages(companyId, category.getGroupId(), category.getCategoryId());
            }
        });
        actionableDynamicQuery.performActions();
    }

    protected void reindexDiscussions(final long companyId) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = GroupLocalServiceUtil.getActionableDynamicQuery();
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<Group>(){

            public void performAction(Group group) throws PortalException {
                MBMessageIndexer.this.reindexMessages(companyId, group.getGroupId(), -1L);
            }
        });
        actionableDynamicQuery.performActions();
    }

    protected void reindexMessages(long companyId, long groupId, final long categoryId) throws PortalException {
        final IndexableActionableDynamicQuery indexableActionableDynamicQuery = MBMessageLocalServiceUtil.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                Property categoryIdProperty = PropertyFactoryUtil.forName((String)"categoryId");
                dynamicQuery.add(categoryIdProperty.eq((Object)categoryId));
                Property statusProperty = PropertyFactoryUtil.forName((String)"status");
                Object[] statuses = new Integer[]{0, 8};
                dynamicQuery.add(statusProperty.in(statuses));
            }
        });
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setGroupId(groupId);
        indexableActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<MBMessage>(){

            public void performAction(MBMessage message) {
                block3: {
                    if (message.isDiscussion() && message.isRoot()) {
                        return;
                    }
                    try {
                        Document document = MBMessageIndexer.this.getDocument(message);
                        indexableActionableDynamicQuery.addDocuments(new Document[]{document});
                    }
                    catch (PortalException pe) {
                        if (!_log.isWarnEnabled()) break block3;
                        _log.warn((Object)("Unable to index message boards message " + message.getMessageId()), (Throwable)pe);
                    }
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }

    protected void reindexRoot(final long companyId) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = GroupLocalServiceUtil.getActionableDynamicQuery();
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<Group>(){

            public void performAction(Group group) throws PortalException {
                MBMessageIndexer.this.reindexMessages(companyId, group.getGroupId(), 0L);
            }
        });
        actionableDynamicQuery.performActions();
    }
}

