/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.BNDSourceUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BNDExportsCheck
extends BaseFileCheck {
    private final List<String> _allowedExportPackageDirNames = new ArrayList<String>();
    private final Pattern _apiOrServiceBundleSymbolicNamePattern = Pattern.compile("\\.(api|service)$");
    private final Pattern _exportContentsPattern = Pattern.compile("\n-exportcontents:(\\\\\n| )((.*?)(\n[^\t]|\\Z))", 40);
    private final Pattern _exportsPattern = Pattern.compile("\nExport-Package:(\\\\\n| )((.*?)(\n[^\t]|\\Z))", 40);

    @Override
    public boolean isModulesCheck() {
        return true;
    }

    public void setAllowedExportPackageDirName(String allowedExportPackageDirName) {
        this._allowedExportPackageDirNames.add(allowedExportPackageDirName);
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (!fileName.endsWith("/bnd.bnd") || absolutePath.contains("/third-party/")) {
            return content;
        }
        if (!absolutePath.contains("/testIntegration/")) {
            this._checkExports(fileName, content, this._exportContentsPattern, "-exportcontents");
            this._checkExports(fileName, content, this._exportsPattern, "Export-Package");
        }
        if (absolutePath.contains("/modules/apps/")) {
            this._checkExportPackage(fileName, absolutePath, content);
        }
        return content;
    }

    private void _checkExportPackage(String fileName, String absolutePath, String content) {
        for (String allowedExportPackageDirName : this._allowedExportPackageDirNames) {
            if (!absolutePath.contains(allowedExportPackageDirName)) continue;
            return;
        }
        if (fileName.endsWith("/test-bnd.bnd") || absolutePath.contains("-api/") || absolutePath.contains("-taglib/") || absolutePath.contains("-test-util/") || !content.contains("Export-Package")) {
            return;
        }
        int x = absolutePath.lastIndexOf("/");
        int y = absolutePath.lastIndexOf("/", x - 1);
        this.addMessage(fileName, "Exporting packages not allowed in module '" + absolutePath.substring(y + 1, x) + "'", "bnd_exports.markdown");
    }

    private void _checkExports(String fileName, String content, Pattern pattern, String definitionKey) {
        String bundleSymbolicName = BNDSourceUtil.getDefinitionValue(content, "Bundle-SymbolicName");
        if (bundleSymbolicName == null || bundleSymbolicName.endsWith(".compat")) {
            return;
        }
        Matcher matcher = this._apiOrServiceBundleSymbolicNamePattern.matcher(bundleSymbolicName);
        bundleSymbolicName = matcher.replaceAll("");
        matcher = pattern.matcher(content);
        if (!matcher.find()) {
            return;
        }
        String[] lines = StringUtil.splitLines(matcher.group(2));
        for (int i = 0; i < lines.length; ++i) {
            String line = StringUtil.removeChar(StringUtil.trim(lines[i]), '\\');
            if (Validator.isNull(line) || !line.startsWith("com.liferay.") || line.startsWith(bundleSymbolicName)) continue;
            StringBundler sb = new StringBundler(6);
            sb.append(definitionKey);
            sb.append(" '");
            sb.append(line);
            sb.append("' should match Bundle-SymbolicName '");
            sb.append(bundleSymbolicName);
            sb.append("'");
            this.addMessage(fileName, sb.toString(), this.getLineCount(content, matcher.start(2)) + i);
        }
    }
}

