/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.EmptyLinesCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaEmptyLinesCheck
extends EmptyLinesCheck {
    private final Pattern _redundantEmptyLinePattern = Pattern.compile("-> \\{\n\n[\t ]*(?!// )\\S");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        content = this.fixMissingEmptyLines(content);
        content = this.fixRedundantEmptyLines(content);
        content = this.fixIncorrectEmptyLineBeforeCloseCurlyBrace(content);
        content = this.fixMissingEmptyLineAfterSettingVariable(content);
        content = this._fixRedundantEmptyLineInLambdaExpression(content);
        content = this._fixIncorrectEmptyLineInsideStatement(content);
        return content;
    }

    private String _fixIncorrectEmptyLineInsideStatement(String content) {
        int x;
        String lineAfter;
        String lineBefore;
        String s;
        int previousPos;
        int pos = -1;
        do {
            previousPos = pos;
            if ((pos = content.indexOf("\n\n", pos + 1)) != -1) continue;
            return content;
        } while (previousPos == -1 || (s = content.substring(previousPos, pos)).endsWith("{") || this.getLevel(s) == 0 || this.getLevel(s, "{", "}") != 0 || (lineBefore = StringUtil.trim(this.getLine(content, this.getLineCount(content, previousPos)))).startsWith("//") || (lineAfter = StringUtil.trim(this.getLine(content, this.getLineCount(content, pos + 2)))).startsWith("//") || (x = s.lastIndexOf("{")) != -1 && this.getLevel(s.substring(x + 1), "{", "}") == 0);
        return StringUtil.replaceFirst(content, "\n\n", "\n", pos);
    }

    private String _fixRedundantEmptyLineInLambdaExpression(String content) {
        Matcher matcher = this._redundantEmptyLinePattern.matcher(content);
        if (matcher.find()) {
            return StringUtil.replaceFirst(content, "\n\n", "\n", matcher.start());
        }
        return content;
    }
}

