/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;

public class UnusedParameterCheck
extends BaseCheck {
    private static final String _MSG_UNUSED_PARAMETER = "parameter.unused";

    public int[] getDefaultTokens() {
        return new int[]{14};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST parentAST = detailAST.getParent();
        if (parentAST != null) {
            return;
        }
        List<DetailAST> constructorsAndMethodsASTList = DetailASTUtil.getAllChildTokens(detailAST, true, 8, 9);
        for (DetailAST constructorOrMethodAST : constructorsAndMethodsASTList) {
            this._checkUnusedParameters(detailAST, constructorOrMethodAST);
        }
    }

    private void _checkUnusedParameters(DetailAST classAST, DetailAST detailAST) {
        DetailAST modifiersAST = detailAST.findFirstToken(5);
        if (!modifiersAST.branchContains(61)) {
            return;
        }
        DetailAST nameAST = detailAST.findFirstToken(58);
        String name = nameAST.getText();
        if (name.equals("readObject") || name.equals("writeObject")) {
            return;
        }
        List<String> parameterNames = DetailASTUtil.getParameterNames(detailAST);
        if (parameterNames.isEmpty()) {
            return;
        }
        DetailAST statementsAST = detailAST.findFirstToken(7);
        List<DetailAST> allIdentsAST = DetailASTUtil.getAllChildTokens(statementsAST, true, 58);
        block0: for (String parameterName : DetailASTUtil.getParameterNames(detailAST)) {
            for (DetailAST identAST : allIdentsAST) {
                if (!parameterName.equals(identAST.getText())) continue;
                continue block0;
            }
            if (this._isReferencedMethod(classAST, detailAST)) continue;
            this.log(detailAST.getLineNo(), _MSG_UNUSED_PARAMETER, new Object[]{parameterName});
        }
    }

    private boolean _isReferencedMethod(DetailAST classAST, DetailAST detailAST) {
        List<DetailAST> methodReferenceASTList = DetailASTUtil.getAllChildTokens(classAST, true, 180);
        if (methodReferenceASTList.isEmpty()) {
            return false;
        }
        DetailAST nameAST = detailAST.findFirstToken(58);
        String name = nameAST.getText();
        for (DetailAST methodReferenceAST : methodReferenceASTList) {
            for (DetailAST identAST : DetailASTUtil.getAllChildTokens(methodReferenceAST, true, 58)) {
                if (!name.equals(identAST.getText())) continue;
                return true;
            }
        }
        return false;
    }
}

