/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.parser;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.JavaImportsFormatter;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import com.liferay.source.formatter.checks.util.SourceUtil;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaConstructor;
import com.liferay.source.formatter.parser.JavaMethod;
import com.liferay.source.formatter.parser.JavaStaticBlock;
import com.liferay.source.formatter.parser.JavaTerm;
import com.liferay.source.formatter.parser.JavaVariable;
import com.liferay.source.formatter.parser.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaClassParser {
    private static final Pattern _anonymousClassPattern = Pattern.compile("\n\t+(\\S.* )?new ((.|\\(\n)*\\)) \\{\n\n");

    public static List<JavaClass> parseAnonymousClasses(String content) throws Exception {
        ArrayList<JavaClass> anonymousClasses = new ArrayList<JavaClass>();
        Matcher matcher = _anonymousClassPattern.matcher(content);
        while (matcher.find()) {
            String classContent;
            String s = content.substring(matcher.start(2), matcher.end());
            if (JavaSourceUtil.getLevel(s) != 0) continue;
            int x = matcher.start() + 1;
            int y = matcher.end();
            while (JavaSourceUtil.getLevel(classContent = content.substring(x, y), "{", "}") != 0) {
                ++y;
            }
            anonymousClasses.add(JavaClassParser._parseJavaClass("", classContent, "private", false));
        }
        return anonymousClasses;
    }

    public static JavaClass parseJavaClass(String fileName, String content) throws Exception {
        String[] importLines;
        String className = JavaSourceUtil.getClassName(fileName);
        Pattern pattern = Pattern.compile("\n(public\\s+)?(abstract\\s+)?(final\\s+)?@?(class|enum|interface)\\s+" + className);
        Matcher matcher = pattern.matcher(content);
        if (!matcher.find()) {
            throw new ParseException("Parsing error");
        }
        int x = content.lastIndexOf("\n\n", matcher.start() + 1);
        String classContent = content.substring(x + 2);
        JavaClass javaClass = JavaClassParser._parseJavaClass(className, classContent, "public", false);
        javaClass.setPackageName(JavaSourceUtil.getPackageName(content));
        for (String importLine : importLines = StringUtil.splitLines(JavaImportsFormatter.getImports(content))) {
            if (!Validator.isNotNull(importLine)) continue;
            javaClass.addImport(importLine.substring(7, importLine.length() - 1));
        }
        return javaClass;
    }

    private static String _getClassName(String line) {
        int pos = line.indexOf(" extends ");
        if (pos == -1) {
            pos = line.indexOf(" implements ");
        }
        if (pos == -1) {
            pos = line.indexOf(123);
        }
        if (pos != -1) {
            line = line.substring(0, pos);
        }
        if ((pos = line.indexOf(60)) != -1) {
            line = line.substring(0, pos);
        }
        line = line.trim();
        pos = line.lastIndexOf(32);
        return line.substring(pos + 1);
    }

    private static String _getConstructorOrMethodName(String line, int pos) {
        line = line.substring(0, pos);
        int x = line.lastIndexOf(32);
        return line.substring(x + 1);
    }

    private static JavaTerm _getJavaTerm(String javaTermContent, String indent) throws Exception {
        Pattern pattern = Pattern.compile("(\n|^)" + indent + "(private|protected|public|static)[ \n].*?[{;]\n", 32);
        Matcher matcher = pattern.matcher(javaTermContent);
        if (!matcher.find()) {
            return null;
        }
        String s = javaTermContent.substring(matcher.end(1), matcher.end() - 1);
        s = StringUtil.replace(s, new String[]{"\t", "(\n", "\n", " synchronized "}, new String[]{"", "(", " ", " "});
        for (String accessModifier : JavaTerm.ACCESS_MODIFIERS) {
            JavaTerm javaTerm = JavaClassParser._getJavaTerm(javaTermContent, s, accessModifier);
            if (javaTerm == null) continue;
            return javaTerm;
        }
        return null;
    }

    private static JavaTerm _getJavaTerm(String javaTermContent, String startLine, String accessModifier) throws Exception {
        if (startLine.startsWith("static {")) {
            return new JavaStaticBlock(javaTermContent);
        }
        if (!startLine.startsWith(accessModifier)) {
            return null;
        }
        int x = startLine.indexOf(61);
        int y = startLine.indexOf(40);
        if (startLine.startsWith(accessModifier + " static ")) {
            if (startLine.contains(" class ") || startLine.contains(" enum ")) {
                return JavaClassParser._parseJavaClass(JavaClassParser._getClassName(startLine), javaTermContent, accessModifier, true);
            }
            if (x > 0 && (y == -1 || y > x) || startLine.endsWith(";") && y == -1) {
                return new JavaVariable(JavaClassParser._getVariableName(startLine), javaTermContent, accessModifier, true);
            }
            if (y != -1) {
                return new JavaMethod(JavaClassParser._getConstructorOrMethodName(startLine, y), javaTermContent, accessModifier, true);
            }
            return null;
        }
        if (startLine.contains(" @interface ") || startLine.contains(" class ") || startLine.contains(" enum ") || startLine.contains(" interface ")) {
            return JavaClassParser._parseJavaClass(JavaClassParser._getClassName(startLine), javaTermContent, accessModifier, false);
        }
        if (x > 0 && (y == -1 || y > x) || startLine.endsWith(";") && y == -1) {
            return new JavaVariable(JavaClassParser._getVariableName(startLine), javaTermContent, accessModifier, false);
        }
        if (y != -1) {
            int spaceCount = StringUtil.count(startLine.substring(0, y), ' ');
            if (spaceCount == 1) {
                return new JavaConstructor(JavaClassParser._getConstructorOrMethodName(startLine, y), javaTermContent, accessModifier, false);
            }
            if (spaceCount > 1) {
                return new JavaMethod(JavaClassParser._getConstructorOrMethodName(startLine, y), javaTermContent, accessModifier, false);
            }
        }
        return null;
    }

    private static int _getLineStartPos(String content, int lineCount) {
        int x = 0;
        for (int i = 1; i < lineCount; ++i) {
            if ((x = content.indexOf(10, x + 1)) != -1) continue;
            return x;
        }
        return x + 1;
    }

    private static String _getVariableName(String line) {
        int x = line.indexOf(61);
        int y = line.lastIndexOf(32);
        if (x != -1) {
            line = line.substring(0, x);
            line = StringUtil.trim(line);
            y = line.lastIndexOf(32);
            return line.substring(y + 1);
        }
        if (line.endsWith(";")) {
            return line.substring(y + 1, line.length() - 1);
        }
        return "";
    }

    private static JavaClass _parseJavaClass(String className, String classContent, String accessModifier, boolean isStatic) throws Exception {
        JavaClass javaClass = new JavaClass(className, classContent, accessModifier, isStatic);
        String indent = SourceUtil.getIndent(classContent) + "\t";
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(classContent));
        String line = null;
        int javaTermStartPos = -1;
        int level = 0;
        int lineCount = 0;
        int metadataAnnotationLevel = 0;
        int metadataBlockCommentLevel = 0;
        boolean insideJavaTerm = false;
        boolean insideMetadataAnnotation = false;
        boolean insideMetadataBlockComment = false;
        boolean multiLineComment = false;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            ++lineCount;
            if (!insideJavaTerm && line.startsWith(indent + "@")) {
                insideMetadataAnnotation = true;
                metadataAnnotationLevel = SourceUtil.getLevel(line);
            } else if (insideMetadataAnnotation) {
                if (metadataAnnotationLevel == 0 && Validator.isNotNull(line)) {
                    insideMetadataAnnotation = false;
                }
                metadataAnnotationLevel += SourceUtil.getLevel(line);
            }
            if (!insideJavaTerm && line.startsWith(indent + "/*")) {
                insideMetadataBlockComment = true;
                metadataBlockCommentLevel = SourceUtil.getLevel(line, "/*", "*/");
            } else if (insideMetadataBlockComment) {
                if (metadataBlockCommentLevel == 0 && Validator.isNotNull(line)) {
                    insideMetadataBlockComment = false;
                }
                metadataBlockCommentLevel += SourceUtil.getLevel(line, "/*", "*/");
            }
            if (!insideJavaTerm) {
                if (javaTermStartPos == -1) {
                    if (line.matches(indent + "\\S+.*")) {
                        javaTermStartPos = JavaClassParser._getLineStartPos(classContent, lineCount);
                    }
                } else if (Validator.isNull(line) && !insideMetadataAnnotation && !insideMetadataBlockComment) {
                    javaTermStartPos = -1;
                }
            }
            if (line.matches("\\s*//.*")) continue;
            if (multiLineComment) {
                if (!line.matches(".*\\*/")) continue;
                multiLineComment = false;
                continue;
            }
            if (line.matches("\\s*/\\*.*")) {
                multiLineComment = true;
                continue;
            }
            level += SourceUtil.getLevel(line, "{", "}");
            if (line.matches(indent + "((private|protected|public)( .*|$)|static \\{)")) {
                insideJavaTerm = true;
                insideMetadataAnnotation = false;
                insideMetadataBlockComment = false;
            }
            if (!insideJavaTerm || !line.matches(".*[};]") || level != 1) continue;
            int nextLineStartPos = JavaClassParser._getLineStartPos(classContent, lineCount + 1);
            String javaTermContent = classContent.substring(javaTermStartPos, nextLineStartPos);
            JavaTerm javaTerm = JavaClassParser._getJavaTerm(javaTermContent, indent);
            if (javaTerm == null) {
                throw new ParseException("Parsing error at line '" + StringUtil.trim(line) + "'");
            }
            javaClass.addChildJavaTerm(javaTerm);
            insideJavaTerm = false;
            insideMetadataAnnotation = false;
            insideMetadataBlockComment = false;
            javaTermStartPos = nextLineStartPos;
        }
        return javaClass;
    }
}

