/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GradleVersionCheck
extends BaseFileCheck {
    private final Pattern _defaultVersionPattern = Pattern.compile("name: \"(.*?)\", version: \"default\"");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        this._checkDefaultVersion(fileName, content);
        return content;
    }

    private void _checkDefaultVersion(String fileName, String content) {
        Matcher matcher = this._defaultVersionPattern.matcher(content);
        while (matcher.find()) {
            String name = matcher.group(1);
            if (name.equals("com.liferay.portal.impl") || name.equals("com.liferay.portal.kernel") || name.equals("com.liferay.util.bridges") || name.equals("com.liferay.util.taglib")) continue;
            this.addMessage(fileName, "Do not use 'default' version for '" + name + "'", "gradle_versioning.markdown", this.getLineCount(content, matcher.start()));
        }
    }
}

