/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.Element;

public class JavaFinderImplCustomSQLCheck
extends BaseFileCheck {
    private Document _portalCustomSQLDocument;
    private final Pattern _stringUtilReplacePattern = Pattern.compile("sql = StringUtil.replace\\(.*?\\);\n", 32);

    @Override
    public void init() throws Exception {
        this._portalCustomSQLDocument = this.getPortalCustomSQLDocument();
    }

    @Override
    public boolean isPortalCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (fileName.endsWith("FinderImpl.java")) {
            this._checkCustomSQL(fileName, absolutePath, content);
        }
        return content;
    }

    private void _checkCustomSQL(String fileName, String absolutePath, String content) throws Exception {
        Document customSQLDocument = null;
        String finderName = null;
        Matcher matcher = this._stringUtilReplacePattern.matcher(content);
        block0: while (matcher.find()) {
            String replaceSQLValue;
            List<String> parameterList = JavaSourceUtil.getParameterList(matcher.group());
            if (parameterList.size() != 3 || (replaceSQLValue = this._getReplaceSQLValue(content, parameterList.get(1))) == null) continue;
            if (finderName == null) {
                String className = JavaSourceUtil.getClassName(fileName);
                finderName = className.substring(0, className.length() - 4);
                customSQLDocument = this.getCustomSQLDocument(fileName, absolutePath, this._portalCustomSQLDocument);
            }
            if (customSQLDocument == null) {
                return;
            }
            Element rootElement = customSQLDocument.getRootElement();
            for (Element sqlElement : rootElement.elements("sql")) {
                String sql;
                String id = sqlElement.attributeValue("id");
                if (!id.contains(finderName) || !(sql = this._transform(sqlElement.getText())).contains(replaceSQLValue)) continue;
                continue block0;
            }
            this.addMessage(fileName, StringBundler.concat("SQL '", replaceSQLValue, "' does not exist in the custom-sql file"), this.getLineCount(content, matcher.start()));
        }
    }

    private String _getReplaceSQLValue(String content, String parameterValue) {
        Pattern pattern;
        Matcher matcher;
        if (parameterValue.matches("[A-Z_]+") && (matcher = (pattern = Pattern.compile("final String\\s+" + parameterValue + "\\s+=\\s+(.*?);\n", 32)).matcher(content)).find()) {
            parameterValue = matcher.group(1);
        }
        if (!parameterValue.matches("(?s)\".* .*\"")) {
            return null;
        }
        parameterValue = parameterValue.substring(1, parameterValue.length() - 1);
        return parameterValue.replaceAll("\"\\s+\\+\\s+\"", "");
    }

    private String _transform(String sql) {
        String[] lines;
        StringBundler sb = new StringBundler();
        for (String line : lines = StringUtil.splitLines(sql)) {
            if ((line = line.trim()).startsWith(")")) {
                sb.setIndex(sb.index() - 1);
            }
            sb.append(line);
            if (line.endsWith("(")) continue;
            sb.append(" ");
        }
        return sb.toString();
    }
}

