/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SourceChecksSuppressions {
    private final Map<String, Map<String, List<String>>> _suppressionsMap = new HashMap<String, Map<String, List<String>>>();

    public void addSuppression(String suppressionsFileLocation, String sourceCheckName, String fileName) {
        List<String> fileNames;
        Map<String, List<String>> sourceCheckSuppressionsMap = this._suppressionsMap.get(sourceCheckName);
        if (sourceCheckSuppressionsMap == null) {
            sourceCheckSuppressionsMap = new HashMap<String, List<String>>();
        }
        if ((fileNames = sourceCheckSuppressionsMap.get(suppressionsFileLocation)) == null) {
            fileNames = new ArrayList<String>();
        }
        fileNames.add(fileName);
        sourceCheckSuppressionsMap.put(suppressionsFileLocation, fileNames);
        this._suppressionsMap.put(sourceCheckName, sourceCheckSuppressionsMap);
    }

    public boolean isSuppressed(String sourceCheckName, String absolutePath) {
        Map<String, List<String>> sourceCheckSuppressionsMap = this._suppressionsMap.get(sourceCheckName);
        if (sourceCheckSuppressionsMap == null) {
            return false;
        }
        for (Map.Entry<String, List<String>> entry : sourceCheckSuppressionsMap.entrySet()) {
            String suppressionsFileLocation = entry.getKey();
            if (!absolutePath.startsWith(suppressionsFileLocation)) continue;
            List<String> fileNames = entry.getValue();
            for (String fileName : fileNames) {
                if (!absolutePath.matches(".*" + fileName)) continue;
                return true;
            }
        }
        return false;
    }
}

