/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.message.boards.kernel.util.comparator;

import com.liferay.message.boards.kernel.model.MBThread;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.OrderByComparator;

public class ThreadLastPostDateComparator
extends OrderByComparator<MBThread> {
    public static final String ORDER_BY_ASC = "MBThread.lastPostDate ASC, MBThread.threadId ASC";
    public static final String[] ORDER_BY_CONDITION_FIELDS = new String[]{"lastPostDate"};
    public static final String ORDER_BY_DESC = "MBThread.lastPostDate DESC, MBThread.threadId DESC";
    public static final String[] ORDER_BY_FIELDS = new String[]{"lastPostDate", "threadId"};
    private final boolean _ascending;

    public ThreadLastPostDateComparator() {
        this(false);
    }

    public ThreadLastPostDateComparator(boolean ascending) {
        this._ascending = ascending;
    }

    @Override
    public int compare(MBThread thread1, MBThread thread2) {
        int value = DateUtil.compareTo(thread1.getLastPostDate(), thread2.getLastPostDate());
        if (value == 0) {
            if (thread1.getThreadId() < thread2.getThreadId()) {
                value = -1;
            } else if (thread1.getThreadId() > thread2.getThreadId()) {
                value = 1;
            }
        }
        if (this._ascending) {
            return value;
        }
        return -value;
    }

    @Override
    public String getOrderBy() {
        if (this._ascending) {
            return ORDER_BY_ASC;
        }
        return ORDER_BY_DESC;
    }

    @Override
    public String[] getOrderByConditionFields() {
        return ORDER_BY_CONDITION_FIELDS;
    }

    @Override
    public String[] getOrderByFields() {
        return ORDER_BY_FIELDS;
    }

    @Override
    public boolean isAscending() {
        return this._ascending;
    }
}

