/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.model.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutType;
import com.liferay.portal.kernel.model.LayoutWrapper;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.LayoutTypePortletFactoryUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;

public class VirtualLayout
extends LayoutWrapper {
    private static final String _LAYOUT_FRIENDLY_URL_PRIVATE_GROUP_SERVLET_MAPPING = PropsUtil.get("layout.friendly.url.private.group.servlet.mapping");
    private static final String _LAYOUT_FRIENDLY_URL_PRIVATE_USER_SERVLET_MAPPING = PropsUtil.get("layout.friendly.url.private.user.servlet.mapping");
    private static final Log _log = LogFactoryUtil.getLog(VirtualLayout.class);
    private LayoutSet _layoutSet;
    private LayoutType _layoutType;
    private final Layout _sourceLayout;
    private final Group _targetGroup;

    public VirtualLayout(Layout sourceLayout, Group targetGroup) {
        super(sourceLayout);
        this._sourceLayout = sourceLayout;
        this._targetGroup = targetGroup;
    }

    @Override
    public Object clone() {
        return new VirtualLayout((Layout)this._sourceLayout.clone(), this._targetGroup);
    }

    @Override
    public List<Portlet> getEmbeddedPortlets() {
        return super.getEmbeddedPortlets(this.getGroupId());
    }

    @Override
    public String getFriendlyURL() {
        return this.getFriendlyURL(null);
    }

    @Override
    public String getFriendlyURL(Locale locale) {
        StringBundler sb = new StringBundler(3);
        sb.append("/~");
        try {
            Group group = this._sourceLayout.getGroup();
            sb.append(group.getFriendlyURL());
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        if (locale == null) {
            sb.append(this._sourceLayout.getFriendlyURL());
        } else {
            sb.append(this._sourceLayout.getFriendlyURL(locale));
        }
        return sb.toString();
    }

    @Override
    public Group getGroup() {
        return this.getHostGroup();
    }

    @Override
    public long getGroupId() {
        return this.getVirtualGroupId();
    }

    public Group getHostGroup() {
        return this._targetGroup;
    }

    @Override
    public LayoutSet getLayoutSet() {
        if (this._layoutSet == null) {
            this._layoutSet = this.isPrivateLayout() ? this._targetGroup.getPrivateLayoutSet() : this._targetGroup.getPublicLayoutSet();
        }
        return this._layoutSet;
    }

    @Override
    public LayoutType getLayoutType() {
        if (this._layoutType == null) {
            this._layoutType = LayoutTypePortletFactoryUtil.create(this);
        }
        return this._layoutType;
    }

    @Override
    public String getRegularURL(HttpServletRequest request) throws PortalException {
        String layoutURL = this._sourceLayout.getRegularURL(request);
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return this.injectVirtualGroupURL(layoutURL, themeDisplay.getLocale());
    }

    @Override
    public String getResetLayoutURL(HttpServletRequest request) throws PortalException {
        String layoutURL = this._sourceLayout.getResetLayoutURL(request);
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return this.injectVirtualGroupURL(layoutURL, themeDisplay.getLocale());
    }

    @Override
    public String getResetMaxStateURL(HttpServletRequest request) throws PortalException {
        String layoutURL = this._sourceLayout.getResetMaxStateURL(request);
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return this.injectVirtualGroupURL(layoutURL, themeDisplay.getLocale());
    }

    public long getSourceGroupId() {
        return this._sourceLayout.getGroupId();
    }

    public Layout getSourceLayout() {
        return this._sourceLayout;
    }

    public long getVirtualGroupId() {
        return this._targetGroup.getGroupId();
    }

    @Override
    public void setLayoutSet(LayoutSet layoutSet) {
        super.setLayoutSet(layoutSet);
        this._layoutSet = null;
    }

    @Override
    public void setPrivateLayout(boolean privateLayout) {
        super.setPrivateLayout(privateLayout);
        this._layoutSet = null;
    }

    protected String injectVirtualGroupURL(String layoutURL, Locale locale) {
        if (this._sourceLayout.isTypeURL()) {
            return layoutURL;
        }
        try {
            Group group = this._sourceLayout.getGroup();
            StringBundler sb = new StringBundler(4);
            if (this._targetGroup.isUser() && this.isPrivateLayout()) {
                layoutURL = layoutURL.replaceFirst(_LAYOUT_FRIENDLY_URL_PRIVATE_GROUP_SERVLET_MAPPING, _LAYOUT_FRIENDLY_URL_PRIVATE_USER_SERVLET_MAPPING);
            }
            int pos = layoutURL.indexOf(group.getFriendlyURL());
            sb.append(layoutURL.substring(0, pos));
            sb.append(this._targetGroup.getFriendlyURL());
            sb.append(this.getFriendlyURL(locale));
            pos = layoutURL.indexOf("?");
            if (pos > 0) {
                sb.append(layoutURL.substring(pos));
            }
            return sb.toString();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

