/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search.suggest;

import com.liferay.portal.kernel.util.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

public class KeywordsSuggestionHolder {
    private static final String _KEYWORDS_DELIMETER_REGEXP = "[ ]+";
    private final List<String> _originalKeywords;
    private final List<String> _suggestedKeywords;

    public KeywordsSuggestionHolder(String suggestedKeywords, String originalKeywords) {
        this(suggestedKeywords, originalKeywords, _KEYWORDS_DELIMETER_REGEXP);
    }

    public KeywordsSuggestionHolder(String suggestedKeywords, String originalKeywords, String keywordsDelimiterRegexp) {
        Pattern keywordsDelimiterRegexpPattern = Pattern.compile(keywordsDelimiterRegexp);
        this._suggestedKeywords = Validator.isNull(suggestedKeywords) ? Collections.emptyList() : Arrays.asList(keywordsDelimiterRegexpPattern.split(suggestedKeywords));
        this._originalKeywords = Validator.isNull(originalKeywords) ? Collections.emptyList() : Arrays.asList(keywordsDelimiterRegexpPattern.split(originalKeywords));
    }

    public List<String> getSuggestedKeywords() {
        return this._suggestedKeywords;
    }

    public boolean hasChanged(String suggestedKeyword) {
        return !this._originalKeywords.contains(suggestedKeyword);
    }
}

