/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.servlet;

import com.liferay.portal.kernel.servlet.PersistentHttpServletRequestWrapper;
import com.liferay.portal.kernel.servlet.ProtectedPrincipal;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;

public class ProtectedServletRequest
extends PersistentHttpServletRequestWrapper {
    private final String _authType;
    private final String _remoteUser;
    private final Principal _userPrincipal;

    public ProtectedServletRequest(HttpServletRequest request, String remoteUser) {
        this(request, remoteUser, null);
    }

    public ProtectedServletRequest(HttpServletRequest request, String remoteUser, String authType) {
        super(request);
        if (remoteUser == null) {
            throw new NullPointerException("Remote user is null");
        }
        if (request instanceof ProtectedServletRequest) {
            ProtectedServletRequest parentRequest = (ProtectedServletRequest)request;
            this.setRequest(parentRequest.getRequest());
        }
        this._remoteUser = remoteUser;
        this._authType = authType;
        this._userPrincipal = new ProtectedPrincipal(remoteUser);
    }

    public String getAuthType() {
        if (this._authType == null) {
            return super.getAuthType();
        }
        return this._authType;
    }

    public String getRemoteUser() {
        return this._remoteUser;
    }

    public Principal getUserPrincipal() {
        return this._userPrincipal;
    }
}

