/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.LayoutSetBranch;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.LayoutSetBranchPermissionUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.service.base.LayoutSetBranchServiceBaseImpl;
import java.util.ArrayList;
import java.util.List;

public class LayoutSetBranchServiceImpl
extends LayoutSetBranchServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(LayoutSetBranchServiceImpl.class);

    public LayoutSetBranch addLayoutSetBranch(long groupId, boolean privateLayout, String name, String description, boolean master, long copyLayoutSetBranchId, ServiceContext serviceContext) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"ADD_LAYOUT_SET_BRANCH");
        return this.layoutSetBranchLocalService.addLayoutSetBranch(this.getUserId(), groupId, privateLayout, name, description, master, copyLayoutSetBranchId, serviceContext);
    }

    public void deleteLayoutSetBranch(long layoutSetBranchId) throws PortalException {
        LayoutSetBranchPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)layoutSetBranchId, (String)"DELETE");
        this.layoutSetBranchLocalService.deleteLayoutSetBranch(layoutSetBranchId);
    }

    public List<LayoutSetBranch> getLayoutSetBranches(long groupId, boolean privateLayout) {
        block3: {
            try {
                if (GroupPermissionUtil.contains((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"VIEW_STAGING")) {
                    return this.layoutSetBranchLocalService.getLayoutSetBranches(groupId, privateLayout);
                }
            }
            catch (PortalException pe) {
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Unable to get layout set branches for group ", String.valueOf(groupId), " with ", String.valueOf(privateLayout ? "private" : "public"), " layouts"}), (Throwable)pe);
            }
        }
        return new ArrayList<LayoutSetBranch>();
    }

    public LayoutSetBranch mergeLayoutSetBranch(long layoutSetBranchId, long mergeLayoutSetBranchId, ServiceContext serviceContext) throws PortalException {
        LayoutSetBranchPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)layoutSetBranchId, (String)"UPDATE");
        return this.layoutSetBranchLocalService.mergeLayoutSetBranch(layoutSetBranchId, mergeLayoutSetBranchId, serviceContext);
    }

    public LayoutSetBranch updateLayoutSetBranch(long groupId, long layoutSetBranchId, String name, String description, ServiceContext serviceContext) throws PortalException {
        LayoutSetBranchPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)layoutSetBranchId, (String)"UPDATE");
        return this.layoutSetBranchLocalService.updateLayoutSetBranch(layoutSetBranchId, name, description, serviceContext);
    }
}

