/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.exportimport.kernel.staging.LayoutStagingUtil;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.exception.LayoutSetVirtualHostException;
import com.liferay.portal.kernel.exception.NoSuchImageException;
import com.liferay.portal.kernel.exception.NoSuchVirtualHostException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutSetBranch;
import com.liferay.portal.kernel.model.LayoutSetStagingHandler;
import com.liferay.portal.kernel.model.VirtualHost;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.ColorSchemeFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.ThemeFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.impl.LayoutSetImpl;
import com.liferay.portal.model.impl.LayoutSetModelImpl;
import com.liferay.portal.service.base.LayoutSetLocalServiceBaseImpl;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;

public class LayoutSetLocalServiceImpl
extends LayoutSetLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(LayoutSetLocalServiceImpl.class);

    public LayoutSet addLayoutSet(long groupId, boolean privateLayout) throws PortalException {
        Group group = this.groupPersistence.findByPrimaryKey(groupId);
        Date now = new Date();
        long layoutSetId = this.counterLocalService.increment();
        LayoutSet layoutSet = this.layoutSetPersistence.create(layoutSetId);
        layoutSet.setGroupId(groupId);
        layoutSet.setCompanyId(group.getCompanyId());
        layoutSet.setCreateDate(now);
        layoutSet.setModifiedDate(now);
        layoutSet.setPrivateLayout(privateLayout);
        layoutSet = this.initLayoutSet(layoutSet);
        this.layoutSetPersistence.update((BaseModel)layoutSet);
        return layoutSet;
    }

    public void deleteLayoutSet(long groupId, boolean privateLayout, ServiceContext serviceContext) throws PortalException {
        block8: {
            LayoutSet layoutSet;
            Group group;
            block7: {
                group = this.groupPersistence.findByPrimaryKey(groupId);
                layoutSet = this.layoutSetPersistence.findByG_P(groupId, privateLayout);
                serviceContext.setAttribute("updatePageCount", (Serializable)Boolean.FALSE);
                this.layoutLocalService.deleteLayouts(groupId, privateLayout, serviceContext);
                if (group.isStagingGroup() || !group.isOrganization() || !group.isSite()) {
                    try {
                        this.imageLocalService.deleteImage(layoutSet.getLogoId());
                    }
                    catch (NoSuchImageException nsie) {
                        if (!_log.isWarnEnabled()) break block7;
                        _log.warn((Object)("Unable to delete image " + layoutSet.getLogoId()), (Throwable)nsie);
                    }
                }
            }
            if (!group.isStagingGroup() && group.isOrganization() && group.isSite()) {
                layoutSet = this.initLayoutSet(layoutSet);
                layoutSet.setLogoId(layoutSet.getLogoId());
                this.layoutSetPersistence.update((BaseModel)layoutSet);
            } else {
                this.layoutSetPersistence.removeByG_P(groupId, privateLayout);
            }
            try {
                this.virtualHostPersistence.removeByC_L(layoutSet.getCompanyId(), layoutSet.getLayoutSetId());
            }
            catch (NoSuchVirtualHostException nsvhe) {
                if (!_log.isDebugEnabled()) break block8;
                _log.debug((Object)nsvhe, (Throwable)nsvhe);
            }
        }
    }

    public LayoutSet fetchLayoutSet(long groupId, boolean privateLayout) {
        return this.layoutSetPersistence.fetchByG_P(groupId, privateLayout);
    }

    public LayoutSet fetchLayoutSet(String virtualHostname) {
        VirtualHost virtualHost = this.virtualHostPersistence.fetchByHostname(virtualHostname = StringUtil.toLowerCase((String)StringUtil.trim((String)virtualHostname)));
        if (virtualHost == null || virtualHost.getLayoutSetId() == 0L) {
            return null;
        }
        return this.layoutSetPersistence.fetchByPrimaryKey(virtualHost.getLayoutSetId());
    }

    public LayoutSet fetchLayoutSetByLogoId(boolean privateLayout, long logoId) throws PortalException {
        return this.layoutSetPersistence.fetchByP_L(privateLayout, logoId);
    }

    public LayoutSet getLayoutSet(long groupId, boolean privateLayout) throws PortalException {
        return this.layoutSetPersistence.findByG_P(groupId, privateLayout);
    }

    public LayoutSet getLayoutSet(String virtualHostname) throws PortalException {
        VirtualHost virtualHost = this.virtualHostPersistence.findByHostname(virtualHostname = StringUtil.toLowerCase((String)StringUtil.trim((String)virtualHostname)));
        if (virtualHost.getLayoutSetId() == 0L) {
            throw new LayoutSetVirtualHostException("Virtual host is associated with company " + virtualHost.getCompanyId());
        }
        return this.layoutSetPersistence.findByPrimaryKey(virtualHost.getLayoutSetId());
    }

    public List<LayoutSet> getLayoutSetsByLayoutSetPrototypeUuid(String layoutSetPrototypeUuid) {
        return this.layoutSetPersistence.findByLayoutSetPrototypeUuid(layoutSetPrototypeUuid);
    }

    public void updateLayoutSetPrototypeLinkEnabled(long groupId, boolean privateLayout, boolean layoutSetPrototypeLinkEnabled, String layoutSetPrototypeUuid) throws PortalException {
        LayoutSet layoutSet = this.layoutSetPersistence.findByG_P(groupId, privateLayout);
        LayoutSetBranch layoutSetBranch = this._getLayoutSetBranch(layoutSet);
        if (layoutSetBranch == null) {
            if (Validator.isNull((String)layoutSetPrototypeUuid)) {
                layoutSetPrototypeUuid = layoutSet.getLayoutSetPrototypeUuid();
            }
            if (Validator.isNull((String)layoutSetPrototypeUuid)) {
                layoutSetPrototypeLinkEnabled = false;
            }
            layoutSet.setLayoutSetPrototypeLinkEnabled(layoutSetPrototypeLinkEnabled);
            layoutSet.setLayoutSetPrototypeUuid(layoutSetPrototypeUuid);
            this.layoutSetPersistence.update((BaseModel)layoutSet);
            return;
        }
        if (Validator.isNull((String)layoutSetPrototypeUuid)) {
            layoutSetPrototypeUuid = layoutSetBranch.getLayoutSetPrototypeUuid();
        }
        if (Validator.isNull((String)layoutSetPrototypeUuid) && layoutSetPrototypeLinkEnabled) {
            throw new IllegalStateException("Cannot set layoutSetPrototypeLinkEnabled to true when layoutSetPrototypeUuid is null");
        }
        layoutSetBranch.setLayoutSetPrototypeLinkEnabled(layoutSetPrototypeLinkEnabled);
        layoutSetBranch.setLayoutSetPrototypeUuid(layoutSetPrototypeUuid);
        this.layoutSetBranchPersistence.update((BaseModel)layoutSetBranch);
    }

    public LayoutSet updateLogo(long groupId, boolean privateLayout, boolean logo, byte[] bytes) throws PortalException {
        LayoutSet layoutSet = this.layoutSetPersistence.findByG_P(groupId, privateLayout);
        LayoutSetBranch layoutSetBranch = this._getLayoutSetBranch(layoutSet);
        if (layoutSetBranch == null) {
            layoutSet.setModifiedDate(new Date());
            PortalUtil.updateImageId((BaseModel)layoutSet, (boolean)logo, (byte[])bytes, (String)"logoId", (long)0L, (int)0, (int)0);
            return (LayoutSet)this.layoutSetPersistence.update((BaseModel)layoutSet);
        }
        layoutSetBranch.setModifiedDate(new Date());
        PortalUtil.updateImageId((BaseModel)layoutSetBranch, (boolean)logo, (byte[])bytes, (String)"logoId", (long)0L, (int)0, (int)0);
        this.layoutSetBranchPersistence.update((BaseModel)layoutSetBranch);
        return layoutSet;
    }

    public LayoutSet updateLogo(long groupId, boolean privateLayout, boolean logo, File file) throws PortalException {
        byte[] bytes = null;
        try {
            bytes = FileUtil.getBytes((File)file);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        return this.updateLogo(groupId, privateLayout, logo, bytes);
    }

    public LayoutSet updateLogo(long groupId, boolean privateLayout, boolean logo, InputStream is) throws PortalException {
        return this.updateLogo(groupId, privateLayout, logo, is, true);
    }

    public LayoutSet updateLogo(long groupId, boolean privateLayout, boolean logo, InputStream is, boolean cleanUpStream) throws PortalException {
        byte[] bytes = null;
        try {
            bytes = FileUtil.getBytes((InputStream)is, (int)-1, (boolean)cleanUpStream);
        }
        catch (IOException ioe) {
            throw new SystemException((Throwable)ioe);
        }
        return this.updateLogo(groupId, privateLayout, logo, bytes);
    }

    public LayoutSet updateLookAndFeel(long groupId, boolean privateLayout, String themeId, String colorSchemeId, String css) throws PortalException {
        LayoutSetBranch layoutSetBranch;
        LayoutSet layoutSet = this.layoutSetPersistence.findByG_P(groupId, privateLayout);
        if (Validator.isNull((String)themeId)) {
            themeId = ThemeFactoryUtil.getDefaultRegularThemeId((long)layoutSet.getCompanyId());
        }
        if (Validator.isNull((String)colorSchemeId)) {
            colorSchemeId = ColorSchemeFactoryUtil.getDefaultRegularColorSchemeId();
        }
        if ((layoutSetBranch = this._getLayoutSetBranch(layoutSet)) == null) {
            layoutSet.setColorSchemeId(colorSchemeId);
            layoutSet.setCss(css);
            layoutSet.setModifiedDate(new Date());
            layoutSet.setThemeId(themeId);
            this.layoutSetPersistence.update((BaseModel)layoutSet);
            if (PrefsPropsUtil.getBoolean("theme.sync.on.group", PropsValues.THEME_SYNC_ON_GROUP)) {
                LayoutSet otherLayoutSet = this.layoutSetPersistence.findByG_P(layoutSet.getGroupId(), layoutSet.isPrivateLayout());
                otherLayoutSet.setThemeId(themeId);
                otherLayoutSet.setColorSchemeId(colorSchemeId);
                this.layoutSetPersistence.update((BaseModel)otherLayoutSet);
            }
            return layoutSet;
        }
        layoutSetBranch.setColorSchemeId(colorSchemeId);
        layoutSetBranch.setCss(css);
        layoutSetBranch.setModifiedDate(new Date());
        layoutSetBranch.setThemeId(themeId);
        this.layoutSetBranchPersistence.update((BaseModel)layoutSetBranch);
        return layoutSet;
    }

    public void updateLookAndFeel(long groupId, String themeId, String colorSchemeId, String css) throws PortalException {
        this.updateLookAndFeel(groupId, false, themeId, colorSchemeId, css);
        this.updateLookAndFeel(groupId, true, themeId, colorSchemeId, css);
    }

    public LayoutSet updatePageCount(long groupId, boolean privateLayout) throws PortalException {
        int pageCount = this.layoutPersistence.countByG_P(groupId, privateLayout);
        LayoutSet layoutSet = this.layoutSetPersistence.findByG_P(groupId, privateLayout);
        layoutSet.setModifiedDate(new Date());
        layoutSet.setPageCount(pageCount);
        this.layoutSetPersistence.update((BaseModel)layoutSet);
        return layoutSet;
    }

    public LayoutSet updateSettings(long groupId, boolean privateLayout, String settings) throws PortalException {
        LayoutSet layoutSet = this.layoutSetPersistence.findByG_P(groupId, privateLayout);
        LayoutSetBranch layoutSetBranch = this._getLayoutSetBranch(layoutSet);
        if (layoutSetBranch == null) {
            layoutSet.setModifiedDate(new Date());
            layoutSet.setSettings(settings);
            this.layoutSetPersistence.update((BaseModel)layoutSet);
            return layoutSet;
        }
        layoutSetBranch.setModifiedDate(new Date());
        layoutSetBranch.setSettings(settings);
        this.layoutSetBranchPersistence.update((BaseModel)layoutSetBranch);
        return layoutSet;
    }

    public LayoutSet updateVirtualHost(long groupId, boolean privateLayout, String virtualHostname) throws PortalException {
        LayoutSet layoutSet;
        block8: {
            if (Validator.isNotNull((String)(virtualHostname = StringUtil.toLowerCase((String)StringUtil.trim((String)virtualHostname)))) && !Validator.isDomain((String)virtualHostname)) {
                throw new LayoutSetVirtualHostException();
            }
            layoutSet = this.layoutSetPersistence.findByG_P(groupId, privateLayout);
            if (Validator.isNotNull((String)virtualHostname)) {
                VirtualHost virtualHost = this.virtualHostPersistence.fetchByHostname(virtualHostname);
                if (virtualHost == null) {
                    this.virtualHostLocalService.updateVirtualHost(layoutSet.getCompanyId(), layoutSet.getLayoutSetId(), virtualHostname);
                } else if (virtualHost.getCompanyId() != layoutSet.getCompanyId() || virtualHost.getLayoutSetId() != layoutSet.getLayoutSetId()) {
                    throw new LayoutSetVirtualHostException();
                }
            } else {
                try {
                    this.virtualHostPersistence.removeByC_L(layoutSet.getCompanyId(), layoutSet.getLayoutSetId());
                    this.layoutSetPersistence.clearCache((BaseModel)layoutSet);
                    TransactionCommitCallbackUtil.registerCallback((Callable)new Callable<Void>(){

                        @Override
                        public Void call() {
                            EntityCacheUtil.removeResult((boolean)LayoutSetModelImpl.ENTITY_CACHE_ENABLED, LayoutSetImpl.class, (Serializable)Long.valueOf(layoutSet.getLayoutSetId()));
                            return null;
                        }
                    });
                }
                catch (NoSuchVirtualHostException nsvhe) {
                    if (!_log.isDebugEnabled()) break block8;
                    _log.debug((Object)nsvhe, (Throwable)nsvhe);
                }
            }
        }
        return layoutSet;
    }

    protected LayoutSet initLayoutSet(LayoutSet layoutSet) throws PortalException {
        Group group = layoutSet.getGroup();
        boolean privateLayout = layoutSet.isPrivateLayout();
        if (group.isStagingGroup()) {
            LayoutSet liveLayoutSet = null;
            Group liveGroup = group.getLiveGroup();
            liveLayoutSet = privateLayout ? liveGroup.getPrivateLayoutSet() : liveGroup.getPublicLayoutSet();
            layoutSet.setLogoId(liveLayoutSet.getLogoId());
            if (liveLayoutSet.isLogo()) {
                Image logoImage = this.imageLocalService.getImage(liveLayoutSet.getLogoId());
                long logoId = this.counterLocalService.increment();
                this.imageLocalService.updateImage(logoId, logoImage.getTextObj(), logoImage.getType(), logoImage.getHeight(), logoImage.getWidth(), logoImage.getSize());
                layoutSet.setLogoId(logoId);
            }
            layoutSet.setThemeId(liveLayoutSet.getThemeId());
            layoutSet.setColorSchemeId(liveLayoutSet.getColorSchemeId());
            layoutSet.setCss(liveLayoutSet.getCss());
            layoutSet.setSettings(liveLayoutSet.getSettings());
        } else {
            layoutSet.setThemeId(ThemeFactoryUtil.getDefaultRegularThemeId((long)group.getCompanyId()));
            layoutSet.setColorSchemeId(ColorSchemeFactoryUtil.getDefaultRegularColorSchemeId());
            layoutSet.setCss("");
            layoutSet.setSettings("");
        }
        return layoutSet;
    }

    private LayoutSetBranch _getLayoutSetBranch(LayoutSet layoutSet) throws PortalException {
        LayoutSetStagingHandler layoutSetStagingHandler = LayoutStagingUtil.getLayoutSetStagingHandler((LayoutSet)layoutSet);
        if (layoutSetStagingHandler != null) {
            return layoutSetStagingHandler.getLayoutSetBranch();
        }
        if (LayoutStagingUtil.isBranchingLayoutSet((Group)layoutSet.getGroup(), (boolean)layoutSet.getPrivateLayout())) {
            layoutSetStagingHandler = new LayoutSetStagingHandler(layoutSet);
            return layoutSetStagingHandler.getLayoutSetBranch();
        }
        return null;
    }
}

