/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.image.SpriteProcessorUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ColorScheme;
import com.liferay.portal.kernel.model.PluginSetting;
import com.liferay.portal.kernel.model.PortletDecorator;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.plugin.Version;
import com.liferay.portal.kernel.servlet.ServletContextUtil;
import com.liferay.portal.kernel.spring.aop.Skip;
import com.liferay.portal.kernel.theme.PortletDecoratorFactoryUtil;
import com.liferay.portal.kernel.theme.ThemeCompanyId;
import com.liferay.portal.kernel.theme.ThemeCompanyLimit;
import com.liferay.portal.kernel.theme.ThemeGroupId;
import com.liferay.portal.kernel.theme.ThemeGroupLimit;
import com.liferay.portal.kernel.util.ColorSchemeFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.ThemeFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import com.liferay.portal.model.impl.ThemeImpl;
import com.liferay.portal.plugin.PluginUtil;
import com.liferay.portal.service.base.ThemeLocalServiceBaseImpl;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.ContextReplace;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;

@Skip
public class ThemeLocalServiceImpl
extends ThemeLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(ThemeLocalServiceImpl.class);
    private static final Map<String, Theme> _themes = new ConcurrentHashMap<String, Theme>();
    private static final Map<Long, Map<String, Theme>> _themesPool = new ConcurrentHashMap<Long, Map<String, Theme>>();

    public ColorScheme fetchColorScheme(long companyId, String themeId, String colorSchemeId) {
        colorSchemeId = GetterUtil.getString((String)colorSchemeId);
        Theme theme = this.fetchTheme(companyId, themeId);
        if (theme == null) {
            return null;
        }
        Map colorSchemesMap = theme.getColorSchemesMap();
        return (ColorScheme)colorSchemesMap.get(colorSchemeId);
    }

    public PortletDecorator fetchPortletDecorator(long companyId, String themeId, String colorSchemeId) {
        colorSchemeId = GetterUtil.getString((String)colorSchemeId);
        Theme theme = this.fetchTheme(companyId, themeId);
        if (theme == null) {
            return null;
        }
        Map portletDecoratorsMap = theme.getPortletDecoratorsMap();
        return (PortletDecorator)portletDecoratorsMap.get(colorSchemeId);
    }

    public Theme fetchTheme(long companyId, String themeId) {
        themeId = GetterUtil.getString((String)themeId);
        Map<String, Theme> themes = this._getThemes(companyId);
        return themes.get(themeId);
    }

    public ColorScheme getColorScheme(long companyId, String themeId, String colorSchemeId) {
        colorSchemeId = GetterUtil.getString((String)colorSchemeId);
        Theme theme = this.getTheme(companyId, themeId);
        Map colorSchemesMap = theme.getColorSchemesMap();
        ColorScheme colorScheme = (ColorScheme)colorSchemesMap.get(colorSchemeId);
        if (colorScheme != null) {
            return colorScheme;
        }
        List colorSchemes = theme.getColorSchemes();
        if (!colorSchemes.isEmpty()) {
            for (int i = colorSchemes.size() - 1; i >= 0; --i) {
                colorScheme = (ColorScheme)colorSchemes.get(i);
                if (!colorScheme.isDefaultCs()) continue;
                return colorScheme;
            }
        }
        if (colorScheme == null) {
            colorScheme = ColorSchemeFactoryUtil.getDefaultRegularColorScheme();
        }
        return colorScheme;
    }

    public List<Theme> getControlPanelThemes(long companyId, long userId) {
        List<Theme> themes = this.getThemes(companyId);
        themes = PluginUtil.restrictPlugins(themes, companyId, userId);
        Iterator<Theme> itr = themes.iterator();
        while (itr.hasNext()) {
            Theme theme = itr.next();
            if (theme.isControlPanelTheme()) continue;
            itr.remove();
        }
        return themes;
    }

    public List<Theme> getPageThemes(long companyId, long groupId, long userId) {
        List<Theme> themes = this.getThemes(companyId);
        themes = PluginUtil.restrictPlugins(themes, companyId, userId);
        Iterator<Theme> itr = themes.iterator();
        while (itr.hasNext()) {
            Theme theme = itr.next();
            if (theme.isPageTheme() && theme.isGroupAvailable(groupId)) continue;
            itr.remove();
        }
        return themes;
    }

    public PortletDecorator getPortletDecorator(long companyId, String themeId, String portletDecoratorId) {
        Theme theme = this.fetchTheme(companyId, themeId);
        Map portletDecoratorsMap = theme.getPortletDecoratorsMap();
        PortletDecorator portletDecorator = (PortletDecorator)portletDecoratorsMap.get(portletDecoratorId = GetterUtil.getString((String)portletDecoratorId));
        if (portletDecorator != null) {
            return portletDecorator;
        }
        ThemeImpl themeImpl = (ThemeImpl)theme;
        return themeImpl.getDefaultPortletDecorator();
    }

    public Theme getTheme(long companyId, String themeId) {
        themeId = GetterUtil.getString((String)themeId);
        Map<String, Theme> themes = this._getThemes(companyId);
        Theme theme = themes.get(themeId);
        if (theme != null) {
            return theme;
        }
        if (_log.isWarnEnabled()) {
            _log.warn((Object)("No theme found for specified theme id " + themeId + ". Returning the default theme."));
        }
        if ((theme = _themes.get(themeId = ThemeFactoryUtil.getDefaultRegularThemeId((long)companyId))) != null) {
            return theme;
        }
        if (_themes.isEmpty()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"No themes are installed");
            }
            return null;
        }
        if (!themeId.contains("_WAR_")) {
            _log.error((Object)("No theme found for default theme id " + themeId + ". Returning a random theme."));
        }
        for (Map.Entry<String, Theme> entry : _themes.entrySet()) {
            theme = entry.getValue();
            if (theme == null || theme.isControlPanelTheme()) continue;
            return theme;
        }
        return null;
    }

    public List<Theme> getThemes(long companyId) {
        Map<String, Theme> themes = this._getThemes(companyId);
        List themesList = ListUtil.fromMapValues(themes);
        return ListUtil.sort((List)themesList);
    }

    @Deprecated
    public List<Theme> getThemes(long companyId, long groupId, long userId, boolean wapTheme) {
        return this.getPageThemes(companyId, groupId, userId);
    }

    public List<Theme> getWARThemes() {
        List themes = ListUtil.fromMapValues(_themes);
        Iterator itr = themes.iterator();
        while (itr.hasNext()) {
            Theme theme = (Theme)itr.next();
            if (theme.isWARFile()) continue;
            itr.remove();
        }
        return themes;
    }

    public List<Theme> init(ServletContext servletContext, String themesPath, boolean loadFromServletContext, String[] xmls, PluginPackage pluginPackage) {
        return this.init(null, servletContext, themesPath, loadFromServletContext, xmls, pluginPackage);
    }

    public List<Theme> init(String servletContextName, ServletContext servletContext, String themesPath, boolean loadFromServletContext, String[] xmls, PluginPackage pluginPackage) {
        LinkedHashSet<Theme> themes = new LinkedHashSet<Theme>();
        try {
            for (String xml : xmls) {
                themes.addAll(this._readThemes(servletContextName, servletContext, themesPath, loadFromServletContext, xml, pluginPackage));
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        _themesPool.clear();
        return new ArrayList<Theme>(themes);
    }

    public void uninstallThemes(List<Theme> themes) {
        for (Theme theme : themes) {
            String themeId = theme.getThemeId();
            _themes.remove(themeId);
            this.layoutTemplateLocalService.uninstallLayoutTemplates(themeId);
        }
        _themesPool.clear();
    }

    private List<ThemeCompanyId> _getCompanyLimitExcludes(Element element) {
        ArrayList<ThemeCompanyId> includes = new ArrayList<ThemeCompanyId>();
        if (element == null) {
            return includes;
        }
        List companyIdsElements = element.elements("company-id");
        for (int i = 0; i < companyIdsElements.size(); ++i) {
            Element companyIdElement = (Element)companyIdsElements.get(i);
            String name = companyIdElement.attributeValue("name");
            String pattern = companyIdElement.attributeValue("pattern");
            ThemeCompanyId themeCompanyId = null;
            if (Validator.isNotNull((String)name)) {
                themeCompanyId = new ThemeCompanyId(name, false);
            } else if (Validator.isNotNull((String)pattern)) {
                themeCompanyId = new ThemeCompanyId(pattern, true);
            }
            if (themeCompanyId == null) continue;
            includes.add(themeCompanyId);
        }
        return includes;
    }

    private List<ThemeCompanyId> _getCompanyLimitIncludes(Element element) {
        return this._getCompanyLimitExcludes(element);
    }

    private List<ThemeGroupId> _getGroupLimitExcludes(Element element) {
        ArrayList<ThemeGroupId> includes = new ArrayList<ThemeGroupId>();
        if (element == null) {
            return includes;
        }
        List groupIdsElements = element.elements("group-id");
        for (int i = 0; i < groupIdsElements.size(); ++i) {
            Element groupIdElement = (Element)groupIdsElements.get(i);
            String name = groupIdElement.attributeValue("name");
            String pattern = groupIdElement.attributeValue("pattern");
            ThemeGroupId themeGroupId = null;
            if (Validator.isNotNull((String)name)) {
                themeGroupId = new ThemeGroupId(name, false);
            } else if (Validator.isNotNull((String)pattern)) {
                themeGroupId = new ThemeGroupId(pattern, true);
            }
            if (themeGroupId == null) continue;
            includes.add(themeGroupId);
        }
        return includes;
    }

    private List<ThemeGroupId> _getGroupLimitIncludes(Element element) {
        return this._getGroupLimitExcludes(element);
    }

    private Map<String, Theme> _getThemes(long companyId) {
        Map<String, Theme> themes = _themesPool.get(companyId);
        if (themes != null) {
            return themes;
        }
        themes = new ConcurrentHashMap<String, Theme>();
        for (Map.Entry<String, Theme> entry : _themes.entrySet()) {
            String themeId = entry.getKey();
            Theme theme = entry.getValue();
            if (!theme.isCompanyAvailable(companyId)) continue;
            themes.put(themeId, theme);
        }
        _themesPool.put(companyId, themes);
        return themes;
    }

    private Version _getVersion(String version) {
        if (version.equals("${current-version}")) {
            version = ReleaseInfo.getVersion();
        }
        return Version.getInstance((String)version);
    }

    private void _readColorSchemes(Element themeElement, Map<String, ColorScheme> colorSchemes, ContextReplace themeContextReplace) {
        List colorSchemeElements = themeElement.elements("color-scheme");
        for (Element colorSchemeElement : colorSchemeElements) {
            ContextReplace colorSchemeContextReplace = (ContextReplace)themeContextReplace.clone();
            String id = colorSchemeElement.attributeValue("id");
            colorSchemeContextReplace.addValue("color-scheme-id", id);
            ColorScheme colorSchemeModel = colorSchemes.get(id);
            if (colorSchemeModel == null) {
                colorSchemeModel = ColorSchemeFactoryUtil.getColorScheme((String)id);
            }
            String name = GetterUtil.getString((String)colorSchemeElement.attributeValue("name"), (String)colorSchemeModel.getName());
            name = colorSchemeContextReplace.replace(name);
            boolean defaultCs = GetterUtil.getBoolean((String)colorSchemeElement.elementText("default-cs"), (boolean)colorSchemeModel.isDefaultCs());
            String cssClass = GetterUtil.getString((String)colorSchemeElement.elementText("css-class"), (String)colorSchemeModel.getCssClass());
            cssClass = colorSchemeContextReplace.replace(cssClass);
            colorSchemeContextReplace.addValue("css-class", cssClass);
            String colorSchemeImagesPath = GetterUtil.getString((String)colorSchemeElement.elementText("color-scheme-images-path"), (String)colorSchemeModel.getColorSchemeImagesPath());
            colorSchemeImagesPath = colorSchemeContextReplace.replace(colorSchemeImagesPath);
            colorSchemeContextReplace.addValue("color-scheme-images-path", colorSchemeImagesPath);
            colorSchemeModel.setName(name);
            colorSchemeModel.setDefaultCs(defaultCs);
            colorSchemeModel.setCssClass(cssClass);
            colorSchemeModel.setColorSchemeImagesPath(colorSchemeImagesPath);
            colorSchemes.put(id, colorSchemeModel);
        }
    }

    private void _readPortletDecorators(Element themeElement, Map<String, PortletDecorator> portletDecorators, ContextReplace themeContextReplace) {
        List portletDecoratorElements = themeElement.elements("portlet-decorator");
        for (Element portletDecoratorElement : portletDecoratorElements) {
            ContextReplace portletDecoratorContextReplace = (ContextReplace)themeContextReplace.clone();
            String id = portletDecoratorElement.attributeValue("id");
            portletDecoratorContextReplace.addValue("portlet-decorator-id", id);
            PortletDecorator portletDecoratorModel = portletDecorators.get(id);
            if (portletDecoratorModel == null) {
                portletDecoratorModel = PortletDecoratorFactoryUtil.getPortletDecorator((String)id);
            }
            String name = GetterUtil.getString((String)portletDecoratorElement.attributeValue("name"), (String)portletDecoratorModel.getName());
            name = portletDecoratorContextReplace.replace(name);
            boolean defaultPortletDecorator = GetterUtil.getBoolean((String)portletDecoratorElement.elementText("default-portlet-decorator"), (boolean)portletDecoratorModel.isDefaultPortletDecorator());
            String cssClass = GetterUtil.getString((String)portletDecoratorElement.elementText("portlet-decorator-css-class"), (String)portletDecoratorModel.getCssClass());
            cssClass = portletDecoratorContextReplace.replace(cssClass);
            portletDecoratorContextReplace.addValue("portlet-decorator-css-class", cssClass);
            String portletDecoratorThumbnailPath = GetterUtil.getString((String)portletDecoratorElement.elementText("portlet-decorator-thumbnail-path"), (String)portletDecoratorModel.getPortletDecoratorThumbnailPath());
            portletDecoratorThumbnailPath = portletDecoratorContextReplace.replace(portletDecoratorThumbnailPath);
            portletDecoratorContextReplace.addValue("portlet-decorator-thumbnail-path", portletDecoratorThumbnailPath);
            portletDecoratorModel.setName(name);
            portletDecoratorModel.setDefaultPortletDecorator(defaultPortletDecorator);
            portletDecoratorModel.setCssClass(cssClass);
            portletDecoratorModel.setPortletDecoratorThumbnailPath(portletDecoratorThumbnailPath);
            portletDecorators.put(id, portletDecoratorModel);
        }
    }

    private Set<Theme> _readThemes(String servletContextName, ServletContext servletContext, String themesPath, boolean loadFromServletContext, String xml, PluginPackage pluginPackage) throws Exception {
        HashSet<Theme> themes = new HashSet<Theme>();
        if (xml == null) {
            return themes;
        }
        Document document = UnsecureSAXReaderUtil.read((String)xml, (boolean)true);
        Element rootElement = document.getRootElement();
        Version portalVersion = this._getVersion(ReleaseInfo.getVersion());
        boolean compatible = false;
        Element compatibilityElement = rootElement.element("compatibility");
        if (compatibilityElement != null) {
            List versionElements = compatibilityElement.elements("version");
            for (Element versionElement : versionElements) {
                Version version = this._getVersion(versionElement.getTextTrim());
                if (!version.includes(portalVersion)) continue;
                compatible = true;
                break;
            }
        }
        if (!compatible) {
            _log.error((Object)("Themes in this WAR are not compatible with " + ReleaseInfo.getServerInfo()));
            return themes;
        }
        ThemeCompanyLimit companyLimit = null;
        Element companyLimitElement = rootElement.element("company-limit");
        if (companyLimitElement != null) {
            Element companyExcludesElement;
            companyLimit = new ThemeCompanyLimit();
            Element companyIncludesElement = companyLimitElement.element("company-includes");
            if (companyIncludesElement != null) {
                companyLimit.setIncludes(this._getCompanyLimitIncludes(companyIncludesElement));
            }
            if ((companyExcludesElement = companyLimitElement.element("company-excludes")) != null) {
                companyLimit.setExcludes(this._getCompanyLimitExcludes(companyExcludesElement));
            }
        }
        ThemeGroupLimit groupLimit = null;
        Element groupLimitElement = rootElement.element("group-limit");
        if (groupLimitElement != null) {
            Element groupExcludesElement;
            groupLimit = new ThemeGroupLimit();
            Element groupIncludesElement = groupLimitElement.element("group-includes");
            if (groupIncludesElement != null) {
                groupLimit.setIncludes(this._getGroupLimitIncludes(groupIncludesElement));
            }
            if ((groupExcludesElement = groupLimitElement.element("group-excludes")) != null) {
                groupLimit.setExcludes(this._getGroupLimitExcludes(groupExcludesElement));
            }
        }
        long timestamp = ServletContextUtil.getLastModified((ServletContext)servletContext);
        List themeElements = rootElement.elements("theme");
        for (Element themeElement : themeElements) {
            ContextReplace themeContextReplace = new ContextReplace();
            themeContextReplace.addValue("themes-path", themesPath);
            String themeId = themeElement.attributeValue("id");
            if (servletContextName != null) {
                themeId = themeId + "_WAR_" + servletContextName;
            }
            themeId = PortalUtil.getJsSafePortletId((String)themeId);
            themeContextReplace.addValue("theme-id", themeId);
            Theme theme = _themes.get(themeId);
            if (theme == null) {
                theme = ThemeFactoryUtil.getTheme((String)themeId);
            }
            theme.setTimestamp(timestamp);
            PluginSetting pluginSetting = this.pluginSettingLocalService.getDefaultPluginSetting();
            theme.setPluginPackage(pluginPackage);
            theme.setDefaultPluginSetting(pluginSetting);
            theme.setThemeCompanyLimit(companyLimit);
            theme.setThemeGroupLimit(groupLimit);
            if (servletContextName != null) {
                theme.setServletContextName(servletContextName);
            }
            theme.setLoadFromServletContext(loadFromServletContext);
            String name = GetterUtil.getString((String)themeElement.attributeValue("name"), (String)theme.getName());
            String rootPath = GetterUtil.getString((String)themeElement.elementText("root-path"), (String)theme.getRootPath());
            rootPath = themeContextReplace.replace(rootPath);
            themeContextReplace.addValue("root-path", rootPath);
            String templatesPath = GetterUtil.getString((String)themeElement.elementText("templates-path"), (String)theme.getTemplatesPath());
            templatesPath = themeContextReplace.replace(templatesPath);
            templatesPath = StringUtil.replace((String)templatesPath, (String)"//", (String)"/");
            themeContextReplace.addValue("templates-path", templatesPath);
            String cssPath = GetterUtil.getString((String)themeElement.elementText("css-path"), (String)theme.getCssPath());
            cssPath = themeContextReplace.replace(cssPath);
            cssPath = StringUtil.replace((String)cssPath, (String)"//", (String)"/");
            themeContextReplace.addValue("css-path", cssPath);
            String imagesPath = GetterUtil.getString((String)themeElement.elementText("images-path"), (String)theme.getImagesPath());
            imagesPath = themeContextReplace.replace(imagesPath);
            imagesPath = StringUtil.replace((String)imagesPath, (String)"//", (String)"/");
            themeContextReplace.addValue("images-path", imagesPath);
            String javaScriptPath = GetterUtil.getString((String)themeElement.elementText("javascript-path"), (String)theme.getJavaScriptPath());
            javaScriptPath = themeContextReplace.replace(javaScriptPath);
            javaScriptPath = StringUtil.replace((String)javaScriptPath, (String)"//", (String)"/");
            themeContextReplace.addValue("javascript-path", javaScriptPath);
            String virtualPath = GetterUtil.getString((String)themeElement.elementText("virtual-path"), (String)theme.getVirtualPath());
            String templateExtension = GetterUtil.getString((String)themeElement.elementText("template-extension"), (String)theme.getTemplateExtension());
            theme.setName(name);
            theme.setRootPath(rootPath);
            theme.setTemplatesPath(templatesPath);
            theme.setCssPath(cssPath);
            theme.setImagesPath(imagesPath);
            theme.setJavaScriptPath(javaScriptPath);
            theme.setVirtualPath(virtualPath);
            theme.setTemplateExtension(templateExtension);
            Element settingsElement = themeElement.element("settings");
            if (settingsElement != null) {
                List settingElements = settingsElement.elements("setting");
                for (Object settingElement : settingElements) {
                    boolean configurable = GetterUtil.getBoolean((String)settingElement.attributeValue("configurable"));
                    String key = settingElement.attributeValue("key");
                    String[] options = StringUtil.split((String)settingElement.attributeValue("options"));
                    String type = settingElement.attributeValue("type", "text");
                    String value = settingElement.attributeValue("value", "");
                    String script = settingElement.getTextTrim();
                    theme.addSetting(key, value, configurable, type, options, script);
                }
            }
            theme.setControlPanelTheme(GetterUtil.getBoolean((String)themeElement.elementText("control-panel-theme")));
            theme.setPageTheme(GetterUtil.getBoolean((String)themeElement.elementText("page-theme"), (boolean)true));
            Element rolesElement = themeElement.element("roles");
            if (rolesElement != null) {
                Object settingElement;
                List roleNameElements = rolesElement.elements("role-name");
                settingElement = roleNameElements.iterator();
                while (settingElement.hasNext()) {
                    Element roleNameElement = (Element)settingElement.next();
                    pluginSetting.addRole(roleNameElement.getText());
                }
            }
            this._readColorSchemes(themeElement, theme.getColorSchemesMap(), themeContextReplace);
            this._readColorSchemes(themeElement, theme.getColorSchemesMap(), themeContextReplace);
            Element layoutTemplatesElement = themeElement.element("layout-templates");
            if (layoutTemplatesElement != null) {
                Element customElement;
                Element standardElement = layoutTemplatesElement.element("standard");
                if (standardElement != null) {
                    this.layoutTemplateLocalService.readLayoutTemplate(servletContextName, servletContext, null, standardElement, true, themeId, pluginPackage);
                }
                if ((customElement = layoutTemplatesElement.element("custom")) != null) {
                    this.layoutTemplateLocalService.readLayoutTemplate(servletContextName, servletContext, null, customElement, false, themeId, pluginPackage);
                }
            }
            this._setSpriteImages(servletContext, theme, imagesPath);
            if (!_themes.containsKey(themeId)) {
                _themes.put(themeId, theme);
            }
            this._readPortletDecorators(themeElement, theme.getPortletDecoratorsMap(), themeContextReplace);
            this._readPortletDecorators(themeElement, theme.getPortletDecoratorsMap(), themeContextReplace);
            themes.add(theme);
        }
        return themes;
    }

    private void _setSpriteImages(ServletContext servletContext, Theme theme, String resourcePath) throws Exception {
        String rootPath;
        String spritePropertiesFileName;
        Set resourcePaths;
        if (!resourcePath.startsWith("/")) {
            resourcePath = "/".concat(resourcePath);
        }
        if ((resourcePaths = servletContext.getResourcePaths(resourcePath)) == null || resourcePaths.isEmpty()) {
            return;
        }
        ArrayList<URL> imageURLs = new ArrayList<URL>(resourcePaths.size());
        for (String curResourcePath : resourcePaths) {
            if (curResourcePath.endsWith("/")) {
                this._setSpriteImages(servletContext, theme, curResourcePath);
                continue;
            }
            if (!curResourcePath.endsWith(".png")) continue;
            URL imageURL = servletContext.getResource(curResourcePath);
            if (imageURL != null) {
                imageURLs.add(imageURL);
                continue;
            }
            _log.error((Object)("Resource URL for " + curResourcePath + " is null"));
        }
        String spriteRootDirName = PropsValues.SPRITE_ROOT_DIR;
        String spriteFileName = resourcePath.concat(PropsValues.SPRITE_FILE_NAME);
        Properties spriteProperties = SpriteProcessorUtil.generate((ServletContext)servletContext, imageURLs, (String)spriteRootDirName, (String)spriteFileName, (String)(spritePropertiesFileName = resourcePath.concat(PropsValues.SPRITE_PROPERTIES_FILE_NAME)), (String)(rootPath = ServletContextUtil.getRootPath((ServletContext)servletContext)), (int)16, (int)16, (int)10240);
        if (spriteProperties == null) {
            return;
        }
        String contextPath = servletContext.getContextPath();
        spriteFileName = contextPath.concat("/sprite").concat(spriteFileName);
        theme.setSpriteImages(spriteFileName, spriteProperties);
    }
}

