/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.persistence.impl;

import aQute.bnd.annotation.ProviderType;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.EntityCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderCacheUtil;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.NoSuchCompanyException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.service.persistence.CompanyPersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.impl.CompanyImpl;
import com.liferay.portal.model.impl.CompanyModelImpl;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ProviderType
public class CompanyPersistenceImpl
extends BasePersistenceImpl<Company>
implements CompanyPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = CompanyImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_ALL = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, CompanyImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, CompanyImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
    public static final FinderPath FINDER_PATH_COUNT_ALL = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
    public static final FinderPath FINDER_PATH_FETCH_BY_WEBID = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, CompanyImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByWebId", new String[]{String.class.getName()}, 8L);
    public static final FinderPath FINDER_PATH_COUNT_BY_WEBID = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByWebId", new String[]{String.class.getName()});
    private static final String _FINDER_COLUMN_WEBID_WEBID_1 = "company.webId IS NULL";
    private static final String _FINDER_COLUMN_WEBID_WEBID_2 = "company.webId = ?";
    private static final String _FINDER_COLUMN_WEBID_WEBID_3 = "(company.webId IS NULL OR company.webId = '')";
    public static final FinderPath FINDER_PATH_FETCH_BY_MX = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, CompanyImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByMx", new String[]{String.class.getName()}, 2L);
    public static final FinderPath FINDER_PATH_COUNT_BY_MX = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByMx", new String[]{String.class.getName()});
    private static final String _FINDER_COLUMN_MX_MX_1 = "company.mx IS NULL";
    private static final String _FINDER_COLUMN_MX_MX_2 = "company.mx = ?";
    private static final String _FINDER_COLUMN_MX_MX_3 = "(company.mx IS NULL OR company.mx = '')";
    public static final FinderPath FINDER_PATH_FETCH_BY_LOGOID = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, CompanyImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByLogoId", new String[]{Long.class.getName()}, 1L);
    public static final FinderPath FINDER_PATH_COUNT_BY_LOGOID = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByLogoId", new String[]{Long.class.getName()});
    private static final String _FINDER_COLUMN_LOGOID_LOGOID_2 = "company.logoId = ?";
    public static final FinderPath FINDER_PATH_WITH_PAGINATION_FIND_BY_SYSTEM = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, CompanyImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findBySystem", new String[]{Boolean.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
    public static final FinderPath FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_SYSTEM = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, CompanyImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findBySystem", new String[]{Boolean.class.getName()}, 4L);
    public static final FinderPath FINDER_PATH_COUNT_BY_SYSTEM = new FinderPath(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyModelImpl.FINDER_CACHE_ENABLED, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countBySystem", new String[]{Boolean.class.getName()});
    private static final String _FINDER_COLUMN_SYSTEM_SYSTEM_2 = "company.system = ?";
    protected EntityCache entityCache;
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_COMPANY = "SELECT company FROM Company company";
    private static final String _SQL_SELECT_COMPANY_WHERE_PKS_IN = "SELECT company FROM Company company WHERE companyId IN (";
    private static final String _SQL_SELECT_COMPANY_WHERE = "SELECT company FROM Company company WHERE ";
    private static final String _SQL_COUNT_COMPANY = "SELECT COUNT(company) FROM Company company";
    private static final String _SQL_COUNT_COMPANY_WHERE = "SELECT COUNT(company) FROM Company company WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "company.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Company exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No Company exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(CompanyPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"key", "active"});

    public Company findByWebId(String webId) throws NoSuchCompanyException {
        Company company = this.fetchByWebId(webId);
        if (company == null) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("webId=");
            msg.append(webId);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)msg.toString());
            }
            throw new NoSuchCompanyException(msg.toString());
        }
        return company;
    }

    public Company fetchByWebId(String webId) {
        return this.fetchByWebId(webId, true);
    }

    public Company fetchByWebId(String webId, boolean retrieveFromCache) {
        Company company;
        Object[] finderArgs = new Object[]{webId};
        Object result = null;
        if (retrieveFromCache) {
            result = this.finderCache.getResult(FINDER_PATH_FETCH_BY_WEBID, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof Company && !Objects.equals(webId, (company = (Company)result).getWebId())) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_SELECT_COMPANY_WHERE);
            boolean bindWebId = false;
            if (webId == null) {
                query.append(_FINDER_COLUMN_WEBID_WEBID_1);
            } else if (webId.equals("")) {
                query.append(_FINDER_COLUMN_WEBID_WEBID_3);
            } else {
                bindWebId = true;
                query.append(_FINDER_COLUMN_WEBID_WEBID_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (bindWebId) {
                    qPos.add(webId);
                }
                if ((list = q.list()).isEmpty()) {
                    this.finderCache.putResult(FINDER_PATH_FETCH_BY_WEBID, finderArgs, (Object)list);
                } else {
                    Company company2 = (Company)list.get(0);
                    result = company2;
                    this.cacheResult(company2);
                    if (company2.getWebId() == null || !company2.getWebId().equals(webId)) {
                        this.finderCache.putResult(FINDER_PATH_FETCH_BY_WEBID, finderArgs, (Object)company2);
                    }
                }
            }
            catch (Exception e) {
                this.finderCache.removeResult(FINDER_PATH_FETCH_BY_WEBID, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Company)result;
    }

    public Company removeByWebId(String webId) throws NoSuchCompanyException {
        Company company = this.findByWebId(webId);
        return (Company)this.remove((BaseModel)company);
    }

    public int countByWebId(String webId) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_WEBID;
        Object[] finderArgs = new Object[]{webId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_COMPANY_WHERE);
            boolean bindWebId = false;
            if (webId == null) {
                query.append(_FINDER_COLUMN_WEBID_WEBID_1);
            } else if (webId.equals("")) {
                query.append(_FINDER_COLUMN_WEBID_WEBID_3);
            } else {
                bindWebId = true;
                query.append(_FINDER_COLUMN_WEBID_WEBID_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (bindWebId) {
                    qPos.add(webId);
                }
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Company findByMx(String mx) throws NoSuchCompanyException {
        Company company = this.fetchByMx(mx);
        if (company == null) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("mx=");
            msg.append(mx);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)msg.toString());
            }
            throw new NoSuchCompanyException(msg.toString());
        }
        return company;
    }

    public Company fetchByMx(String mx) {
        return this.fetchByMx(mx, true);
    }

    public Company fetchByMx(String mx, boolean retrieveFromCache) {
        Company company;
        Object[] finderArgs = new Object[]{mx};
        Object result = null;
        if (retrieveFromCache) {
            result = this.finderCache.getResult(FINDER_PATH_FETCH_BY_MX, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof Company && !Objects.equals(mx, (company = (Company)result).getMx())) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_SELECT_COMPANY_WHERE);
            boolean bindMx = false;
            if (mx == null) {
                query.append(_FINDER_COLUMN_MX_MX_1);
            } else if (mx.equals("")) {
                query.append(_FINDER_COLUMN_MX_MX_3);
            } else {
                bindMx = true;
                query.append(_FINDER_COLUMN_MX_MX_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (bindMx) {
                    qPos.add(mx);
                }
                if ((list = q.list()).isEmpty()) {
                    this.finderCache.putResult(FINDER_PATH_FETCH_BY_MX, finderArgs, (Object)list);
                } else {
                    if (list.size() > 1) {
                        Collections.sort(list, Collections.reverseOrder());
                        if (_log.isWarnEnabled()) {
                            _log.warn((Object)("CompanyPersistenceImpl.fetchByMx(String, boolean) with parameters (" + StringUtil.merge((Object[])finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder."));
                        }
                    }
                    Company company2 = (Company)list.get(0);
                    result = company2;
                    this.cacheResult(company2);
                    if (company2.getMx() == null || !company2.getMx().equals(mx)) {
                        this.finderCache.putResult(FINDER_PATH_FETCH_BY_MX, finderArgs, (Object)company2);
                    }
                }
            }
            catch (Exception e) {
                this.finderCache.removeResult(FINDER_PATH_FETCH_BY_MX, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Company)result;
    }

    public Company removeByMx(String mx) throws NoSuchCompanyException {
        Company company = this.findByMx(mx);
        return (Company)this.remove((BaseModel)company);
    }

    public int countByMx(String mx) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_MX;
        Object[] finderArgs = new Object[]{mx};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_COMPANY_WHERE);
            boolean bindMx = false;
            if (mx == null) {
                query.append(_FINDER_COLUMN_MX_MX_1);
            } else if (mx.equals("")) {
                query.append(_FINDER_COLUMN_MX_MX_3);
            } else {
                bindMx = true;
                query.append(_FINDER_COLUMN_MX_MX_2);
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                if (bindMx) {
                    qPos.add(mx);
                }
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Company findByLogoId(long logoId) throws NoSuchCompanyException {
        Company company = this.fetchByLogoId(logoId);
        if (company == null) {
            StringBundler msg = new StringBundler(4);
            msg.append(_NO_SUCH_ENTITY_WITH_KEY);
            msg.append("logoId=");
            msg.append(logoId);
            msg.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)msg.toString());
            }
            throw new NoSuchCompanyException(msg.toString());
        }
        return company;
    }

    public Company fetchByLogoId(long logoId) {
        return this.fetchByLogoId(logoId, true);
    }

    public Company fetchByLogoId(long logoId, boolean retrieveFromCache) {
        Company company;
        Object[] finderArgs = new Object[]{logoId};
        Object result = null;
        if (retrieveFromCache) {
            result = this.finderCache.getResult(FINDER_PATH_FETCH_BY_LOGOID, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof Company && logoId != (company = (Company)result).getLogoId()) {
            result = null;
        }
        if (result == null) {
            StringBundler query = new StringBundler(3);
            query.append(_SQL_SELECT_COMPANY_WHERE);
            query.append(_FINDER_COLUMN_LOGOID_LOGOID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(logoId);
                List list = q.list();
                if (list.isEmpty()) {
                    this.finderCache.putResult(FINDER_PATH_FETCH_BY_LOGOID, finderArgs, (Object)list);
                } else {
                    if (list.size() > 1) {
                        Collections.sort(list, Collections.reverseOrder());
                        if (_log.isWarnEnabled()) {
                            _log.warn((Object)("CompanyPersistenceImpl.fetchByLogoId(long, boolean) with parameters (" + StringUtil.merge((Object[])finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder."));
                        }
                    }
                    Company company2 = (Company)list.get(0);
                    result = company2;
                    this.cacheResult(company2);
                    if (company2.getLogoId() != logoId) {
                        this.finderCache.putResult(FINDER_PATH_FETCH_BY_LOGOID, finderArgs, (Object)company2);
                    }
                }
            }
            catch (Exception e) {
                this.finderCache.removeResult(FINDER_PATH_FETCH_BY_LOGOID, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Company)result;
    }

    public Company removeByLogoId(long logoId) throws NoSuchCompanyException {
        Company company = this.findByLogoId(logoId);
        return (Company)this.remove((BaseModel)company);
    }

    public int countByLogoId(long logoId) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_LOGOID;
        Object[] finderArgs = new Object[]{logoId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_COMPANY_WHERE);
            query.append(_FINDER_COLUMN_LOGOID_LOGOID_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(logoId);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<Company> findBySystem(boolean system) {
        return this.findBySystem(system, -1, -1, null);
    }

    public List<Company> findBySystem(boolean system, int start, int end) {
        return this.findBySystem(system, start, end, null);
    }

    public List<Company> findBySystem(boolean system, int start, int end, OrderByComparator<Company> orderByComparator) {
        return this.findBySystem(system, start, end, orderByComparator, true);
    }

    public List<Company> findBySystem(boolean system, int start, int end, OrderByComparator<Company> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_SYSTEM;
            finderArgs = new Object[]{system};
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_BY_SYSTEM;
            finderArgs = new Object[]{system, start, end, orderByComparator};
        }
        List<Company> list = null;
        if (retrieveFromCache && (list = (List<Company>)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (Company company : list) {
                if (system == company.getSystem()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler query = null;
            query = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            query.append(_SQL_SELECT_COMPANY_WHERE);
            query.append(_FINDER_COLUMN_SYSTEM_SYSTEM_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else if (pagination) {
                query.append(" ORDER BY company.companyId ASC");
            }
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(system);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public Company findBySystem_First(boolean system, OrderByComparator<Company> orderByComparator) throws NoSuchCompanyException {
        Company company = this.fetchBySystem_First(system, orderByComparator);
        if (company != null) {
            return company;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("system=");
        msg.append(system);
        msg.append("}");
        throw new NoSuchCompanyException(msg.toString());
    }

    public Company fetchBySystem_First(boolean system, OrderByComparator<Company> orderByComparator) {
        List<Company> list = this.findBySystem(system, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Company findBySystem_Last(boolean system, OrderByComparator<Company> orderByComparator) throws NoSuchCompanyException {
        Company company = this.fetchBySystem_Last(system, orderByComparator);
        if (company != null) {
            return company;
        }
        StringBundler msg = new StringBundler(4);
        msg.append(_NO_SUCH_ENTITY_WITH_KEY);
        msg.append("system=");
        msg.append(system);
        msg.append("}");
        throw new NoSuchCompanyException(msg.toString());
    }

    public Company fetchBySystem_Last(boolean system, OrderByComparator<Company> orderByComparator) {
        int count = this.countBySystem(system);
        if (count == 0) {
            return null;
        }
        List<Company> list = this.findBySystem(system, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Company[] findBySystem_PrevAndNext(long companyId, boolean system, OrderByComparator<Company> orderByComparator) throws NoSuchCompanyException {
        Company company = this.findByPrimaryKey(companyId);
        Session session = null;
        try {
            session = this.openSession();
            Company[] array = new CompanyImpl[]{this.getBySystem_PrevAndNext(session, company, system, orderByComparator, true), company, this.getBySystem_PrevAndNext(session, company, system, orderByComparator, false)};
            Company[] companyArray = array;
            return companyArray;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Company getBySystem_PrevAndNext(Session session, Company company, boolean system, OrderByComparator<Company> orderByComparator, boolean previous) {
        List list;
        StringBundler query = null;
        query = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        query.append(_SQL_SELECT_COMPANY_WHERE);
        query.append(_FINDER_COLUMN_SYSTEM_SYSTEM_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                query.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" >= ? AND ");
                        continue;
                    }
                    query.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" >= ? ");
                    continue;
                }
                query.append(" <= ? ");
            }
            query.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                query.append(_ORDER_BY_ENTITY_ALIAS);
                query.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        query.append(" ASC, ");
                        continue;
                    }
                    query.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    query.append(" ASC");
                    continue;
                }
                query.append(" DESC");
            }
        } else {
            query.append(" ORDER BY company.companyId ASC");
        }
        String sql = query.toString();
        Query q = session.createQuery(sql);
        q.setFirstResult(0);
        q.setMaxResults(2);
        QueryPos qPos = QueryPos.getInstance((Query)q);
        qPos.add(system);
        if (orderByComparator != null) {
            Object[] values;
            for (Object value : values = orderByComparator.getOrderByConditionValues((Object)company)) {
                qPos.add(value);
            }
        }
        if ((list = q.list()).size() == 2) {
            return (Company)list.get(1);
        }
        return null;
    }

    public void removeBySystem(boolean system) {
        for (Company company : this.findBySystem(system, -1, -1, null)) {
            this.remove((BaseModel)company);
        }
    }

    public int countBySystem(boolean system) {
        FinderPath finderPath = FINDER_PATH_COUNT_BY_SYSTEM;
        Object[] finderArgs = new Object[]{system};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler query = new StringBundler(2);
            query.append(_SQL_COUNT_COMPANY_WHERE);
            query.append(_FINDER_COLUMN_SYSTEM_SYSTEM_2);
            String sql = query.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(system);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public CompanyPersistenceImpl() {
        block2: {
            this.entityCache = EntityCacheUtil.getEntityCache();
            this.finderCache = FinderCacheUtil.getFinderCache();
            this.setModelClass(Company.class);
            try {
                Field field = ReflectionUtil.getDeclaredField(BasePersistenceImpl.class, (String)"_dbColumnNames");
                HashMap<String, String> dbColumnNames = new HashMap<String, String>();
                dbColumnNames.put("key", "key_");
                dbColumnNames.put("active", "active_");
                field.set((Object)this, dbColumnNames);
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Object)e, (Throwable)e);
            }
        }
    }

    public void cacheResult(Company company) {
        this.entityCache.putResult(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyImpl.class, (Serializable)Long.valueOf(company.getPrimaryKey()), (Serializable)company);
        this.finderCache.putResult(FINDER_PATH_FETCH_BY_WEBID, new Object[]{company.getWebId()}, (Object)company);
        this.finderCache.putResult(FINDER_PATH_FETCH_BY_MX, new Object[]{company.getMx()}, (Object)company);
        this.finderCache.putResult(FINDER_PATH_FETCH_BY_LOGOID, new Object[]{company.getLogoId()}, (Object)company);
        company.resetOriginalValues();
    }

    public void cacheResult(List<Company> companies) {
        for (Company company : companies) {
            if (this.entityCache.getResult(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyImpl.class, (Serializable)Long.valueOf(company.getPrimaryKey())) == null) {
                this.cacheResult(company);
                continue;
            }
            company.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(CompanyImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(Company company) {
        this.entityCache.removeResult(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyImpl.class, (Serializable)Long.valueOf(company.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((CompanyModelImpl)company, true);
    }

    public void clearCache(List<Company> companies) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Company company : companies) {
            this.entityCache.removeResult(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyImpl.class, (Serializable)Long.valueOf(company.getPrimaryKey()));
            this.clearUniqueFindersCache((CompanyModelImpl)company, true);
        }
    }

    protected void cacheUniqueFindersCache(CompanyModelImpl companyModelImpl) {
        Object[] args = new Object[]{companyModelImpl.getWebId()};
        this.finderCache.putResult(FINDER_PATH_COUNT_BY_WEBID, args, (Object)1L, false);
        this.finderCache.putResult(FINDER_PATH_FETCH_BY_WEBID, args, (Object)companyModelImpl, false);
        args = new Object[]{companyModelImpl.getMx()};
        this.finderCache.putResult(FINDER_PATH_COUNT_BY_MX, args, (Object)1L, false);
        this.finderCache.putResult(FINDER_PATH_FETCH_BY_MX, args, (Object)companyModelImpl, false);
        args = new Object[]{companyModelImpl.getLogoId()};
        this.finderCache.putResult(FINDER_PATH_COUNT_BY_LOGOID, args, (Object)1L, false);
        this.finderCache.putResult(FINDER_PATH_FETCH_BY_LOGOID, args, (Object)companyModelImpl, false);
    }

    protected void clearUniqueFindersCache(CompanyModelImpl companyModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{companyModelImpl.getWebId()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_WEBID, args);
            this.finderCache.removeResult(FINDER_PATH_FETCH_BY_WEBID, args);
        }
        if ((companyModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_WEBID.getColumnBitmask()) != 0L) {
            args = new Object[]{companyModelImpl.getOriginalWebId()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_WEBID, args);
            this.finderCache.removeResult(FINDER_PATH_FETCH_BY_WEBID, args);
        }
        if (clearCurrent) {
            args = new Object[]{companyModelImpl.getMx()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_MX, args);
            this.finderCache.removeResult(FINDER_PATH_FETCH_BY_MX, args);
        }
        if ((companyModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_MX.getColumnBitmask()) != 0L) {
            args = new Object[]{companyModelImpl.getOriginalMx()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_MX, args);
            this.finderCache.removeResult(FINDER_PATH_FETCH_BY_MX, args);
        }
        if (clearCurrent) {
            args = new Object[]{companyModelImpl.getLogoId()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_LOGOID, args);
            this.finderCache.removeResult(FINDER_PATH_FETCH_BY_LOGOID, args);
        }
        if ((companyModelImpl.getColumnBitmask() & FINDER_PATH_FETCH_BY_LOGOID.getColumnBitmask()) != 0L) {
            args = new Object[]{companyModelImpl.getOriginalLogoId()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_LOGOID, args);
            this.finderCache.removeResult(FINDER_PATH_FETCH_BY_LOGOID, args);
        }
    }

    public Company create(long companyId) {
        CompanyImpl company = new CompanyImpl();
        company.setNew(true);
        company.setPrimaryKey(companyId);
        return company;
    }

    public Company remove(long companyId) throws NoSuchCompanyException {
        return this.remove(Long.valueOf(companyId));
    }

    public Company remove(Serializable primaryKey) throws NoSuchCompanyException {
        Session session = null;
        try {
            session = this.openSession();
            Company company = (Company)session.get(CompanyImpl.class, primaryKey);
            if (company == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchCompanyException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            Company company2 = (Company)this.remove((BaseModel)company);
            return company2;
        }
        catch (NoSuchCompanyException nsee) {
            throw nsee;
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Company removeImpl(Company company) {
        company = this.toUnwrappedModel(company);
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)company)) {
                company = (Company)session.get(CompanyImpl.class, company.getPrimaryKeyObj());
            }
            if (company != null) {
                session.delete((Object)company);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        if (company != null) {
            this.clearCache(company);
        }
        return company;
    }

    public Company updateImpl(Company company) {
        company = this.toUnwrappedModel(company);
        boolean isNew = company.isNew();
        CompanyModelImpl companyModelImpl = (CompanyModelImpl)company;
        Session session = null;
        try {
            session = this.openSession();
            if (company.isNew()) {
                session.save((Object)company);
                company.setNew(false);
            } else {
                company = (Company)session.merge((Object)company);
            }
        }
        catch (Exception e) {
            throw this.processException(e);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!CompanyModelImpl.COLUMN_BITMASK_ENABLED) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{companyModelImpl.getSystem()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_SYSTEM, args);
            this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_SYSTEM, args);
            this.finderCache.removeResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY);
            this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL, FINDER_ARGS_EMPTY);
        } else if ((companyModelImpl.getColumnBitmask() & FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_SYSTEM.getColumnBitmask()) != 0L) {
            Object[] args = new Object[]{companyModelImpl.getOriginalSystem()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_SYSTEM, args);
            this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_SYSTEM, args);
            args = new Object[]{companyModelImpl.getSystem()};
            this.finderCache.removeResult(FINDER_PATH_COUNT_BY_SYSTEM, args);
            this.finderCache.removeResult(FINDER_PATH_WITHOUT_PAGINATION_FIND_BY_SYSTEM, args);
        }
        this.entityCache.putResult(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyImpl.class, (Serializable)Long.valueOf(company.getPrimaryKey()), (Serializable)company, false);
        this.clearUniqueFindersCache(companyModelImpl, false);
        this.cacheUniqueFindersCache(companyModelImpl);
        company.resetOriginalValues();
        return company;
    }

    protected Company toUnwrappedModel(Company company) {
        if (company instanceof CompanyImpl) {
            return company;
        }
        CompanyImpl companyImpl = new CompanyImpl();
        companyImpl.setNew(company.isNew());
        companyImpl.setPrimaryKey(company.getPrimaryKey());
        companyImpl.setMvccVersion(company.getMvccVersion());
        companyImpl.setCompanyId(company.getCompanyId());
        companyImpl.setAccountId(company.getAccountId());
        companyImpl.setWebId(company.getWebId());
        companyImpl.setKey(company.getKey());
        companyImpl.setMx(company.getMx());
        companyImpl.setHomeURL(company.getHomeURL());
        companyImpl.setLogoId(company.getLogoId());
        companyImpl.setSystem(company.isSystem());
        companyImpl.setMaxUsers(company.getMaxUsers());
        companyImpl.setActive(company.isActive());
        return companyImpl;
    }

    public Company findByPrimaryKey(Serializable primaryKey) throws NoSuchCompanyException {
        Company company = this.fetchByPrimaryKey(primaryKey);
        if (company == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchCompanyException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return company;
    }

    public Company findByPrimaryKey(long companyId) throws NoSuchCompanyException {
        return this.findByPrimaryKey(Long.valueOf(companyId));
    }

    public Company fetchByPrimaryKey(Serializable primaryKey) {
        Serializable serializable = this.entityCache.getResult(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyImpl.class, primaryKey);
        if (serializable == nullModel) {
            return null;
        }
        Company company = (Company)serializable;
        if (company == null) {
            Session session = null;
            try {
                session = this.openSession();
                company = (Company)session.get(CompanyImpl.class, primaryKey);
                if (company != null) {
                    this.cacheResult(company);
                } else {
                    this.entityCache.putResult(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyImpl.class, primaryKey, (Serializable)nullModel);
                }
            }
            catch (Exception e) {
                this.entityCache.removeResult(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyImpl.class, primaryKey);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return company;
    }

    public Company fetchByPrimaryKey(long companyId) {
        return this.fetchByPrimaryKey(Long.valueOf(companyId));
    }

    public Map<Serializable, Company> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        Session session;
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, Company> map = new HashMap<Serializable, Company>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            Company company = this.fetchByPrimaryKey(primaryKey);
            if (company != null) {
                map.put(primaryKey, company);
            }
            return map;
        }
        HashSet<Serializable> uncachedPrimaryKeys = null;
        for (Serializable serializable : primaryKeys) {
            Serializable serializable2 = this.entityCache.getResult(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyImpl.class, serializable);
            if (serializable2 == nullModel) continue;
            if (serializable2 == null) {
                if (uncachedPrimaryKeys == null) {
                    uncachedPrimaryKeys = new HashSet<Serializable>();
                }
                uncachedPrimaryKeys.add(serializable);
                continue;
            }
            map.put(serializable, (Company)serializable2);
        }
        if (uncachedPrimaryKeys == null) {
            return map;
        }
        StringBundler query = new StringBundler(uncachedPrimaryKeys.size() * 2 + 1);
        query.append(_SQL_SELECT_COMPANY_WHERE_PKS_IN);
        for (Serializable serializable : uncachedPrimaryKeys) {
            query.append(((Long)serializable).longValue());
            query.append(",");
        }
        query.setIndex(query.index() - 1);
        query.append(")");
        String string = query.toString();
        Session session2 = null;
        try {
            session = this.openSession();
            Query q = session.createQuery(string);
            for (Company company : q.list()) {
                map.put(company.getPrimaryKeyObj(), company);
                this.cacheResult(company);
                uncachedPrimaryKeys.remove(company.getPrimaryKeyObj());
            }
            for (Serializable serializable : uncachedPrimaryKeys) {
                this.entityCache.putResult(CompanyModelImpl.ENTITY_CACHE_ENABLED, CompanyImpl.class, serializable, (Serializable)nullModel);
            }
        }
        catch (Exception e) {
            try {
                throw this.processException(e);
            }
            catch (Throwable throwable) {
                this.closeSession(session2);
                throw throwable;
            }
        }
        this.closeSession(session);
        return map;
    }

    public List<Company> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<Company> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<Company> findAll(int start, int end, OrderByComparator<Company> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<Company> findAll(int start, int end, OrderByComparator<Company> orderByComparator, boolean retrieveFromCache) {
        boolean pagination = true;
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            pagination = false;
            finderPath = FINDER_PATH_WITHOUT_PAGINATION_FIND_ALL;
            finderArgs = FINDER_ARGS_EMPTY;
        } else {
            finderPath = FINDER_PATH_WITH_PAGINATION_FIND_ALL;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (retrieveFromCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler query = null;
            String sql = null;
            if (orderByComparator != null) {
                query = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                query.append(_SQL_SELECT_COMPANY);
                this.appendOrderByComparator(query, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = query.toString();
            } else {
                sql = _SQL_SELECT_COMPANY;
                if (pagination) {
                    sql = sql.concat(" ORDER BY company.companyId ASC");
                }
            }
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(sql);
                if (!pagination) {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end, (boolean)false);
                    Collections.sort(list);
                    list = Collections.unmodifiableList(list);
                } else {
                    list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
                }
                this.cacheResult(list);
                this.finderCache.putResult(finderPath, finderArgs, list);
            }
            catch (Exception e) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (Company company : this.findAll()) {
            this.remove((BaseModel)company);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query q = session.createQuery(_SQL_COUNT_COMPANY);
                count = (Long)q.uniqueResult();
                this.finderCache.putResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception e) {
                this.finderCache.removeResult(FINDER_PATH_COUNT_ALL, FINDER_ARGS_EMPTY);
                throw this.processException(e);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return CompanyModelImpl.TABLE_COLUMNS_MAP;
    }

    public void afterPropertiesSet() {
    }

    public void destroy() {
        this.entityCache.removeCache(CompanyImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }
}

