/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.struts;

import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.struts.PortletAction;
import java.io.OutputStream;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class RSSAction
extends PortletAction {
    private static final boolean _CHECK_METHOD_ON_PROCESS_ACTION = false;

    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        if (!this.isRSSFeedsEnabled((PortletRequest)actionRequest)) {
            PortalUtil.sendRSSFeedsDisabledError((PortletRequest)actionRequest, (PortletResponse)actionResponse);
            return;
        }
        try {
            HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)actionRequest);
            HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)actionResponse);
            ServletResponseUtil.sendFile((HttpServletRequest)request, (HttpServletResponse)response, null, (byte[])this.getRSS(request), (String)"text/xml; charset=UTF-8");
            this.setForward((PortletRequest)actionRequest, "/common/null.jsp");
        }
        catch (Exception e) {
            PortalUtil.sendError((Exception)e, (ActionRequest)actionRequest, (ActionResponse)actionResponse);
        }
    }

    @Override
    public void serveResource(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        if (!this.isRSSFeedsEnabled((PortletRequest)resourceRequest)) {
            PortalUtil.sendRSSFeedsDisabledError((PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
            return;
        }
        resourceResponse.setContentType("text/xml; charset=UTF-8");
        try (OutputStream outputStream = resourceResponse.getPortletOutputStream();){
            byte[] bytes = this.getRSS(resourceRequest, resourceResponse);
            outputStream.write(bytes);
        }
    }

    @Override
    public ActionForward strutsExecute(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (!PortalUtil.isRSSFeedsEnabled()) {
            PortalUtil.sendRSSFeedsDisabledError((HttpServletRequest)request, (HttpServletResponse)response);
            return null;
        }
        try {
            ServletResponseUtil.sendFile((HttpServletRequest)request, (HttpServletResponse)response, null, (byte[])this.getRSS(request), (String)"text/xml; charset=UTF-8");
            return null;
        }
        catch (Exception e) {
            PortalUtil.sendError((Exception)e, (HttpServletRequest)request, (HttpServletResponse)response);
            return null;
        }
    }

    protected byte[] getRSS(HttpServletRequest request) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected byte[] getRSS(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)resourceRequest);
        return this.getRSS(request);
    }

    @Override
    protected boolean isCheckMethodOnProcessAction() {
        return false;
    }

    protected boolean isRSSFeedsEnabled(PortletRequest portletRequest) throws Exception {
        return PortalUtil.isRSSFeedsEnabled();
    }
}

